/*	EKN -- Eine Kleine Netmusic (Netscore network music server) psl 2/89 */

#include	<sys/signal.h>
#include	<sys/wait.h>
#include	<midi.h>
#include	<stdio.h>
#undef	loop

#define	LOGON	"echo \"Subject: Exec Netscore\" | /usr/ucb/rsh yquem /bin/mail psl&"
#define	LOGOFF	"echo \"Subject: Exit Netscore\" | /usr/ucb/rsh yquem /bin/mail psl"

#define	BARLEN	(2*MPU_CLOCK_PERIOD)
#define	ACCA	"acca"
#define	ACCL	"accl"
#define	INST	"inst"
#define	MCLEAN	"mpuclean"
#define	MERGE	"merge"
#define	MKCC	"mkcc"
#define	PLAY	"play"
#define	MAXSAV	16
#define	MSFLEN	24
#define	FALSE	0
#define	TRUE	1
#define	MAGIC	0x44

/* channel numbers in the BELLSCORE files (also used as initial settings) */
#define	BCHAN	2
#define	CCHAN	3
#define	DCHAN0	10
#define	DCHAN1	11
#define	LCHAN	4

#define	DBG	if(Debug)fprintf

struct	stylstr	{
	char	*name;		/* for programs */
	int	barlen;		/* bar length (MPU clocks) */
	int	units;		/* length quantum (MPU clocks) */
	int	key;		/* current key */
	int	tempo;		/* current tempo */
	char	*lname;		/* for people (files & button labels)*/
	char	*desc;		/* description (for menu) */
	int	binst;		/* bass inst */
	int	bchan;		/* bass chan */
	int	bvelo;		/* bass velocity */
	int	cinst;		/* chording instrument */
	int	cchan;		/* chord chan */
	int	cvelo;		/* chord velocity */
	int	dchan;		/* drum chan */
	int	dvelo;		/* drum velocity */
	int	linst;		/* lead instrument */
	int	lchan;		/* lead chan */
	int	lvelo;		/* lead velocity */
	int	lseed;		/* lead seed */
	int	lener;		/* lead energy */
} S[32]	= {
	{ "grass", 480,	480,	7, 137, "BLUEGRASS", "Bluegrass Banjo",
		94,BCHAN,80,  101,CCHAN,64,  DCHAN0,64,  105,LCHAN,96,0,50 },
	{ "class", 480,	960,	0, 105, "CLASSICAL", "Alberti Bass",
		17,BCHAN,64,  33,CCHAN,64,  DCHAN0,64,  17,LCHAN,80,0,50 },
	{ "march", 480,	960,	8, 112, "MARCH", "Strident March",
		48,BCHAN,64,  38,CCHAN,64,  DCHAN0,64,  41,LCHAN,80,0,50 },
	{ "mozar", 360,	360,	0, 96, "MOZART", "Mozart's Dice",
		17,BCHAN,64,  33,CCHAN,64,  DCHAN0,64,  17,LCHAN,80,0,50 },
	{ "samba", 480,	960,	4, 120, "SAMBA", "Latin Samba",
		87,BCHAN,64,  7,CCHAN,64,  DCHAN0,64,  71,LCHAN,80,0,50 },
#define	DEFSTYLE	5
	{ "swing", 480,	960,	10, 120, "SWING", "Swing Combo Jazz",
		89,BCHAN,64,  2,CCHAN,64,  DCHAN0,64,  57,LCHAN,80,0,50 },
#ifndef	LINT
	{ (char *) 0, },
#endif
};

struct	stylstr	*Sp	= &S[DEFSTYLE];		/* current style struct */

char	File[64];
char	Sysbuf[512];		/* for sys() calls */
int	Syschan	= 10;		/* D110 system channel */
int	Ipatch	= 64;		/* initial D110 patch */
int	Styl;			/* musical "style" */
int	Debug = 1;		/* choose debugging */
int	Dpart;			/* drum part to use */
int	Nunits[]	= { 8, 16, 6, 12, 5, 16, 9, 32, 0 };
int	Nui	= 0;		/* index into Nunits */

char	*namegen();
extern	char	*key2pc();

main(argc, argv)
char	*argv[];
{
	char buf[512], files[2][64], *pp;
	int fh[2], cur, nxt, i;
	struct	hdrstr	{
		u_char	magic;	/* should be MAGIC */
		u_char	tempo;
	} hdr;

	setbuf(stderr, 0);
DBG(stderr, "%d: %s\n", getpid(), argv[0]);
	system(LOGON);
	Styl = DEFSTYLE;
	Sp = &S[Styl];
DBG(stderr, "%d: about to procargs()\n", getpid());
	if (!procargs(argc, argv))
	    exit(2);
	sprintf(File, "/tmp/netscore%d", getpid());
	for (i = 0; i < 2; i++) {
	    sprintf(files[i], "%s%d", File, i);
	    sprintf(buf, "touch %s", files[i]);
	    sys(buf);
	    fh[i] = open(files[i], 0);
	}
	cur = 0;
	nxt = 1;
	prepare(files[cur], 1);
	hdr.magic = MAGIC;
	hdr.tempo = Sp->tempo;
	write(1, &hdr, sizeof hdr);
	prepare(files[nxt], 0);
DBG(stderr, "%d: about to loop()\n", getpid());
	for (;;) {
	    while ((i = read(fh[cur], buf, sizeof buf)) <= 0) {
		wait3(0, WNOHANG, 0);	/* reap any zombies */
		cur ^= 1; nxt ^= 1;
		lseek(fh[cur], 0L, 0);
		prepare(files[nxt], 0);
	    }
	    write(1, buf, i);
DBG(stderr, "%d: Waiting for \"MORE\"\n", getpid());
	    for (pp = "MORE\n";;) {
		read(0, buf, 1);
		if (*buf == *pp) {
		    if (*pp++ == '\n')
			break;
		} else
		    pp = "MORE\n";
	    }
	}
}

prepare(fnam, block)
char	*fnam;
{
	char buf[256];
	int bars, dpu, dpn;
	extern double atof();

	while (!(bars = Nunits[Nui++]))
	    Nui = 0;
	if (!block && fork())
	    return;
	bars = (Sp->units * bars) / Sp->barlen;
DBG(stderr, "%d: tempo=%d, %d bars\n", getpid(), Sp->tempo, bars);
	sprintf(Sysbuf, "%s -b%d -k%s -s%s >%s.cc",
	 MKCC, bars, key2pc(Sp->key), Sp->name, fnam);
	sys(Sysbuf);
	dpu = Dpart? DCHAN1 : DCHAN0;	/* drum part to use */
	dpn = Dpart? DCHAN0 : DCHAN1;	/* drum part not used */
	sprintf(buf,
	 "%s -c%d=%d -v%d=%d -c%d=%d -v%d=%d -c%d=%d -c0=%d -v%d=%d -t%d",
	 ACCA,
	 Sp->bchan, BCHAN, Sp->bchan, Sp->bvelo,
	 Sp->cchan, CCHAN, Sp->cchan, Sp->cvelo,
	 Sp->dchan, dpu, dpn, Sp->dchan, Sp->dvelo, Sp->dchan);
	sprintf(Sysbuf, "%s %s.cc >%s.acc", buf, fnam, fnam);
	sys(Sysbuf);
	sprintf(buf, "%s -b%d, -c%d -e%d -k%s -s%d -v%d",
	 ACCL, bars, Sp->lchan, Sp->lener, key2pc(Sp->key),
	 Sp->lseed, Sp->lvelo);
	sprintf(Sysbuf, "%s %s.cc >%s.lead", buf, fnam, fnam);
	sys(Sysbuf);
	sprintf(Sysbuf, "%s -d %d=%d %d=%d %d=%d %d=%d >%s",
	 INST, Syschan, Ipatch, Sp->bchan, Sp->binst,
	 Sp->cchan, Sp->cinst, Sp->lchan, Sp->linst, fnam);
	sys(Sysbuf);
	if (Sp->lchan)
	    sprintf(Sysbuf, "%s %s.lead %s.acc | %s >>%s",
	     MERGE, fnam, fnam, MCLEAN, fnam);
	else
	    sprintf(Sysbuf, "%s <%s.acc >>%s", MCLEAN, fnam, fnam);
	sys(Sysbuf);
	sprintf(Sysbuf, "bars -h1 /dev/null >>%s", fnam);
	sys(Sysbuf);
	if (!block)
	    exit(0);
}

/*VARARGS3*/
forkexec(in, out, p, a1, a2, a3, a4)
char	*p, *a1, *a2, *a3, *a4;
{
	register int pid;

DBG(stderr, "%d: forkexec(%d, %d, %s", getpid(), in, out, p);
if (Debug) {	if (a1) { fprintf(stderr, ", %s", a1);
		 if (a2) { fprintf(stderr, ", %s", a2);
		  if (a3) { fprintf(stderr, ", %s", a3);
		   if (a4) { fprintf(stderr, ", %s", a4);
		}}}}
}
DBG(stderr, ")\n");
	switch (pid = fork()) {
	case -1:
	    perror("fork()");
	    break;
	case 0:
	    close(0);
	    if (in >= 0)
		dup2(0, in);
	    close(1);
	    if (out >= 0)
		dup2(1, out);
	    execlp(p, p, a1, a2, a3, a4, 0);
	    perror(p);
	    exit(1);
	}
	return(pid);
}

cleanup()
{
	if (*File) {
	    sprintf(Sysbuf, "rm -f %s*", File);
	    sys(Sysbuf);
	}
}

sys(buf)
char	*buf;
{
DBG(stderr, "%d: %s\n", getpid(), buf);
	system(buf);
}

procargs(argc, argv)
char	*argv[];
{
	int i, s;

	for (i = 1; i < argc; i++) {
	    if (argv[i][0] == '-') {
		switch (argv[i][1]) {
		case 's':
		    for (s = 0; S[s].name; s++)
			if (strcmp(&argv[i][2], S[s].name) == 0)
			    break;
		    if (!S[s].name)
			goto syntax;
		    Styl = s;
		    Sp = &S[Styl];
		    break;
		default:
		    goto syntax;
		}
	    } else {
syntax:
		fprintf(stderr, "Usage: %s [-sSTYLE]\n", argv[0]);
		return(0);
	    }
	}
	return(1);
}
