#!/bin/sh

# Don't write anything if we don't know our bootdev
[ -f /tmp/net.ifaces ] || return 1

read IFACES < /tmp/net.ifaces

for netif in $IFACES ; do
    # bridge?
    unset bridge
    if [ "$netif" = "$bridgename" ]; then
        bridge=yes
    fi
    cat /sys/class/net/$netif/address > /tmp/net.$netif.hwaddr
    echo "# Generated by dracut initrd" > /tmp/net.$netif.ifcfg
    echo "DEVICE=$netif" >> /tmp/net.$netif.ifcfg
    echo "ONBOOT=yes" >> /tmp/net.$netif.ifcfg
    if [ -f /tmp/net.$netif.lease ]; then
	echo "BOOTPROTO=dhcp" >> /tmp/net.$netif.ifcfg
    else
	echo "BOOTPROTO=none" >> /tmp/net.$netif.ifcfg
        # If we've booted with static ip= lines, the override file is there
	. /tmp/net.$netif.override 
	echo "IPADDR=$ip" >> /tmp/net.$netif.ifcfg
	echo "NETMASK=$mask" >> /tmp/net.$netif.ifcfg
	[ -n "$gw" ] && echo "GATEWAY=$gw" >> /tmp/net.$netif.ifcfg
    fi

    # bridge needs differente things written to ifcfg
    if [ -z "$bridge" ]; then
        # standard interface
        echo "HWADDR=$(cat /sys/class/net/$netif/address)" >> /tmp/net.$netif.ifcfg
        echo "TYPE=Ethernet" >> /tmp/net.$netif.ifcfg
        echo "NAME=\"Boot Disk\"" >> /tmp/net.$netif.ifcfg
    else
        # bridge
	echo "TYPE=Bridge" >> /tmp/net.$netif.ifcfg
        echo "NAME=\"Boot Disk\"" >> /tmp/net.$netif.ifcfg
        # write separate ifcfg file for the raw eth interface
        echo "DEVICE=$ethname" >> /tmp/net.$ethname.ifcfg
        echo "TYPE=Ethernet" >> /tmp/net.$ethname.ifcfg
        echo "ONBOOT=yes" >> /tmp/net.$ethname.ifcfg
        echo "HWADDR=$(cat /sys/class/net/$ethname/address)" >> /tmp/net.$ethname.ifcfg
        echo "BRIDGE=$netif" >> /tmp/net.$ethname.ifcfg
        echo "NAME=$ethname" >> /tmp/net.$ethname.ifcfg
    fi
done
