/* Copyright (C) 1998, 1999 Thorsten Kukuk
   Author: Thorsten Kukuk <kukuk@suse.de>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */

#if defined(HAVE_CONFIG_H)
#include "config.h"
#endif

#include <string.h>
#include <locale.h>
#include <libintl.h>
#include <rpcsvc/nis.h>
#include "nispasswd.h"

#ifndef _
#define _(String) gettext (String)
#endif

#define NISENTRYVAL(res) \
        ((res)->objects.objects_val->zo_data.objdata_u.en_data.en_cols.en_cols_val[1].ec_value.ec_value_val)

#define NISENTRYFLAG(res) \
        ((res)->objects.objects_val->zo_data.objdata_u.en_data.en_cols.en_cols_val[1].ec_flags)

#define NISENTRYLEN(res) \
        ((res)->objects.objects_val->zo_data.objdata_u.en_data.en_cols.en_cols_val[1].ec_value.ec_value_len)

int
npd_lock (char *domainname, char *username)
{
  nis_result *result;
  nis_object *obj;
  char buf[strlen (username) + 30 + strlen (domainname)];

  if (strlen (domainname) > 0)
    sprintf (buf, "[name=%s],passwd.org_dir.%s", username, domainname);
  else
    sprintf (buf, "[name=%s],passwd.org_dir", username);

  result = nis_list (buf, EXPAND_NAME, NULL, NULL);

  if (result->status != NIS_SUCCESS)
    {
      fprintf (stderr, _("nispasswd: Couldn't lock user \"%s\"\n"), username);
      fprintf (stderr,   "           %s\n", nis_sperrno (result->status));
      return 3;
    }
  free (NISENTRYVAL (result));
  NISENTRYVAL (result) = strdup ("*LK*");
  NISENTRYLEN (result) = 4;
  NISENTRYFLAG (result) = NISENTRYFLAG (result) | EN_MODIFIED;
  obj = nis_clone_object (result->objects.objects_val, NULL);
  nis_freeresult (result);
  {
    char buf2[strlen (obj->zo_name) + strlen (obj->zo_domain) + 10];

    sprintf (buf2, "%s.%s", obj->zo_name, obj->zo_domain);
    result = nis_modify_entry (buf2, obj, 0);
    nis_free_object (obj);
    if (result->status != NIS_SUCCESS)
      {
	fprintf (stderr, _("nispasswd: Couldn't lock user \"%s\"\n"),
		 username);
	fprintf (stderr,   "           %s\n", nis_sperrno (result->status));
	return 1;
      }
  }
  return 0;
}
