
#define BASS_DRM 128
#define FLOORTOM 129
#define CYMBAL_D 130
#define RG_SNARE 131
#define RIM_SHOT 132
#define BONGO_DR 133
#define AC_SNARE 134
#define RIDE_CYM 135

#define TOM__TOM 136
#define CONGA_DR 137
#define BELL_DRM 138
#define LOG_DRUM 139
#define TRIANGLE 140
#define MARACCAS 141
#define TAMBRINE 142
#define TIMBALE_ 143

#define TINKLE_B 112
#define AGOGO_BL 113
#define STEEL_DR 114
#define WOOD_BLK 115
#define TAIKO_DR 116
#define MEL__TOM 117
#define SYNTH_DR 118
#define REV_CYMB 119

#define LOW_DNOTE 36
#define MID_DNOTE 48
#define HGH_DNOTE 60
#define CYM_DNOTE 60

#define LOW_TNOTE 41
#define MID_TNOTE 44
#define MDH_TNOTE 46
#define HGH_TNOTE 48

struct d_type{
	char *dname;
	char dv;
	char dnote;
} d_voice[47] = {
	"Acoustic Bass Drum",	BASS_DRM,  LOW_TNOTE,
	"Bass Drum 1",		BASS_DRM,  MID_TNOTE,
	"Side Stick",		RIM_SHOT,  HGH_DNOTE,
	"Acoustic Snare",	SYNTH_DR,  HGH_DNOTE,
	"Hand Clap",		RIM_SHOT,  HGH_DNOTE,
	"Electric Snare",	AC_SNARE,  HGH_DNOTE,
	"Low Floor Tom",	FLOORTOM,  LOW_TNOTE,
	"Closed High Hat",	RIDE_CYM,  79,

	"Hi Floor Tom",		FLOORTOM,  HGH_TNOTE,
	"Pedal High Hat",	REV_CYMB,  CYM_DNOTE,
	"Low Tom",		MEL__TOM,  LOW_TNOTE,
	"Open High Hat",	REV_CYMB,  64,
	"Low-Mid Tom",		MEL__TOM,  MID_TNOTE,
	"High-Mid Tom",		MEL__TOM,  MDH_TNOTE,
	"Crash Cymbal 1",	CYMBAL_D,  79,
	"High Tom",		MEL__TOM,  HGH_TNOTE,

	"Ride Cymbal 1",	RIDE_CYM,  CYM_DNOTE,
	"Chinese Cymbal",	CYMBAL_D,  71,
	"Ride Bell",		BELL_DRM,  HGH_DNOTE,
	"Tambourine",		TAMBRINE,  65,
	"Splash Cymbal",	CYMBAL_D,  79,
	"Cow Bell",		BELL_DRM,  HGH_DNOTE,
	"Crash Cymbal 2",	CYMBAL_D,  HGH_DNOTE,
	"Vibraslap",		MEL__TOM,  HGH_DNOTE,

	"Ride Cymbal 2",	RIDE_CYM,  64,
	"High Bongo",		BONGO_DR,  HGH_TNOTE,
	"Low Bongo",		BONGO_DR,  LOW_TNOTE,
	"Mute High Conga",	CONGA_DR,  MID_TNOTE,
	"Open High Conga",	CONGA_DR,  HGH_TNOTE,
	"Low Conga",		CONGA_DR,  LOW_TNOTE,
	"High Timbale",		TIMBALE_,  HGH_DNOTE,
	"Low Timbale",		TIMBALE_,  LOW_DNOTE,

	"High Agogo",		WOOD_BLK,  MID_DNOTE,
	"Low Agogo",		WOOD_BLK,  LOW_DNOTE,
	"Cabasa",		WOOD_BLK,  MID_DNOTE,
	"Maraccas",		MARACCAS,  50,
	"Short Whistle",	BELL_DRM,  MID_DNOTE,
	"Long Whistle",		BELL_DRM,  HGH_DNOTE,
	"Short Guiro",		BELL_DRM,  MID_DNOTE,
	"Long Guiro",		BELL_DRM,  HGH_DNOTE,

	"Claves",		WOOD_BLK,  69,
	"High Wood Block",	WOOD_BLK,  63,
	"Low Wood Block",	WOOD_BLK,  58,
	"Mute Cuica",		WOOD_BLK,  LOW_DNOTE,
	"Open Cuica",		WOOD_BLK,  HGH_DNOTE,
	"Mute Triangle",	BELL_DRM,  HGH_DNOTE,
	"Open Triangle",	TRIANGLE,  HGH_DNOTE
};
