/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.swingui;

import ca.sqlpower.swingui.SPSUtils;
import ca.sqlpower.swingui.SwingWorkerRegistry;
import ca.sqlpower.swingui.event.TaskTerminationEvent;
import ca.sqlpower.swingui.event.TaskTerminationListener;
import ca.sqlpower.util.Monitorable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public abstract class SPSwingWorker
implements Runnable,
Monitorable {
    private static final Logger logger = Logger.getLogger(SPSwingWorker.class);
    private Throwable doStuffException;
    private final SwingWorkerRegistry registry;
    private final Object responsibleObject;
    private SPSwingWorker nextProcess;
    private boolean cancelled;
    private Thread thread;
    private final List<TaskTerminationListener> taskTerminationListeners = new ArrayList<TaskTerminationListener>();
    private boolean started;
    private boolean finished;
    private int progress;
    private String message;
    private Integer jobSize;
    private String cleanupExceptionMessage = "A problem occurred.";

    public SPSwingWorker(SwingWorkerRegistry registry, Object responsibleObject) {
        if (registry == null) {
            throw new NullPointerException("Null worker registry is not permitted");
        }
        this.registry = registry;
        this.responsibleObject = responsibleObject;
    }

    public SPSwingWorker(SwingWorkerRegistry registry) {
        this(registry, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        try {
            this.setStarted(true);
            this.setFinished(false);
            this.registry.registerSwingWorker(this);
            this.thread = Thread.currentThread();
            try {
                this.doStuff();
            }
            catch (Throwable e) {
                this.doStuffException = e;
                logger.debug((Object)e.getStackTrace());
            }
            SwingUtilities.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        try {
                            SPSwingWorker.this.cleanup();
                        }
                        finally {
                            SPSwingWorker.this.setFinished(true);
                            SPSwingWorker.this.fireTaskFinished();
                        }
                        if (SPSwingWorker.this.nextProcess != null) {
                            SPSwingWorker.this.nextProcess.setCancelled(SPSwingWorker.this.cancelled);
                            new Thread(SPSwingWorker.this.nextProcess).start();
                        }
                    }
                    catch (Exception e) {
                        SPSUtils.showExceptionDialogNoReport(SPSwingWorker.this.cleanupExceptionMessage, e);
                    }
                }
            });
        }
        finally {
            this.registry.removeSwingWorker(this);
            this.thread = null;
        }
    }

    public abstract void cleanup() throws Exception;

    public abstract void doStuff() throws Exception;

    public Throwable getDoStuffException() {
        return this.doStuffException;
    }

    public void setDoStuffException(Throwable e) {
        this.doStuffException = e;
    }

    public String getCleanupExceptionMessage() {
        return this.cleanupExceptionMessage;
    }

    public void setCleanupExceptionMessage(String cleanupExceptionMessage) {
        this.cleanupExceptionMessage = cleanupExceptionMessage;
    }

    @Override
    public synchronized boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public synchronized void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }

    public SPSwingWorker getNextProcess() {
        return this.nextProcess;
    }

    public void setNextProcess(SPSwingWorker nextProcess) {
        logger.debug((Object)("Moving to object:" + nextProcess));
        this.nextProcess = nextProcess;
    }

    public void addTaskTerminationListener(TaskTerminationListener ttl) {
        this.taskTerminationListeners.add(ttl);
    }

    public void removeTaskTerminationListener(TaskTerminationListener ttl) {
        this.taskTerminationListeners.remove(ttl);
    }

    private void fireTaskFinished() {
        TaskTerminationEvent tte = new TaskTerminationEvent(this);
        for (int i = this.taskTerminationListeners.size() - 1; i >= 0; --i) {
            this.taskTerminationListeners.get(i).taskFinished(tte);
        }
    }

    public void kill() {
        if (this.thread != null) {
            this.thread.interrupt();
        }
        this.setCancelled(true);
    }

    @Override
    public final synchronized Integer getJobSize() {
        return this.getJobSizeImpl();
    }

    protected Integer getJobSizeImpl() {
        return this.jobSize;
    }

    public final synchronized void setJobSize(Integer newJobSize) {
        this.jobSize = newJobSize;
    }

    @Override
    public final synchronized String getMessage() {
        return this.getMessageImpl();
    }

    protected String getMessageImpl() {
        return this.message;
    }

    public final synchronized void setMessage(String newMessage) {
        this.message = newMessage;
    }

    @Override
    public final synchronized int getProgress() {
        return this.getProgressImpl();
    }

    protected int getProgressImpl() {
        return this.progress;
    }

    public final synchronized void setProgress(int newProgress) {
        this.progress = newProgress;
    }

    public final synchronized void increaseProgress() {
        ++this.progress;
    }

    @Override
    public final synchronized boolean hasStarted() {
        return this.hasStartedImpl();
    }

    protected boolean hasStartedImpl() {
        return this.started;
    }

    @Override
    public final synchronized boolean isFinished() {
        return this.isFinishedImpl();
    }

    protected boolean isFinishedImpl() {
        return this.finished;
    }

    protected final synchronized void setStarted(boolean started) {
        this.started = started;
    }

    protected final synchronized void setFinished(boolean finished) {
        this.finished = finished;
    }

    public Object getResponsibleObject() {
        return this.responsibleObject;
    }
}

