/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.creditcardvalidator;

import java.util.List;
import java.util.Map;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Counter;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.creditcardvalidator.CreditCardValidator;
import org.pentaho.di.trans.steps.creditcardvalidator.CreditCardValidatorData;
import org.pentaho.di.trans.steps.creditcardvalidator.Messages;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreditCardValidatorMeta
extends BaseStepMeta
implements StepMetaInterface {
    private String fieldname;
    private String cardtype;
    private String notvalidmsg;
    private String resultfieldname;
    private boolean onlydigits;

    public String getDynamicField() {
        return this.fieldname;
    }

    public void setDynamicField(String fieldname) {
        this.fieldname = fieldname;
    }

    public String getResultFieldName() {
        return this.resultfieldname;
    }

    public void setOnlyDigits(boolean onlydigits) {
        this.onlydigits = onlydigits;
    }

    public boolean isOnlyDigits() {
        return this.onlydigits;
    }

    public void setResultFieldName(String resultfieldname) {
        this.resultfieldname = resultfieldname;
    }

    public void setCardType(String cardtype) {
        this.cardtype = cardtype;
    }

    public String getCardType() {
        return this.cardtype;
    }

    public void setNotValidMsg(String notvalidmsg) {
        this.notvalidmsg = notvalidmsg;
    }

    public String getNotValidMsg() {
        return this.notvalidmsg;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleXMLException {
        this.readData(stepnode);
    }

    @Override
    public Object clone() {
        CreditCardValidatorMeta retval = (CreditCardValidatorMeta)super.clone();
        return retval;
    }

    @Override
    public void setDefault() {
        this.resultfieldname = "result";
        this.onlydigits = false;
        this.cardtype = "card type";
        this.notvalidmsg = "not valid message";
    }

    @Override
    public void getFields(RowMetaInterface inputRowMeta, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space) throws KettleStepException {
        String realcardtype;
        String realresultfieldname = space.environmentSubstitute(this.resultfieldname);
        if (!Const.isEmpty((String)realresultfieldname)) {
            ValueMeta v = new ValueMeta(realresultfieldname, 4);
            v.setOrigin(name);
            inputRowMeta.addValueMeta((ValueMetaInterface)v);
        }
        if (!Const.isEmpty((String)(realcardtype = space.environmentSubstitute(this.cardtype)))) {
            ValueMeta v = new ValueMeta(realcardtype, 2);
            v.setOrigin(name);
            inputRowMeta.addValueMeta((ValueMetaInterface)v);
        }
        String realnotvalidmsg = space.environmentSubstitute(this.notvalidmsg);
        if (!Const.isEmpty((String)this.notvalidmsg)) {
            ValueMeta v = new ValueMeta(realnotvalidmsg, 2);
            v.setOrigin(name);
            inputRowMeta.addValueMeta((ValueMetaInterface)v);
        }
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer();
        retval.append("    " + XMLHandler.addTagValue((String)"fieldname", (String)this.fieldname));
        retval.append("    " + XMLHandler.addTagValue((String)"resultfieldname", (String)this.resultfieldname));
        retval.append("    " + XMLHandler.addTagValue((String)"cardtype", (String)this.cardtype));
        retval.append("    ").append(XMLHandler.addTagValue((String)"onlydigits", (boolean)this.onlydigits));
        retval.append("    " + XMLHandler.addTagValue((String)"notvalidmsg", (String)this.notvalidmsg));
        return retval.toString();
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            this.fieldname = XMLHandler.getTagValue((Node)stepnode, (String)"fieldname");
            this.resultfieldname = XMLHandler.getTagValue((Node)stepnode, (String)"resultfieldname");
            this.cardtype = XMLHandler.getTagValue((Node)stepnode, (String)"cardtype");
            this.notvalidmsg = XMLHandler.getTagValue((Node)stepnode, (String)"notvalidmsg");
            this.onlydigits = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"onlydigits"));
        }
        catch (Exception e) {
            throw new KettleXMLException(Messages.getString("CreditCardValidatorMeta.Exception.UnableToReadStepInfo"), (Throwable)e);
        }
    }

    @Override
    public void readRep(Repository rep, long id_step, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleException {
        try {
            this.fieldname = rep.getStepAttributeString(id_step, "fieldname");
            this.resultfieldname = rep.getStepAttributeString(id_step, "resultfieldname");
            this.cardtype = rep.getStepAttributeString(id_step, "cardtype");
            this.notvalidmsg = rep.getStepAttributeString(id_step, "notvalidmsg");
            this.onlydigits = rep.getStepAttributeBoolean(id_step, "onlydigits");
        }
        catch (Exception e) {
            throw new KettleException(Messages.getString("CreditCardValidatorMeta.Exception.UnexpectedErrorReadingStepInfo"), (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_transformation, long id_step) throws KettleException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "fieldname", this.fieldname);
            rep.saveStepAttribute(id_transformation, id_step, "resultfieldname", this.resultfieldname);
            rep.saveStepAttribute(id_transformation, id_step, "cardtype", this.cardtype);
            rep.saveStepAttribute(id_transformation, id_step, "notvalidmsg", this.notvalidmsg);
            rep.saveStepAttribute(id_transformation, id_step, "onlydigits", this.onlydigits);
        }
        catch (Exception e) {
            throw new KettleException(Messages.getString("CreditCardValidatorMeta.Exception.UnableToSaveStepInfo") + id_step, (Throwable)e);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info) {
        CheckResult cr;
        String error_message = "";
        String realresultfieldname = transMeta.environmentSubstitute(this.resultfieldname);
        if (Const.isEmpty((String)realresultfieldname)) {
            error_message = Messages.getString("CreditCardValidatorMeta.CheckResult.ResultFieldMissing");
            cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            error_message = Messages.getString("CreditCardValidatorMeta.CheckResult.ResultFieldOK");
            cr = new CheckResult(1, error_message, (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (Const.isEmpty((String)this.fieldname)) {
            error_message = Messages.getString("CreditCardValidatorMeta.CheckResult.CardFieldMissing");
            cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            error_message = Messages.getString("CreditCardValidatorMeta.CheckResult.CardFieldOK");
            cr = new CheckResult(1, error_message, (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, Messages.getString("CreditCardValidatorMeta.CheckResult.ReceivingInfoFromOtherSteps"), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, Messages.getString("CreditCardValidatorMeta.CheckResult.NoInpuReceived"), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new CreditCardValidator(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new CreditCardValidatorData();
    }

    @Override
    public boolean supportsErrorHandling() {
        return true;
    }
}

