/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeinsights.impl.base.inspections;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.openapi.project.Project;
import com.intellij.psi.tree.TokenSet;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.diagnostics.KaDiagnosticWithPsi;
import org.jetbrains.kotlin.idea.base.psi.KotlinPsiUtils;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.applicable.inspections.KotlinDiagnosticBasedInspectionBase;
import org.jetbrains.kotlin.idea.codeinsight.api.applicable.inspections.KotlinModCommandQuickFix;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtVisitorVoid;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b&\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u00020\u00030\u00022\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u00020\u00050\u00042\u00020\u0006:\u0002\u0016\u0017B\u000f\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0005H\u0014J\u0010\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0003H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/codeinsights/impl/base/inspections/RedundantModifierInspectionBase;", "DIAGNOSTIC", "Lorg/jetbrains/kotlin/analysis/api/diagnostics/KaDiagnosticWithPsi;", "Lorg/jetbrains/kotlin/psi/KtModifierListOwner;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/applicable/inspections/KotlinDiagnosticBasedInspectionBase;", "Lorg/jetbrains/kotlin/idea/codeinsights/impl/base/inspections/RedundantModifierInspectionBase$ModifierContext;", "Lcom/intellij/codeInspection/CleanupLocalInspectionTool;", "modifierSet", "Lcom/intellij/psi/tree/TokenSet;", "<init>", "(Lcom/intellij/psi/tree/TokenSet;)V", "buildVisitor", "Lorg/jetbrains/kotlin/psi/KtVisitorVoid;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "getProblemDescription", "", "element", "context", "isApplicableByPsi", "ModifierContext", "RemoveRedundantModifierQuickFixBase", "kotlin.code-insight.impl-base"})
public abstract class RedundantModifierInspectionBase<DIAGNOSTIC extends KaDiagnosticWithPsi<? extends KtModifierListOwner>>
extends KotlinDiagnosticBasedInspectionBase<KtModifierListOwner, DIAGNOSTIC, ModifierContext>
implements CleanupLocalInspectionTool {
    @NotNull
    private final TokenSet modifierSet;

    public RedundantModifierInspectionBase(@NotNull TokenSet modifierSet) {
        Intrinsics.checkNotNullParameter((Object)modifierSet, (String)"modifierSet");
        this.modifierSet = modifierSet;
    }

    @NotNull
    public KtVisitorVoid buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new KtVisitorVoid(this, holder, isOnTheFly){
            final /* synthetic */ RedundantModifierInspectionBase<DIAGNOSTIC> this$0;
            final /* synthetic */ ProblemsHolder $holder;
            final /* synthetic */ boolean $isOnTheFly;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
                this.$isOnTheFly = $isOnTheFly;
            }

            public void visitDeclaration(KtDeclaration dcl) {
                Intrinsics.checkNotNullParameter((Object)dcl, (String)"dcl");
                RedundantModifierInspectionBase.access$visitTargetElement(this.this$0, (KtModifierListOwner)dcl, this.$holder, this.$isOnTheFly);
            }
        };
    }

    @Override
    @NotNull
    protected String getProblemDescription(@NotNull KtModifierListOwner element, @NotNull ModifierContext context2) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Object[] objectArray = new Object[]{context2.getModifier().getValue()};
        return KotlinBundle.message((String)"redundant.0.modifier", (Object[])objectArray);
    }

    @Override
    public boolean isApplicableByPsi(@NotNull KtModifierListOwner element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        KtModifierList ktModifierList = element.getModifierList();
        return (ktModifierList != null ? ktModifierList.getModifier(this.modifierSet) : null) != null;
    }

    public static final /* synthetic */ void access$visitTargetElement(RedundantModifierInspectionBase $this, KtModifierListOwner element, ProblemsHolder holder, boolean isOnTheFly) {
        $this.visitTargetElement((KtElement)element, holder, isOnTheFly);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/codeinsights/impl/base/inspections/RedundantModifierInspectionBase$ModifierContext;", "", "modifier", "Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "<init>", "(Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;)V", "getModifier", "()Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "kotlin.code-insight.impl-base"})
    public static final class ModifierContext {
        @NotNull
        private final KtModifierKeywordToken modifier;

        public ModifierContext(@NotNull KtModifierKeywordToken modifier) {
            Intrinsics.checkNotNullParameter((Object)modifier, (String)"modifier");
            this.modifier = modifier;
        }

        @NotNull
        public final KtModifierKeywordToken getModifier() {
            return this.modifier;
        }

        @NotNull
        public final KtModifierKeywordToken component1() {
            return this.modifier;
        }

        @NotNull
        public final ModifierContext copy(@NotNull KtModifierKeywordToken modifier) {
            Intrinsics.checkNotNullParameter((Object)modifier, (String)"modifier");
            return new ModifierContext(modifier);
        }

        public static /* synthetic */ ModifierContext copy$default(ModifierContext modifierContext, KtModifierKeywordToken ktModifierKeywordToken, int n, Object object) {
            if ((n & 1) != 0) {
                ktModifierKeywordToken = modifierContext.modifier;
            }
            return modifierContext.copy(ktModifierKeywordToken);
        }

        @NotNull
        public String toString() {
            return "ModifierContext(modifier=" + this.modifier + ")";
        }

        public int hashCode() {
            return this.modifier.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ModifierContext)) {
                return false;
            }
            ModifierContext modifierContext = (ModifierContext)other;
            return Intrinsics.areEqual((Object)this.modifier, (Object)modifierContext.modifier);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b$\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000fH\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/codeinsights/impl/base/inspections/RedundantModifierInspectionBase$RemoveRedundantModifierQuickFixBase;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/applicable/inspections/KotlinModCommandQuickFix;", "Lorg/jetbrains/kotlin/psi/KtModifierListOwner;", "context", "Lorg/jetbrains/kotlin/idea/codeinsights/impl/base/inspections/RedundantModifierInspectionBase$ModifierContext;", "<init>", "(Lorg/jetbrains/kotlin/idea/codeinsights/impl/base/inspections/RedundantModifierInspectionBase$ModifierContext;)V", "getName", "", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "element", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "kotlin.code-insight.impl-base"})
    protected static abstract class RemoveRedundantModifierQuickFixBase
    extends KotlinModCommandQuickFix<KtModifierListOwner> {
        @NotNull
        private final ModifierContext context;

        public RemoveRedundantModifierQuickFixBase(@NotNull ModifierContext context2) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            this.context = context2;
        }

        @Override
        @NotNull
        public String getName() {
            Object[] objectArray = new Object[]{this.context.getModifier().getValue()};
            return KotlinBundle.message((String)"remove.redundant.0.modifier", (Object[])objectArray);
        }

        @Override
        protected void applyFix(@NotNull Project project, @NotNull KtModifierListOwner element, @NotNull ModPsiUpdater updater2) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)updater2, (String)"updater");
            element.removeModifier(this.context.getModifier());
            if (element instanceof KtPrimaryConstructor && KotlinPsiUtils.isRedundant((KtPrimaryConstructor)element)) {
                ((KtPrimaryConstructor)element).delete();
            }
        }
    }
}

