/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.completion.handlers;

import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.base.analysis.RootPrefixUtils;
import org.jetbrains.kotlin.idea.completion.CompletionUtilsKt;
import org.jetbrains.kotlin.idea.completion.handlers.BaseDeclarationInsertHandler;
import org.jetbrains.kotlin.idea.completion.handlers.HandlerUtilsKt;
import org.jetbrains.kotlin.idea.core.ShortenReferences;
import org.jetbrains.kotlin.idea.core.completion.DescriptorBasedDeclarationLookupObject;
import org.jetbrains.kotlin.idea.imports.ImportsUtils;
import org.jetbrains.kotlin.idea.util.CallType;
import org.jetbrains.kotlin.idea.util.ImportInsertHelper;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNamesUtilKt;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.renderer.RenderingUtilsKt;
import org.jetbrains.kotlin.resolve.DescriptorUtils;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0013\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/completion/handlers/KotlinCallableInsertHandler;", "Lorg/jetbrains/kotlin/idea/completion/handlers/BaseDeclarationInsertHandler;", "callType", "Lorg/jetbrains/kotlin/idea/util/CallType;", "<init>", "(Lorg/jetbrains/kotlin/idea/util/CallType;)V", "getCallType", "()Lorg/jetbrains/kotlin/idea/util/CallType;", "handleInsert", "", "context", "Lcom/intellij/codeInsight/completion/InsertionContext;", "item", "Lcom/intellij/codeInsight/lookup/LookupElement;", "Companion", "kotlin.completion.impl.k1"})
public abstract class KotlinCallableInsertHandler
extends BaseDeclarationInsertHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CallType<?> callType;
    @NotNull
    private static final ShortenReferences SHORTEN_REFERENCES = new ShortenReferences((Function1<? super KtElement, ShortenReferences.Options>)((Function1)KotlinCallableInsertHandler::SHORTEN_REFERENCES$lambda$0));

    public KotlinCallableInsertHandler(@NotNull CallType<?> callType) {
        Intrinsics.checkNotNullParameter(callType, (String)"callType");
        this.callType = callType;
    }

    @NotNull
    public final CallType<?> getCallType() {
        return this.callType;
    }

    @Override
    public void handleInsert(@NotNull InsertionContext context2, @NotNull LookupElement item) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        super.handleInsert(context2, item);
        Companion.addImport(context2, item, this.callType);
    }

    private static final ShortenReferences.Options SHORTEN_REFERENCES$lambda$0(KtElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ShortenReferences.Options.copy$default(ShortenReferences.Options.Companion.getDEFAULT(), false, false, false, false, false, false, 55, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000fJ\u001c\u0010\u0010\u001a\u00020\u00112\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/completion/handlers/KotlinCallableInsertHandler$Companion;", "", "<init>", "()V", "SHORTEN_REFERENCES", "Lorg/jetbrains/kotlin/idea/core/ShortenReferences;", "getSHORTEN_REFERENCES", "()Lorg/jetbrains/kotlin/idea/core/ShortenReferences;", "addImport", "", "context", "Lcom/intellij/codeInsight/completion/InsertionContext;", "item", "Lcom/intellij/codeInsight/lookup/LookupElement;", "callType", "Lorg/jetbrains/kotlin/idea/util/CallType;", "cannotBeFullyQualified", "", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "kotlin.completion.impl.k1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ShortenReferences getSHORTEN_REFERENCES() {
            return SHORTEN_REFERENCES;
        }

        public final void addImport(@NotNull InsertionContext context2, @NotNull LookupElement item, @NotNull CallType<?> callType) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            Intrinsics.checkNotNullParameter(callType, (String)"callType");
            Project project = context2.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Project project2 = project;
            PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)project2);
            psiDocumentManager.commitDocument(context2.getDocument());
            PsiFile psiFile = context2.getFile();
            KtFile ktFile2 = psiFile instanceof KtFile ? (KtFile)psiFile : null;
            if (ktFile2 == null) {
                return;
            }
            KtFile file = ktFile2;
            Object object = item.getObject();
            DescriptorBasedDeclarationLookupObject descriptorBasedDeclarationLookupObject = object instanceof DescriptorBasedDeclarationLookupObject ? (DescriptorBasedDeclarationLookupObject)object : null;
            if (descriptorBasedDeclarationLookupObject == null) {
                return;
            }
            DescriptorBasedDeclarationLookupObject lookupObject = descriptorBasedDeclarationLookupObject;
            DeclarationDescriptor declarationDescriptor = lookupObject.getDescriptor();
            CallableDescriptor callableDescriptor = declarationDescriptor instanceof CallableDescriptor ? (CallableDescriptor)declarationDescriptor : null;
            if (callableDescriptor == null) {
                return;
            }
            CallableDescriptor descriptor2 = callableDescriptor;
            if (CompletionUtilsKt.isArtificialImportAliasedDescriptor((DeclarationDescriptor)descriptor2)) {
                return;
            }
            if (this.cannotBeFullyQualified(callType, descriptor2)) {
                if (DescriptorUtils.isTopLevelDeclaration((DeclarationDescriptor)((DeclarationDescriptor)descriptor2))) {
                    ImportInsertHelper.importDescriptor$default(ImportInsertHelper.Companion.getInstance(project2), file, (DeclarationDescriptor)descriptor2, false, 4, null);
                }
            } else if (Intrinsics.areEqual(callType, (Object)CallType.DEFAULT.INSTANCE)) {
                FqName fqName2 = ImportsUtils.getImportableFqName((DeclarationDescriptor)descriptor2);
                if (fqName2 == null) {
                    return;
                }
                FqName fqName3 = fqName2;
                context2.getDocument().replaceString(context2.getStartOffset(), context2.getTailOffset(), (CharSequence)(RenderingUtilsKt.render((FqName)RootPrefixUtils.withRootPrefixIfNeeded$default(fqName3, null, 1, null)) + " "));
                psiDocumentManager.commitDocument(context2.getDocument());
                CompletionUtilsKt.shortenReferences(context2, context2.getStartOffset(), context2.getTailOffset() - 1, this.getSHORTEN_REFERENCES());
                psiDocumentManager.doPostponedOperationsAndUnblockDocument(context2.getDocument());
                Document document = context2.getDocument();
                Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
                if (HandlerUtilsKt.isTextAt(document, context2.getTailOffset() - 1, " ")) {
                    context2.getDocument().deleteString(context2.getTailOffset() - 1, context2.getTailOffset());
                }
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean cannotBeFullyQualified(CallType<?> callType, CallableDescriptor descriptor2) {
            if (callType instanceof CallType.CallableReference) return true;
            if (descriptor2.getExtensionReceiverParameter() != null) return true;
            FqName fqName2 = ImportsUtils.getImportableFqName((DeclarationDescriptor)descriptor2);
            FqName fqName3 = fqName2;
            if (fqName2 == null) return false;
            FqName fqName4 = FqNamesUtilKt.parentOrNull((FqName)fqName3);
            fqName3 = fqName4;
            if (fqName4 == null) return false;
            if (!fqName3.isRoot()) return false;
            return true;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

