/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core.script.configuration.cache;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.SLRUMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.core.script.configuration.cache.ScriptConfigurationCache;
import org.jetbrains.kotlin.idea.core.script.configuration.cache.ScriptConfigurationSnapshot;
import org.jetbrains.kotlin.idea.core.script.configuration.cache.ScriptConfigurationState;
import org.jetbrains.kotlin.scripting.resolve.ScriptCompilationConfigurationWrapper;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0010\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0013\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\r\u001a\u00020\nH\u0096\u0002J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\nH\u0016J\u0018\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001a\u0010\u0015\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00180\u00170\u0016H\u0016J\b\u0010\u0019\u001a\u00020\u000fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/configuration/cache/ScriptConfigurationMemoryCache;", "Lorg/jetbrains/kotlin/idea/core/script/configuration/cache/ScriptConfigurationCache;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "memoryCache", "Lcom/intellij/util/containers/SLRUMap;", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lorg/jetbrains/kotlin/idea/core/script/configuration/cache/ScriptConfigurationState;", "get", "file", "setApplied", "", "configurationSnapshot", "Lorg/jetbrains/kotlin/idea/core/script/configuration/cache/ScriptConfigurationSnapshot;", "remove", "", "setLoaded", "allApplied", "", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/scripting/resolve/ScriptCompilationConfigurationWrapper;", "clear", "Companion", "kotlin.base.scripting"})
public class ScriptConfigurationMemoryCache
implements ScriptConfigurationCache {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final SLRUMap<VirtualFile, ScriptConfigurationState> memoryCache;
    public static final int MAX_SCRIPTS_CACHED = 50;

    public ScriptConfigurationMemoryCache(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.memoryCache = new SLRUMap(50, 50);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Override
    @Nullable
    public synchronized ScriptConfigurationState get(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return (ScriptConfigurationState)this.memoryCache.get((Object)file);
    }

    @Override
    public synchronized void setApplied(@NotNull VirtualFile file, @NotNull ScriptConfigurationSnapshot configurationSnapshot) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)configurationSnapshot, (String)"configurationSnapshot");
        ScriptConfigurationState scriptConfigurationState = (ScriptConfigurationState)this.memoryCache.get((Object)file);
        if (scriptConfigurationState == null) {
            scriptConfigurationState = new ScriptConfigurationState(null, null, 3, null);
        }
        ScriptConfigurationState old = scriptConfigurationState;
        this.memoryCache.put((Object)file, (Object)ScriptConfigurationState.copy$default(old, configurationSnapshot, null, 2, null));
    }

    @Override
    public boolean remove(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.memoryCache.remove((Object)file);
    }

    @Override
    public synchronized void setLoaded(@NotNull VirtualFile file, @NotNull ScriptConfigurationSnapshot configurationSnapshot) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)configurationSnapshot, (String)"configurationSnapshot");
        ScriptConfigurationState scriptConfigurationState = (ScriptConfigurationState)this.memoryCache.get((Object)file);
        if (scriptConfigurationState == null) {
            scriptConfigurationState = new ScriptConfigurationState(null, null, 3, null);
        }
        ScriptConfigurationState old = scriptConfigurationState;
        this.memoryCache.put((Object)file, (Object)ScriptConfigurationState.copy$default(old, null, configurationSnapshot, 1, null));
    }

    @Override
    @NotNull
    public synchronized List<Pair<VirtualFile, ScriptCompilationConfigurationWrapper>> allApplied() {
        List result2 = new ArrayList();
        for (Map.Entry entry : this.memoryCache.entrySet()) {
            Intrinsics.checkNotNull((Object)entry);
            VirtualFile file = (VirtualFile)entry.getKey();
            ScriptConfigurationState configuration2 = (ScriptConfigurationState)entry.getValue();
            ScriptConfigurationSnapshot scriptConfigurationSnapshot = configuration2.getApplied();
            if ((scriptConfigurationSnapshot != null ? scriptConfigurationSnapshot.getConfiguration() : null) == null) continue;
            result2.add(new Pair((Object)file, (Object)configuration2.getApplied().getConfiguration()));
        }
        return result2;
    }

    @Override
    public synchronized void clear() {
        this.memoryCache.clear();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/configuration/cache/ScriptConfigurationMemoryCache$Companion;", "", "<init>", "()V", "MAX_SCRIPTS_CACHED", "", "kotlin.base.scripting"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

