/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger;

import com.intellij.concurrency.ContextAwareRunnable;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.impl.DebuggerUtilsAsync;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.platform.ide.progress.TasksKt;
import com.intellij.platform.util.progress.StepsKt;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.indexing.DumbModeAccessType;
import com.intellij.util.indexing.FileBasedIndex;
import com.jetbrains.jdi.ReferenceTypeImpl;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.TypeComponent;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.DebugProbesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CancellableContinuation;
import kotlinx.coroutines.CancellableContinuationImpl;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.lifetime.KaLifetimeOwner;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallInfo;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallInfoKt;
import org.jetbrains.kotlin.analysis.api.symbols.KaCallableSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaValueParameterSymbol;
import org.jetbrains.kotlin.analysis.api.types.KaUsualClassType;
import org.jetbrains.kotlin.idea.base.psi.KotlinPsiUtils;
import org.jetbrains.kotlin.idea.debugger.KotlinPositionManagerKt;
import org.jetbrains.kotlin.idea.debugger.base.util.AnalyseUtilsKt;
import org.jetbrains.kotlin.idea.debugger.base.util.JvmNameUtilsKt;
import org.jetbrains.kotlin.idea.debugger.base.util.SafeUtilKt;
import org.jetbrains.kotlin.idea.debugger.core.ClassNameProvider;
import org.jetbrains.kotlin.idea.debugger.core.DebuggerUtils;
import org.jetbrains.kotlin.idea.debugger.core.DebuggerUtilsKt;
import org.jetbrains.kotlin.idea.debugger.core.KotlinDebuggerCoreBundle;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtClassInitializer;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u00a4\u0001\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u001a\u0018\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00030\u0001H\u0002\u001a,\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001H\u0002\u001a&\u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001H\u0002\u001a\u001e\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u00022\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001H\u0002\u001a:\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u00012\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00022\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u0001H\u0082@\u00a2\u0006\u0002\u0010\u0018\u001a\u0016\u0010\u001e\u001a\u0004\u0018\u00010\u001f*\u00020 2\b\b\u0002\u0010!\u001a\u00020\u0006\u001a\u0016\u0010\"\u001a\u0004\u0018\u00010\u001f*\u00020 2\b\b\u0002\u0010!\u001a\u00020\u0006\u001a\f\u0010#\u001a\u00020\u0006*\u00020$H\u0000\u001a\f\u0010%\u001a\u00020\n*\u00020&H\u0002\u001a\f\u0010'\u001a\u0004\u0018\u00010\u0002*\u00020&\u001a\"\u0010(\u001a\b\u0012\u0004\u0012\u00020\b0\u0001*\u00020)2\u0006\u0010*\u001a\u00020\b2\u0006\u0010+\u001a\u00020\nH\u0002\u001a\u0012\u0010,\u001a\u00020\u0006*\u00020-H\u0082@\u00a2\u0006\u0002\u0010.\u001aT\u0010/\u001a\u0002H0\"\u0004\b\u0000\u00100*\u0002012\u001c\u00102\u001a\u0018\b\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000604\u0012\u0006\u0012\u0004\u0018\u000105032\u001c\u00106\u001a\u0018\b\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u0002H004\u0012\u0006\u0012\u0004\u0018\u00010503H\u0082@\u00a2\u0006\u0002\u00107\u001a4\u00108\u001a\u0002092\u0006\u0010:\u001a\u0002012\u001c\u00102\u001a\u0018\b\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000604\u0012\u0006\u0012\u0004\u0018\u00010503H\u0082@\u00a2\u0006\u0002\u0010;\u001a\u0016\u0010<\u001a\u00020=2\u0006\u0010\u0011\u001a\u00020\u0012H\u0082@\u00a2\u0006\u0002\u0010>\"\u001e\u0010\u0019\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u001c0\u001b0\u001aX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001d\u00a8\u0006?"}, d2={"filterHasInlineElements", "", "", "Lorg/jetbrains/kotlin/idea/debugger/core/ClassNameProvider$ClassNameCandidateInfo;", "hasInlinedLinesToAsync", "Ljava/util/concurrent/CompletableFuture;", "", "referenceType", "Lcom/sun/jdi/ReferenceType;", "line", "", "sourceCandidatesInternalName", "fallbackHasInlinedLinesTo", "sourcePathMatchesCandidates", "sourcePath", "findFileCandidatesWithBackgroundProcess", "Lorg/jetbrains/kotlin/psi/KtFile;", "project", "Lcom/intellij/openapi/project/Project;", "className", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "sourceName", "scopes", "Lcom/intellij/psi/search/GlobalSearchScope;", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;Ljava/lang/String;Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "FUNCTION_TYPES", "", "Ljava/lang/Class;", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "[Ljava/lang/Class;", "getContainingMethod", "Lorg/jetbrains/kotlin/psi/KtExpression;", "Lcom/intellij/psi/PsiElement;", "excludingElement", "getContainingBlockOrMethod", "isGeneratedErasedLambdaMethod", "Lcom/sun/jdi/Method;", "getZeroBasedLineNumber", "Lcom/sun/jdi/Location;", "getClassName", "findTargetClasses", "Lcom/intellij/debugger/engine/DebugProcess;", "outerClass", "lineAt", "isSamLambda", "Lorg/jetbrains/kotlin/psi/KtFunction;", "(Lorg/jetbrains/kotlin/psi/KtFunction;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "cancelIfExpired", "T", "Lkotlinx/coroutines/CoroutineScope;", "condition", "Lkotlin/Function1;", "Lkotlin/coroutines/Continuation;", "", "action", "(Lkotlinx/coroutines/CoroutineScope;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "cancelWhenExpired", "Lkotlinx/coroutines/Job;", "scope", "(Lkotlinx/coroutines/CoroutineScope;Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "waitForSmartMode", "", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "kotlin.jvm-debugger.core"})
@SourceDebugExtension(value={"SMAP\nKotlinPositionManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinPositionManager.kt\norg/jetbrains/kotlin/idea/debugger/KotlinPositionManagerKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 CancellableContinuation.kt\nkotlinx/coroutines/CancellableContinuationKt\n*L\n1#1,980:1\n774#2:981\n865#2,2:982\n1557#2:984\n1628#2,3:985\n1755#2,3:988\n1734#2,3:991\n310#3,11:994\n*S KotlinDebug\n*F\n+ 1 KotlinPositionManager.kt\norg/jetbrains/kotlin/idea/debugger/KotlinPositionManagerKt\n*L\n752#1:981\n752#1:982,2\n752#1:984\n752#1:985,3\n794#1:988,3\n858#1:991,3\n977#1:994,11\n*E\n"})
public final class KotlinPositionManagerKt {
    @NotNull
    private static final Class<? extends KtDeclaration>[] FUNCTION_TYPES;

    /*
     * WARNING - void declaration
     */
    private static final List<String> filterHasInlineElements(List<ClassNameProvider.ClassNameCandidateInfo> $this$filterHasInlineElements) {
        void $this$mapTo$iv$iv;
        ClassNameProvider.ClassNameCandidateInfo it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = $this$filterHasInlineElements;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (ClassNameProvider.ClassNameCandidateInfo)element$iv$iv;
            boolean bl = false;
            if (!it.getHasInlineElements()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (ClassNameProvider.ClassNameCandidateInfo)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getName());
        }
        return (List)destination$iv$iv;
    }

    private static final CompletableFuture<Boolean> hasInlinedLinesToAsync(ReferenceType referenceType, int line, List<String> sourceCandidatesInternalName) {
        CompletableFuture completableFuture;
        if (referenceType instanceof ReferenceTypeImpl) {
            CompletableFuture completableFuture2 = ((ReferenceTypeImpl)referenceType).hasMappedLineToAsync("Kotlin", line, arg_0 -> KotlinPositionManagerKt.hasInlinedLinesToAsync$lambda$2(sourceCandidatesInternalName, arg_0));
            Intrinsics.checkNotNull((Object)completableFuture2);
            completableFuture = completableFuture2;
        } else {
            CompletableFuture completableFuture3 = CompletableFuture.completedFuture(KotlinPositionManagerKt.fallbackHasInlinedLinesTo(referenceType, line, sourceCandidatesInternalName));
            Intrinsics.checkNotNull(completableFuture3);
            completableFuture = completableFuture3;
        }
        return completableFuture;
    }

    private static final boolean fallbackHasInlinedLinesTo(ReferenceType referenceType, int line, List<String> sourceCandidatesInternalName) {
        boolean bl;
        block6: {
            List list2;
            try {
                list2 = DebuggerUtilsAsync.locationsOfLineSync((ReferenceType)referenceType, (String)"Kotlin", null, (int)line);
            }
            catch (AbsentInformationException e) {
                list2 = CollectionsKt.emptyList();
            }
            List locations = list2;
            Intrinsics.checkNotNull((Object)locations);
            Iterable $this$any$iv = locations;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Location location = (Location)element$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNull((Object)location);
                    String string = SafeUtilKt.safeSourcePath(location, "Kotlin");
                    if (string != null) {
                        String sourcePath = string;
                        return KotlinPositionManagerKt.sourcePathMatchesCandidates(sourcePath, sourceCandidatesInternalName);
                    }
                    if (!false) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final boolean sourcePathMatchesCandidates(String sourcePath, List<String> sourceCandidatesInternalName) {
        String string = FileUtil.toSystemIndependentName((String)sourcePath);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toSystemIndependentName(...)");
        String internalName = string;
        return DebuggerUtilsKt.isInnerClassOfAny(internalName, sourceCandidatesInternalName);
    }

    private static final Object findFileCandidatesWithBackgroundProcess(Project project, JvmClassName className, String sourceName, List<? extends GlobalSearchScope> scopes, Continuation<? super List<? extends KtFile>> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getDefault()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super List<? extends KtFile>>, Object>(project, scopes, className, sourceName, null){
            int label;
            final /* synthetic */ Project $project;
            final /* synthetic */ List<GlobalSearchScope> $scopes;
            final /* synthetic */ JvmClassName $className;
            final /* synthetic */ String $sourceName;
            {
                this.$project = $project;
                this.$scopes = $scopes;
                this.$className = $className;
                this.$sourceName = $sourceName;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = TasksKt.withBackgroundProgress((Project)this.$project, (String)KotlinDebuggerCoreBundle.message("progress.title.kt.file.search", new Object[0]), (boolean)false, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super List<? extends KtFile>>, Object>(this.$project, this.$scopes, this.$className, this.$sourceName, null){
                            int label;
                            final /* synthetic */ Project $project;
                            final /* synthetic */ List<GlobalSearchScope> $scopes;
                            final /* synthetic */ JvmClassName $className;
                            final /* synthetic */ String $sourceName;
                            {
                                this.$project = $project;
                                this.$scopes = $scopes;
                                this.$className = $className;
                                this.$sourceName = $sourceName;
                                super(2, $completion);
                            }

                            /*
                             * Unable to fully structure code
                             */
                            public final Object invokeSuspend(Object var1_1) {
                                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)var1_1);
                                        this.label = 1;
                                        v0 = CoroutinesKt.readAction((Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, invokeSuspend$lambda$1(com.intellij.openapi.project.Project java.util.List org.jetbrains.kotlin.resolve.jvm.JvmClassName java.lang.String ), ()Ljava/util/List;)((Project)this.$project, this.$scopes, (JvmClassName)this.$className, (String)this.$sourceName), (Continuation)((Continuation)this));
                                        if (v0 == var3_2) {
                                            return var3_2;
                                        }
                                        ** GOTO lbl13
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        v0 = $result;
lbl13:
                                        // 2 sources

                                        files = (List)v0;
                                        Intrinsics.checkNotNull((Object)files);
                                        if (((Collection)files).isEmpty() == false) {
                                            return files;
                                        }
                                        this.label = 2;
                                        v1 = StepsKt.withProgressText((String)KotlinDebuggerCoreBundle.message("progress.text.waiting.for.smart.mode", new Object[0]), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$project, null){
                                            int label;
                                            final /* synthetic */ Project $project;
                                            {
                                                this.$project = $project;
                                                super(2, $completion);
                                            }

                                            /*
                                             * WARNING - void declaration
                                             * Enabled force condition propagation
                                             * Lifted jumps to return sites
                                             */
                                            public final Object invokeSuspend(Object object) {
                                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                switch (this.label) {
                                                    case 0: {
                                                        ResultKt.throwOnFailure((Object)object);
                                                        this.label = 1;
                                                        Object object3 = KotlinPositionManagerKt.access$waitForSmartMode(this.$project, (Continuation)this);
                                                        if (object3 != object2) return Unit.INSTANCE;
                                                        return object2;
                                                    }
                                                    case 1: {
                                                        void $result;
                                                        ResultKt.throwOnFailure((Object)$result);
                                                        Object object3 = $result;
                                                        return Unit.INSTANCE;
                                                    }
                                                }
                                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                            }

                                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                            }

                                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                            }
                                        }), (Continuation)((Continuation)this));
                                        if (v1 == var3_2) {
                                            return var3_2;
                                        }
                                        ** GOTO lbl25
                                    }
                                    case 2: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        v1 = $result;
lbl25:
                                        // 2 sources

                                        this.label = 3;
                                        v2 = CoroutinesKt.smartReadAction((Project)this.$project, (Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, invokeSuspend$lambda$2(com.intellij.openapi.project.Project java.util.List org.jetbrains.kotlin.resolve.jvm.JvmClassName java.lang.String ), ()Ljava/util/List;)((Project)this.$project, this.$scopes, (JvmClassName)this.$className, (String)this.$sourceName), (Continuation)((Continuation)this));
                                        if (v2 == var3_2) {
                                            return var3_2;
                                        }
                                        ** GOTO lbl33
                                    }
                                    case 3: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        v2 = $result;
lbl33:
                                        // 2 sources

                                        return v2;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super List<? extends KtFile>> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }

                            private static final List invokeSuspend$lambda$1$lambda$0(Project $project, List $scopes, JvmClassName $className, String $sourceName) {
                                List files2 = DebuggerUtils.findSourceFilesForClass$kotlin_jvm_debugger_core$default(DebuggerUtils.INSTANCE, $project, $scopes, $className, $sourceName, false, false, 48, null);
                                if (!((Collection)files2).isEmpty()) {
                                    return files2;
                                }
                                return DebuggerUtils.INSTANCE.tryFindFileByClassNameAndFileName$kotlin_jvm_debugger_core($project, $className, $sourceName, $scopes);
                            }

                            private static final List invokeSuspend$lambda$1(Project $project, List $scopes, JvmClassName $className, String $sourceName) {
                                return (List)FileBasedIndex.getInstance().ignoreDumbMode(DumbModeAccessType.RELIABLE_DATA_ONLY, () -> findFileCandidatesWithBackgroundProcess.1.invokeSuspend$lambda$1$lambda$0($project, $scopes, $className, $sourceName));
                            }

                            private static final List invokeSuspend$lambda$2(Project $project, List $scopes, JvmClassName $className, String $sourceName) {
                                return DebuggerUtils.findSourceFilesForClass$kotlin_jvm_debugger_core$default(DebuggerUtils.INSTANCE, $project, $scopes, $className, $sourceName, false, false, 48, null);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super List<? extends KtFile>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    @Nullable
    public static final KtExpression getContainingMethod(@NotNull PsiElement $this$getContainingMethod, boolean excludingElement) {
        Intrinsics.checkNotNullParameter((Object)$this$getContainingMethod, (String)"<this>");
        Class<? extends KtDeclaration>[] classArray = FUNCTION_TYPES;
        return (KtExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$getContainingMethod, (boolean)excludingElement, (Class[])Arrays.copyOf(classArray, classArray.length));
    }

    public static /* synthetic */ KtExpression getContainingMethod$default(PsiElement psiElement, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return KotlinPositionManagerKt.getContainingMethod(psiElement, bl);
    }

    @Nullable
    public static final KtExpression getContainingBlockOrMethod(@NotNull PsiElement $this$getContainingBlockOrMethod, boolean excludingElement) {
        Intrinsics.checkNotNullParameter((Object)$this$getContainingBlockOrMethod, (String)"<this>");
        SpreadBuilder spreadBuilder = new SpreadBuilder(2);
        spreadBuilder.add(KtBlockExpression.class);
        spreadBuilder.addSpread(FUNCTION_TYPES);
        return (KtExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$getContainingBlockOrMethod, (boolean)excludingElement, (Class[])((Class[])spreadBuilder.toArray((Object[])new Class[spreadBuilder.size()])));
    }

    public static /* synthetic */ KtExpression getContainingBlockOrMethod$default(PsiElement psiElement, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return KotlinPositionManagerKt.getContainingBlockOrMethod(psiElement, bl);
    }

    public static final boolean isGeneratedErasedLambdaMethod(@NotNull Method $this$isGeneratedErasedLambdaMethod) {
        Intrinsics.checkNotNullParameter((Object)$this$isGeneratedErasedLambdaMethod, (String)"<this>");
        String string = $this$isGeneratedErasedLambdaMethod.name();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name(...)");
        if (DebuggerUtils.INSTANCE.isGeneratedIrBackendLambdaMethodName(string) && $this$isGeneratedErasedLambdaMethod.isPrivate() && $this$isGeneratedErasedLambdaMethod.isStatic()) {
            List<String> args = $this$isGeneratedErasedLambdaMethod.argumentTypeNames();
            String kotlinFunctionPrefix = "kotlin.jvm.functions.Function";
            if (args.size() >= 2) {
                String string2 = args.get(0);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"get(...)");
                if (StringsKt.startsWith$default((String)string2, (String)kotlinFunctionPrefix, (boolean)false, (int)2, null)) {
                    String string3 = args.get(0);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"get(...)");
                    Integer parameterCount = StringsKt.toIntOrNull((String)StringsKt.removePrefix((String)string3, (CharSequence)kotlinFunctionPrefix));
                    if (parameterCount != null && args.size() == parameterCount + 1) {
                        boolean bl;
                        block8: {
                            Intrinsics.checkNotNull(args);
                            Iterable $this$all$iv = CollectionsKt.drop((Iterable)args, (int)1);
                            boolean $i$f$all = false;
                            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                                bl = true;
                            } else {
                                for (Object element$iv : $this$all$iv) {
                                    String it = (String)element$iv;
                                    boolean bl2 = false;
                                    if (Intrinsics.areEqual((Object)it, (Object)"java.lang.Object")) continue;
                                    bl = false;
                                    break block8;
                                }
                                bl = true;
                            }
                        }
                        if (bl) {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private static final int getZeroBasedLineNumber(Location $this$getZeroBasedLineNumber) {
        return DebuggerUtilsEx.getLineNumber((Location)$this$getZeroBasedLineNumber, (boolean)true);
    }

    @Nullable
    public static final String getClassName(@NotNull Location $this$getClassName) {
        Intrinsics.checkNotNullParameter((Object)$this$getClassName, (String)"<this>");
        String string = $this$getClassName.declaringType().name();
        if (string == null) {
            return null;
        }
        String currentLocationFqName = string;
        String string2 = JvmClassName.byFqNameWithoutInnerClasses((FqName)new FqName(currentLocationFqName)).getInternalName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getInternalName(...)");
        return JvmNameUtilsKt.internalNameToFqn(string2);
    }

    private static final List<ReferenceType> findTargetClasses(DebugProcess $this$findTargetClasses, ReferenceType outerClass, int lineAt) {
        ArrayList targetClasses = new ArrayList(1);
        try {
            if (!outerClass.isPrepared()) {
                return CollectionsKt.emptyList();
            }
            for (Location location : SafeUtilKt.safeAllLineLocations(outerClass)) {
                Method method;
                int locationLine = KotlinPositionManagerKt.getZeroBasedLineNumber(location);
                if (locationLine < 0 || lineAt != locationLine || (method = location.method()) == null || com.intellij.debugger.engine.DebuggerUtils.isSynthetic((TypeComponent)method) || method.isBridge()) continue;
                ((Collection)targetClasses).add(outerClass);
                break;
            }
            List nestedTypes = $this$findTargetClasses.getVirtualMachineProxy().nestedTypes(outerClass);
            for (ReferenceType nested : nestedTypes) {
                Collection collection = targetClasses;
                Intrinsics.checkNotNull((Object)nested);
                CollectionsKt.addAll((Collection)collection, (Iterable)KotlinPositionManagerKt.findTargetClasses($this$findTargetClasses, nested, lineAt));
            }
        }
        catch (AbsentInformationException nestedTypes) {
        }
        catch (ObjectCollectedException objectCollectedException) {
            return CollectionsKt.emptyList();
        }
        return targetClasses;
    }

    private static final Object isSamLambda(KtFunction $this$isSamLambda, Continuation<? super Boolean> $completion) {
        if (!($this$isSamLambda instanceof KtFunctionLiteral) && !($this$isSamLambda instanceof KtNamedFunction)) {
            return Boxing.boxBoolean((boolean)false);
        }
        return AnalyseUtilsKt.dumbAnalyze((KtElement)$this$isSamLambda, Boxing.boxBoolean((boolean)false), arg_0 -> KotlinPositionManagerKt.isSamLambda$lambda$5($this$isSamLambda, arg_0), $completion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private static final <T> Object cancelIfExpired(CoroutineScope var0, Function1<? super Continuation<? super Boolean>, ? extends Object> var1_1, Function1<? super Continuation<? super T>, ? extends Object> var2_2, Continuation<? super T> $completion) {
        if (!($completion instanceof cancelIfExpired.1)) ** GOTO lbl-1000
        var8_4 = $completion;
        if ((var8_4.label & -2147483648) != 0) {
            var8_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl($completion){
                Object L$0;
                /* synthetic */ Object result;
                int label;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return KotlinPositionManagerKt.access$cancelIfExpired(null, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var9_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = action;
                $continuation.label = 1;
                v0 = KotlinPositionManagerKt.cancelWhenExpired($this$cancelIfExpired, (Function1<? super Continuation<? super Boolean>, ? extends Object>)condition, $continuation);
                if (v0 == var9_6) {
                    return var9_6;
                }
                ** GOTO lbl22
            }
            case 1: {
                action = (Function1)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl22:
                // 2 sources

                cancellationJob = (Job)v0;
                $continuation.L$0 = cancellationJob;
                $continuation.label = 2;
                v1 = action.invoke($continuation);
                ** if (v1 != var9_6) goto lbl30
lbl29:
                // 1 sources

                return var9_6;
lbl30:
                // 1 sources

                ** GOTO lbl37
            }
            case 2: {
                cancellationJob = (Job)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl37:
                    // 2 sources

                    var5_8 = v1;
                    return var5_8;
                }
                catch (Throwable var6_9) {
                    throw var6_9;
                }
                finally {
                    Job.DefaultImpls.cancel$default((Job)cancellationJob, null, (int)1, null);
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private static final Object cancelWhenExpired(CoroutineScope var0, Function1<? super Continuation<? super Boolean>, ? extends Object> var1_1, Continuation<? super Job> $completion) {
        if (!($completion instanceof cancelWhenExpired.1)) ** GOTO lbl-1000
        var4_3 = $completion;
        if ((var4_3.label & -2147483648) != 0) {
            var4_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl($completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                int label;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return KotlinPositionManagerKt.access$cancelWhenExpired(null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var5_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = scope;
                $continuation.L$1 = condition;
                $continuation.label = 1;
                v0 = KotlinPositionManagerKt.cancelWhenExpired$checkExpired((Function1<? super Continuation<? super Boolean>, ? extends Object>)condition, scope, (Continuation<? super Unit>)$continuation);
                if (v0 == var5_5) {
                    return var5_5;
                }
                ** GOTO lbl24
            }
            case 1: {
                condition = (Function1)$continuation.L$1;
                scope = (CoroutineScope)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl24:
                // 2 sources

                return BuildersKt.launch$default((CoroutineScope)scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((Function1<? super Continuation<? super Boolean>, ? extends Object>)condition, scope, null){
                    int label;
                    final /* synthetic */ Function1<Continuation<? super Boolean>, Object> $condition;
                    final /* synthetic */ CoroutineScope $scope;
                    {
                        this.$condition = $condition;
                        this.$scope = $scope;
                        super(2, $completion);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    public final Object invokeSuspend(Object var1_1) {
                        var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)var1_1);
lbl6:
                                // 2 sources

                                while (true) {
                                    this.label = 1;
                                    v0 = KotlinPositionManagerKt.access$cancelWhenExpired$checkExpired(this.$condition, this.$scope, (Continuation)this);
                                    if (v0 == var2_2) {
                                        return var2_2;
                                    }
                                    ** GOTO lbl15
                                    break;
                                }
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl15:
                                // 2 sources

                                this.label = 2;
                                v1 = DelayKt.delay((long)500L, (Continuation)((Continuation)this));
                                if (v1 == var2_2) {
                                    return var2_2;
                                }
                                ** GOTO lbl23
                            }
                            case 2: {
                                ResultKt.throwOnFailure((Object)$result);
                                v1 = $result;
lbl23:
                                // 2 sources

                                ** continue;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)3, null);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private static final Object waitForSmartMode(Project project, Continuation<? super Unit> $completion) {
        boolean $i$f$suspendCancellableCoroutine = false;
        Continuation<? super Unit> uCont$iv = $completion;
        boolean bl = false;
        CancellableContinuationImpl cancellable$iv = new CancellableContinuationImpl(IntrinsicsKt.intercepted(uCont$iv), 1);
        cancellable$iv.initCancellability();
        CancellableContinuation it = (CancellableContinuation)cancellable$iv;
        boolean bl2 = false;
        DumbService.Companion.getInstance(project).runWhenSmart((Runnable)new ContextAwareRunnable((CancellableContinuation<? super Unit>)it){
            final /* synthetic */ CancellableContinuation<Unit> $it;
            {
                this.$it = $it;
            }

            public final void run() {
                ((Continuation)this.$it).resumeWith(Result.constructor-impl((Object)Unit.INSTANCE));
            }
        });
        Object object = cancellable$iv.getResult();
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            DebugProbesKt.probeCoroutineSuspended($completion);
        }
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private static final boolean hasInlinedLinesToAsync$lambda$2(List $sourceCandidatesInternalName, String path2) {
        Intrinsics.checkNotNull((Object)path2);
        return KotlinPositionManagerKt.sourcePathMatchesCandidates(path2, $sourceCandidatesInternalName);
    }

    private static final boolean isSamLambda$lambda$5(KtFunction $this_isSamLambda, KaSession $this$f) {
        Intrinsics.checkNotNullParameter((Object)$this$f, (String)"$this$f");
        KtExpression ktExpression = KtPsiUtil.getParentCallIfPresent((KtExpression)((KtExpression)$this_isSamLambda));
        KtCallExpression ktCallExpression = ktExpression instanceof KtCallExpression ? (KtCallExpression)ktExpression : null;
        if (ktCallExpression == null) {
            return false;
        }
        KtCallExpression parentCall = ktCallExpression;
        KaLifetimeOwner kaLifetimeOwner = $this$f.resolveToCall((KtElement)parentCall);
        if (kaLifetimeOwner == null || (kaLifetimeOwner = KaCallInfoKt.successfulFunctionCallOrNull((KaCallInfo)kaLifetimeOwner)) == null) {
            return false;
        }
        KaLifetimeOwner call2 = kaLifetimeOwner;
        KtValueArgument ktValueArgument = KotlinPsiUtils.getContainingValueArgument(parentCall, (KtExpression)$this_isSamLambda);
        if (ktValueArgument == null) {
            return false;
        }
        KtValueArgument valueArgument = ktValueArgument;
        KaLifetimeOwner kaLifetimeOwner2 = call2.getArgumentMapping().get(valueArgument.getArgumentExpression());
        if (kaLifetimeOwner2 == null || (kaLifetimeOwner2 = (KaValueParameterSymbol)kaLifetimeOwner2.getSymbol()) == null) {
            return false;
        }
        KaLifetimeOwner argument2 = kaLifetimeOwner2;
        return ((KaCallableSymbol)argument2).getReturnType() instanceof KaUsualClassType;
    }

    /*
     * Unable to fully structure code
     */
    private static final Object cancelWhenExpired$checkExpired(Function1<? super Continuation<? super Boolean>, ? extends Object> var0, CoroutineScope var1_1, Continuation<? super Unit> $completion) {
        if (!($completion instanceof cancelWhenExpired.checkExpired.1)) ** GOTO lbl-1000
        var4_3 = $completion;
        if ((var4_3.label & -2147483648) != 0) {
            var4_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl($completion){
                Object L$0;
                /* synthetic */ Object result;
                int label;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return KotlinPositionManagerKt.access$cancelWhenExpired$checkExpired(null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var5_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = $scope;
                $continuation.label = 1;
                v0 = $condition.invoke((Object)$continuation);
                if (v0 == var5_5) {
                    return var5_5;
                }
                ** GOTO lbl22
            }
            case 1: {
                $scope = (CoroutineScope)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl22:
                // 2 sources

                if (!((Boolean)v0).booleanValue()) {
                    CoroutineScopeKt.cancel$default((CoroutineScope)$scope, null, (int)1, null);
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static final /* synthetic */ int access$getZeroBasedLineNumber(Location $receiver) {
        return KotlinPositionManagerKt.getZeroBasedLineNumber($receiver);
    }

    public static final /* synthetic */ Object access$isSamLambda(KtFunction $receiver, Continuation $completion) {
        return KotlinPositionManagerKt.isSamLambda($receiver, (Continuation<? super Boolean>)$completion);
    }

    public static final /* synthetic */ Object access$findFileCandidatesWithBackgroundProcess(Project project, JvmClassName className, String sourceName, List scopes, Continuation $completion) {
        return KotlinPositionManagerKt.findFileCandidatesWithBackgroundProcess(project, className, sourceName, scopes, (Continuation<? super List<? extends KtFile>>)$completion);
    }

    public static final /* synthetic */ List access$filterHasInlineElements(List $receiver) {
        return KotlinPositionManagerKt.filterHasInlineElements($receiver);
    }

    public static final /* synthetic */ Object access$cancelIfExpired(CoroutineScope $receiver, Function1 condition2, Function1 action, Continuation $completion) {
        return KotlinPositionManagerKt.cancelIfExpired($receiver, (Function1<? super Continuation<? super Boolean>, ? extends Object>)condition2, action, $completion);
    }

    public static final /* synthetic */ CompletableFuture access$hasInlinedLinesToAsync(ReferenceType referenceType, int line, List sourceCandidatesInternalName) {
        return KotlinPositionManagerKt.hasInlinedLinesToAsync(referenceType, line, sourceCandidatesInternalName);
    }

    public static final /* synthetic */ List access$findTargetClasses(DebugProcess $receiver, ReferenceType outerClass, int lineAt) {
        return KotlinPositionManagerKt.findTargetClasses($receiver, outerClass, lineAt);
    }

    public static final /* synthetic */ boolean access$fallbackHasInlinedLinesTo(ReferenceType referenceType, int line, List sourceCandidatesInternalName) {
        return KotlinPositionManagerKt.fallbackHasInlinedLinesTo(referenceType, line, sourceCandidatesInternalName);
    }

    public static final /* synthetic */ boolean access$sourcePathMatchesCandidates(String sourcePath, List sourceCandidatesInternalName) {
        return KotlinPositionManagerKt.sourcePathMatchesCandidates(sourcePath, sourceCandidatesInternalName);
    }

    public static final /* synthetic */ Object access$waitForSmartMode(Project project, Continuation $completion) {
        return KotlinPositionManagerKt.waitForSmartMode(project, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$cancelWhenExpired(CoroutineScope scope, Function1 condition2, Continuation $completion) {
        return KotlinPositionManagerKt.cancelWhenExpired(scope, (Function1<? super Continuation<? super Boolean>, ? extends Object>)condition2, (Continuation<? super Job>)$completion);
    }

    public static final /* synthetic */ Object access$cancelWhenExpired$checkExpired(Function1 $condition, CoroutineScope $scope, Continuation $completion) {
        return KotlinPositionManagerKt.cancelWhenExpired$checkExpired((Function1<? super Continuation<? super Boolean>, ? extends Object>)$condition, $scope, (Continuation<? super Unit>)$completion);
    }

    static {
        Class[] classArray = new Class[]{KtFunction.class, KtClassInitializer.class, KtPropertyAccessor.class, KtScript.class};
        FUNCTION_TYPES = classArray;
    }
}

