/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.base.util;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.base.util.ClassNameCalculator;
import org.jetbrains.kotlin.idea.debugger.base.util.ClassNameCalculatorVisitor;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaExpression;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00052\u0006\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\n\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000b\u001a\u00020\u0006H\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/base/util/DefaultClassNameCalculator;", "Lorg/jetbrains/kotlin/idea/debugger/base/util/ClassNameCalculator;", "<init>", "()V", "getClassNames", "", "Lorg/jetbrains/kotlin/psi/KtElement;", "", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "getClassName", "element", "kotlin.jvm-debugger.base.util"})
final class DefaultClassNameCalculator
implements ClassNameCalculator {
    @NotNull
    public static final DefaultClassNameCalculator INSTANCE = new DefaultClassNameCalculator();

    private DefaultClassNameCalculator() {
    }

    @Override
    @NotNull
    public Map<KtElement, String> getClassNames(@NotNull KtFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Object object = CachedValuesManager.getCachedValue((PsiElement)((PsiElement)file), () -> DefaultClassNameCalculator.getClassNames$lambda$0(file));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
        return (Map)object;
    }

    @Override
    @Nullable
    public String getClassName(@NotNull KtElement element) {
        KtElement ktElement;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (element instanceof KtFunctionLiteral) {
            PsiElement psiElement = ((KtFunctionLiteral)element).getParent();
            KtLambdaExpression ktLambdaExpression = psiElement instanceof KtLambdaExpression ? (KtLambdaExpression)psiElement : null;
            if (ktLambdaExpression == null) {
                ktLambdaExpression = element;
            }
            ktElement = (KtElement)ktLambdaExpression;
        } else {
            ktElement = element;
        }
        KtElement target = ktElement;
        KtFile ktFile2 = element.getContainingKtFile();
        Intrinsics.checkNotNullExpressionValue((Object)ktFile2, (String)"getContainingKtFile(...)");
        return this.getClassNames(ktFile2).get(target);
    }

    private static final CachedValueProvider.Result getClassNames$lambda$0(KtFile $file) {
        ClassNameCalculatorVisitor visitor2 = new ClassNameCalculatorVisitor();
        $file.accept((PsiElementVisitor)visitor2);
        Object[] objectArray = new Object[]{$file};
        return new CachedValueProvider.Result(visitor2.getAllNames(), objectArray);
    }
}

