/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.coroutine.view;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JavaDebugProcess;
import com.intellij.debugger.engine.SuspendContext;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.util.SingleAlarm;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueContainer;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreePanel;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreeRestorer;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreeState;
import com.intellij.xdebugger.impl.ui.tree.nodes.XDebuggerTreeNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueContainerNode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadOnlyProperty;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.coroutine.KotlinDebuggerCoroutinesBundle;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.CoroutineDescriptor;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.CoroutineInfoCache;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.CoroutineInfoData;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.CoroutineStackFrameItem;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.CreationCoroutineStackFrameItem;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.CoroutineDebugProbesProxy;
import org.jetbrains.kotlin.idea.debugger.coroutine.util.CoroutineFrameBuilder;
import org.jetbrains.kotlin.idea.debugger.coroutine.util.CreateContentParams;
import org.jetbrains.kotlin.idea.debugger.coroutine.util.CreateContentParamsProvider;
import org.jetbrains.kotlin.idea.debugger.coroutine.util.ProvidersKt;
import org.jetbrains.kotlin.idea.debugger.coroutine.util.XDebugSessionListenerProvider;
import org.jetbrains.kotlin.idea.debugger.coroutine.view.CoroutineSelectedNodeListener;
import org.jetbrains.kotlin.idea.debugger.coroutine.view.CoroutineViewDebugSessionListener;
import org.jetbrains.kotlin.idea.debugger.coroutine.view.CoroutineViewKt;
import org.jetbrains.kotlin.idea.debugger.coroutine.view.SimpleColoredTextIcon;
import org.jetbrains.kotlin.idea.debugger.coroutine.view.SimpleColoredTextIconPresentationRenderer;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\u0018\u0000 72\u00020\u00012\u00020\u00022\u00020\u0003:\u000e789:;<=>?@ABCDB\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u001b\u001a\u00020\u001cJ\u0006\u0010\u001d\u001a\u00020\u001cJ\u0006\u0010\u001e\u001a\u00020\u001fJ\u000e\u0010 \u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\"J\b\u0010#\u001a\u00020\u001cH\u0016J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0016J\b\u0010(\u001a\u00020)H\u0016J\u0010\u0010*\u001a\n\u0012\u0006\b\u0000\u0012\u00020,0+H\u0002J\b\u0010-\u001a\u00020.H\u0002J\u0018\u0010/\u001a\u00020\u001c2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u000203H\u0002J\u0010\u00104\u001a\u00020\u001c2\u0006\u00105\u001a\u000206H\u0002R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u000e\u001a\u00070\u000f\u00a2\u0006\u0002\b\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006E"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView;", "Lcom/intellij/openapi/Disposable;", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/util/XDebugSessionListenerProvider;", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/util/CreateContentParamsProvider;", "project", "Lcom/intellij/openapi/project/Project;", "javaDebugProcess", "Lcom/intellij/debugger/engine/JavaDebugProcess;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/debugger/engine/JavaDebugProcess;)V", "alarm", "Lcom/intellij/util/SingleAlarm;", "getAlarm", "()Lcom/intellij/util/SingleAlarm;", "debugProcess", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "Lorg/jetbrains/annotations/NotNull;", "renderer", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/SimpleColoredTextIconPresentationRenderer;", "mainPanel", "Ljavax/swing/JPanel;", "treeState", "Lcom/intellij/xdebugger/impl/ui/tree/XDebuggerTreeState;", "restorer", "Lcom/intellij/xdebugger/impl/ui/tree/XDebuggerTreeRestorer;", "panel", "Lcom/intellij/xdebugger/impl/ui/tree/XDebuggerTreePanel;", "saveState", "", "resetRoot", "isShowing", "", "renewRoot", "suspendContext", "Lcom/intellij/debugger/engine/SuspendContextImpl;", "dispose", "debugSessionListener", "Lcom/intellij/xdebugger/XDebugSessionListener;", "session", "Lcom/intellij/xdebugger/XDebugSession;", "createContentParams", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/util/CreateContentParams;", "createRenderer", "Lcom/intellij/ui/SimpleListCellRenderer;", "", "createToolbar", "Lcom/intellij/openapi/actionSystem/impl/ActionToolbarImpl;", "applyRenderer", "node", "Lcom/intellij/xdebugger/frame/XValueNode;", "presentation", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/SimpleColoredTextIcon;", "installClickAndKeyListeners", "tree", "Lcom/intellij/xdebugger/impl/ui/tree/XDebuggerTree;", "Companion", "EmptyNode", "XCoroutinesRootNode", "CoroutineTopGroupContainer", "JobsContainer", "JobContainer", "DispatchersContainer", "CoroutineContainer", "InfoNode", "ErrorNode", "FramesContainer", "CreationFramesContainer", "CoroutineFrameValue", "RendererContainer", "kotlin.jvm-debugger.coroutines"})
public final class CoroutineView
implements Disposable,
XDebugSessionListenerProvider,
CreateContentParamsProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SingleAlarm alarm;
    @NotNull
    private final DebugProcessImpl debugProcess;
    @NotNull
    private final SimpleColoredTextIconPresentationRenderer renderer;
    @NotNull
    private final JPanel mainPanel;
    @Nullable
    private XDebuggerTreeState treeState;
    @Nullable
    private XDebuggerTreeRestorer restorer;
    @NotNull
    private final XDebuggerTreePanel panel;
    private static final int VIEW_CLEAR_DELAY_MS = 100;
    @NotNull
    private static final String EMPTY_DISPATCHER_NAME = KotlinDebuggerCoroutinesBundle.message("coroutine.view.dispatcher.empty", new Object[0]);
    @NotNull
    private static final ReadOnlyProperty<Object, Logger> log$delegate = ProvidersKt.getLogger();

    public CoroutineView(@NotNull Project project, @NotNull JavaDebugProcess javaDebugProcess) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)javaDebugProcess, (String)"javaDebugProcess");
        this.alarm = new SingleAlarm(() -> CoroutineView.alarm$lambda$0(this), 100, (Disposable)this);
        DebugProcessImpl debugProcessImpl = javaDebugProcess.getDebuggerSession().getProcess();
        Intrinsics.checkNotNullExpressionValue((Object)debugProcessImpl, (String)"getProcess(...)");
        this.debugProcess = debugProcessImpl;
        this.renderer = new SimpleColoredTextIconPresentationRenderer();
        this.mainPanel = new JPanel(new BorderLayout());
        this.panel = new XDebuggerTreePanel(project, javaDebugProcess.getEditorsProvider(), (Disposable)this, null, "Kotlin.XDebugger.Actions", null);
        ComboBox combobox2 = new ComboBox();
        combobox2.setRenderer((ListCellRenderer)this.createRenderer());
        combobox2.addItem(null);
        ActionToolbarImpl toolbar = this.createToolbar();
        Wrapper threadsPanel = new Wrapper();
        threadsPanel.setBorder((Border)new CustomLineBorder(0, 0, 1, 0));
        threadsPanel.add((Component)toolbar.getComponent(), (Object)"East");
        threadsPanel.add((Component)combobox2, (Object)"Center");
        this.mainPanel.add((Component)this.panel.getMainPanel(), "Center");
        XDebuggerTree xDebuggerTree = this.panel.getTree();
        Intrinsics.checkNotNullExpressionValue((Object)xDebuggerTree, (String)"getTree(...)");
        this.installClickAndKeyListeners(xDebuggerTree);
    }

    @NotNull
    public final SingleAlarm getAlarm() {
        return this.alarm;
    }

    public final void saveState() {
        DebuggerUIUtil.invokeLater(() -> CoroutineView.saveState$lambda$1(this));
    }

    public final void resetRoot() {
        DebuggerUIUtil.invokeLater(() -> CoroutineView.resetRoot$lambda$2(this));
    }

    public final boolean isShowing() {
        return this.mainPanel.isShowing();
    }

    public final void renewRoot(@NotNull SuspendContextImpl suspendContext) {
        Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
        this.panel.getTree().setRoot((XDebuggerTreeNode)new XCoroutinesRootNode(suspendContext), false);
        if (this.treeState != null) {
            XDebuggerTreeRestorer xDebuggerTreeRestorer = this.restorer;
            if (xDebuggerTreeRestorer != null) {
                xDebuggerTreeRestorer.dispose();
            }
            XDebuggerTreeState xDebuggerTreeState = this.treeState;
            this.restorer = xDebuggerTreeState != null ? xDebuggerTreeState.restoreState(this.panel.getTree()) : null;
        }
    }

    public void dispose() {
        if (this.restorer != null) {
            XDebuggerTreeRestorer xDebuggerTreeRestorer = this.restorer;
            if (xDebuggerTreeRestorer != null) {
                xDebuggerTreeRestorer.dispose();
            }
            this.restorer = null;
        }
    }

    @Override
    @NotNull
    public XDebugSessionListener debugSessionListener(@NotNull XDebugSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        return new CoroutineViewDebugSessionListener(session, this);
    }

    @Override
    @NotNull
    public CreateContentParams createContentParams() {
        JComponent jComponent = this.mainPanel;
        String string = KotlinDebuggerCoroutinesBundle.message("coroutine.view.title", new Object[0]);
        XDebuggerTree xDebuggerTree = this.panel.getTree();
        Intrinsics.checkNotNullExpressionValue((Object)xDebuggerTree, (String)"getTree(...)");
        return new CreateContentParams("XCoroutineThreadsContent", jComponent, string, null, (JComponent)xDebuggerTree);
    }

    private final SimpleListCellRenderer<? super String> createRenderer() {
        SimpleListCellRenderer simpleListCellRenderer = SimpleListCellRenderer.create((arg_0, arg_1, arg_2) -> CoroutineView.createRenderer$lambda$4(CoroutineView::createRenderer$lambda$3, arg_0, arg_1, arg_2));
        Intrinsics.checkNotNullExpressionValue((Object)simpleListCellRenderer, (String)"create(...)");
        return simpleListCellRenderer;
    }

    private final ActionToolbarImpl createToolbar() {
        DefaultActionGroup framesGroup = new DefaultActionGroup();
        AnAction[] anActionArray = new AnAction[]{ActionManager.getInstance().getAction("XDebugger.Frames.TopToolbar")};
        framesGroup.addAll(anActionArray);
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("DebuggerToolbar", (ActionGroup)framesGroup, true);
        Intrinsics.checkNotNull((Object)actionToolbar, (String)"null cannot be cast to non-null type com.intellij.openapi.actionSystem.impl.ActionToolbarImpl");
        ActionToolbarImpl toolbar = (ActionToolbarImpl)actionToolbar;
        toolbar.setReservePlaceAutoPopupIcon(false);
        return toolbar;
    }

    private final void applyRenderer(XValueNode node, SimpleColoredTextIcon presentation) {
        node.setPresentation(presentation.getIcon(), presentation.valuePresentation(), presentation.getHasChildren());
    }

    private final void installClickAndKeyListeners(XDebuggerTree tree2) {
        new CoroutineSelectedNodeListener(this.debugProcess, tree2).install();
    }

    private static final void alarm$lambda$0(CoroutineView this$0) {
        this$0.resetRoot();
    }

    private static final void saveState$lambda$1(CoroutineView this$0) {
        if (!(this$0.panel.getTree().getRoot() instanceof EmptyNode)) {
            this$0.treeState = XDebuggerTreeState.saveState((XDebuggerTree)this$0.panel.getTree());
        }
    }

    private static final void resetRoot$lambda$2(CoroutineView this$0) {
        this$0.panel.getTree().setRoot((XDebuggerTreeNode)this$0.new EmptyNode(), false);
    }

    private static final Unit createRenderer$lambda$3(JBLabel label2, String value, int index2) {
        Intrinsics.checkNotNullParameter((Object)label2, (String)"label");
        if (value != null) {
            label2.setText(value);
        } else if (index2 >= 0) {
            label2.setText(KotlinDebuggerCoroutinesBundle.message("coroutine.dump.threads.loading", new Object[0]));
        }
        return Unit.INSTANCE;
    }

    private static final void createRenderer$lambda$4(Function3 $tmp0, JBLabel p0, Object p1, int p2) {
        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
        $tmp0.invoke((Object)p0, p1, (Object)p2);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\b\u001a\u00020\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView$Companion;", "", "<init>", "()V", "VIEW_CLEAR_DELAY_MS", "", "EMPTY_DISPATCHER_NAME", "", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "getLog", "()Lcom/intellij/openapi/diagnostic/Logger;", "log$delegate", "Lkotlin/properties/ReadOnlyProperty;", "kotlin.jvm-debugger.coroutines"})
    public static final class Companion {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;

        private Companion() {
        }

        @NotNull
        public final Logger getLog() {
            return (Logger)log$delegate.getValue((Object)this, $$delegatedProperties[0]);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Companion.class, "log", "getLog()Lcom/intellij/openapi/diagnostic/Logger;", 0)))};
            $$delegatedProperties = kPropertyArray;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B/\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u000e\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView$CoroutineContainer;", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView$RendererContainer;", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView;", "suspendContext", "Lcom/intellij/debugger/engine/SuspendContextImpl;", "groupName", "", "isCurrent", "", "coroutines", "", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutineInfoData;", "<init>", "(Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView;Lcom/intellij/debugger/engine/SuspendContextImpl;Ljava/lang/String;ZLjava/util/List;)V", "computeChildren", "", "node", "Lcom/intellij/xdebugger/frame/XCompositeNode;", "kotlin.jvm-debugger.coroutines"})
    @SourceDebugExtension(value={"SMAP\nCoroutineView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoroutineView.kt\norg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView$CoroutineContainer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,383:1\n1863#2,2:384\n*S KotlinDebug\n*F\n+ 1 CoroutineView.kt\norg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView$CoroutineContainer\n*L\n280#1:384,2\n*E\n"})
    public final class CoroutineContainer
    extends RendererContainer {
        @NotNull
        private final SuspendContextImpl suspendContext;
        @NotNull
        private final String groupName;
        @Nullable
        private final List<CoroutineInfoData> coroutines;

        public CoroutineContainer(@NotNull SuspendContextImpl suspendContext, String groupName, @Nullable boolean isCurrent, List<? extends CoroutineInfoData> coroutines) {
            Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
            Intrinsics.checkNotNullParameter((Object)groupName, (String)"groupName");
            super(CoroutineView.this.renderer.renderThreadGroup(groupName, isCurrent));
            this.suspendContext = suspendContext;
            this.groupName = groupName;
            this.coroutines = coroutines;
        }

        public void computeChildren(@NotNull XCompositeNode node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            CoroutineViewKt.access$invokeInSuspendContext(CoroutineView.this.debugProcess, this.suspendContext, arg_0 -> CoroutineContainer.computeChildren$lambda$1(this, node, CoroutineView.this, arg_0));
        }

        private static final Unit computeChildren$lambda$1(CoroutineContainer this$0, XCompositeNode $node, CoroutineView this$1, SuspendContextImpl suspendContext) {
            Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
            XValueChildrenList children = new XValueChildrenList();
            List<CoroutineInfoData> list2 = this$0.coroutines;
            if (list2 != null) {
                Iterable $this$forEach$iv = list2;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    CoroutineInfoData it = (CoroutineInfoData)element$iv;
                    boolean bl = false;
                    boolean isCurrent = it.isRunningOnCurrentThread((SuspendContext)suspendContext);
                    children.add((XNamedValue)this$1.new FramesContainer(it, suspendContext, isCurrent, this$0.groupName));
                }
            }
            if (children.size() > 0) {
                $node.addChildren(children, true);
            } else {
                $node.addChildren(XValueChildrenList.singleton((XNamedValue)this$1.new InfoNode("coroutine.view.fetching.not_found")), true);
            }
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView$CoroutineFrameValue;", "Lcom/intellij/xdebugger/frame/XNamedValue;", "frameItem", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutineStackFrameItem;", "<init>", "(Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView;Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutineStackFrameItem;)V", "getFrameItem", "()Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutineStackFrameItem;", "computePresentation", "", "node", "Lcom/intellij/xdebugger/frame/XValueNode;", "place", "Lcom/intellij/xdebugger/frame/XValuePlace;", "kotlin.jvm-debugger.coroutines"})
    public final class CoroutineFrameValue
    extends XNamedValue {
        @NotNull
        private final CoroutineStackFrameItem frameItem;

        public CoroutineFrameValue(CoroutineStackFrameItem frameItem) {
            Intrinsics.checkNotNullParameter((Object)((Object)frameItem), (String)"frameItem");
            super(frameItem.uniqueId());
            this.frameItem = frameItem;
        }

        @NotNull
        public final CoroutineStackFrameItem getFrameItem() {
            return this.frameItem;
        }

        public void computePresentation(@NotNull XValueNode node, @NotNull XValuePlace place) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)place, (String)"place");
            CoroutineView.this.applyRenderer(node, CoroutineView.this.renderer.render(this.frameItem.getLocation()));
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView$CoroutineTopGroupContainer;", "Lcom/intellij/xdebugger/frame/XValueContainer;", "suspendContext", "Lcom/intellij/debugger/engine/SuspendContextImpl;", "<init>", "(Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView;Lcom/intellij/debugger/engine/SuspendContextImpl;)V", "getSuspendContext", "()Lcom/intellij/debugger/engine/SuspendContextImpl;", "computeChildren", "", "node", "Lcom/intellij/xdebugger/frame/XCompositeNode;", "kotlin.jvm-debugger.coroutines"})
    public final class CoroutineTopGroupContainer
    extends XValueContainer {
        @NotNull
        private final SuspendContextImpl suspendContext;

        public CoroutineTopGroupContainer(SuspendContextImpl suspendContext) {
            Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
            this.suspendContext = suspendContext;
        }

        @NotNull
        public final SuspendContextImpl getSuspendContext() {
            return this.suspendContext;
        }

        public void computeChildren(@NotNull XCompositeNode node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            node.setAlreadySorted(true);
            if (this.suspendContext.getSuspendPolicy() != 2) {
                node.addChildren(XValueChildrenList.singleton((XNamedValue)new ErrorNode("to.enable.information.breakpoint.suspend.policy.should.be.set.to.all.threads")), true);
                return;
            }
            XValueChildrenList children = new XValueChildrenList();
            if (Registry.Companion.is("coroutine.panel.show.jobs.hierarchy")) {
                children.add((XNamedValue)new JobsContainer(this.suspendContext));
            } else {
                children.add((XNamedValue)new DispatchersContainer(this.suspendContext));
            }
            node.addChildren(children, true);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0015\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView$CreationFramesContainer;", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView$RendererContainer;", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView;", "creationFrames", "", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CreationCoroutineStackFrameItem;", "<init>", "(Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView;Ljava/util/List;)V", "computeChildren", "", "node", "Lcom/intellij/xdebugger/frame/XCompositeNode;", "kotlin.jvm-debugger.coroutines"})
    @SourceDebugExtension(value={"SMAP\nCoroutineView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoroutineView.kt\norg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView$CreationFramesContainer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,383:1\n1863#2,2:384\n*S KotlinDebug\n*F\n+ 1 CoroutineView.kt\norg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView$CreationFramesContainer\n*L\n328#1:384,2\n*E\n"})
    public final class CreationFramesContainer
    extends RendererContainer {
        @NotNull
        private final List<CreationCoroutineStackFrameItem> creationFrames;

        public CreationFramesContainer(List<CreationCoroutineStackFrameItem> creationFrames) {
            Intrinsics.checkNotNullParameter(creationFrames, (String)"creationFrames");
            super(CoroutineView.this.renderer.renderCreationNode());
            this.creationFrames = creationFrames;
        }

        /*
         * WARNING - void declaration
         */
        public void computeChildren(@NotNull XCompositeNode node) {
            void $this$forEach$iv;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            node.setAlreadySorted(true);
            XValueChildrenList children = new XValueChildrenList();
            Iterable iterable = this.creationFrames;
            CoroutineView coroutineView = CoroutineView.this;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CreationCoroutineStackFrameItem it = (CreationCoroutineStackFrameItem)((Object)element$iv);
                boolean bl = false;
                children.add((XNamedValue)coroutineView.new CoroutineFrameValue(it));
            }
            node.addChildren(children, true);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView$DispatchersContainer;", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView$RendererContainer;", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView;", "suspendContext", "Lcom/intellij/debugger/engine/SuspendContextImpl;", "<init>", "(Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView;Lcom/intellij/debugger/engine/SuspendContextImpl;)V", "getSuspendContext", "()Lcom/intellij/debugger/engine/SuspendContextImpl;", "computeChildren", "", "node", "Lcom/intellij/xdebugger/frame/XCompositeNode;", "kotlin.jvm-debugger.coroutines"})
    @SourceDebugExtension(value={"SMAP\nCoroutineView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoroutineView.kt\norg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView$DispatchersContainer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,383:1\n1485#2:384\n1510#2,3:385\n1513#2,3:395\n1755#2,3:398\n381#3,7:388\n*S KotlinDebug\n*F\n+ 1 CoroutineView.kt\norg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView$DispatchersContainer\n*L\n254#1:384\n254#1:385,3\n254#1:395,3\n258#1:398,3\n254#1:388,7\n*E\n"})
    public final class DispatchersContainer
    extends RendererContainer {
        @NotNull
        private final SuspendContextImpl suspendContext;

        public DispatchersContainer(SuspendContextImpl suspendContext) {
            Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
            super(CoroutineView.this.renderer.renderNoIconNode(KotlinDebuggerCoroutinesBundle.message("coroutine.view.node.dispatchers", new Object[0])));
            this.suspendContext = suspendContext;
        }

        @NotNull
        public final SuspendContextImpl getSuspendContext() {
            return this.suspendContext;
        }

        public void computeChildren(@NotNull XCompositeNode node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            CoroutineViewKt.access$invokeInSuspendContext(CoroutineView.this.debugProcess, this.suspendContext, arg_0 -> DispatchersContainer.computeChildren$lambda$2(node, CoroutineView.this, arg_0));
        }

        /*
         * WARNING - void declaration
         */
        private static final Unit computeChildren$lambda$2(XCompositeNode $node, CoroutineView this$0, SuspendContextImpl suspendContext) {
            void $this$groupByTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
            CoroutineInfoCache coroutineCache = new CoroutineDebugProbesProxy(suspendContext).dumpCoroutines();
            if (!coroutineCache.isOk()) {
                $node.addChildren(XValueChildrenList.singleton((XNamedValue)this$0.new ErrorNode("coroutine.view.fetching.error")), true);
                return Unit.INSTANCE;
            }
            XValueChildrenList children = new XValueChildrenList();
            Iterable $this$groupBy$iv = coroutineCache.getCache();
            boolean $i$f$groupBy = false;
            Iterable iterable = $this$groupBy$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object;
                CoroutineInfoData it = (CoroutineInfoData)element$iv$iv;
                boolean bl = false;
                String key$iv$iv = it.getDescriptor().getDispatcher();
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl2 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv);
            }
            Map groups = destination$iv$iv;
            for (String dispatcher : groups.keySet()) {
                String string;
                boolean isCurrent;
                List coroutines;
                block13: {
                    List list2 = coroutines = (List)groups.get(dispatcher);
                    if (list2 != null) {
                        Iterable $this$any$iv = list2;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            v2 = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                CoroutineInfoData it = (CoroutineInfoData)element$iv;
                                boolean bl = false;
                                if (!it.isRunningOnCurrentThread((SuspendContext)suspendContext)) continue;
                                v2 = true;
                                break block13;
                            }
                            v2 = false;
                        }
                    } else {
                        v2 = isCurrent = false;
                    }
                }
                if ((string = dispatcher) == null) {
                    string = EMPTY_DISPATCHER_NAME;
                }
                children.add((XNamedValue)this$0.new CoroutineContainer(suspendContext, string, isCurrent, coroutines));
            }
            if (children.size() > 0) {
                $node.addChildren(children, true);
            } else {
                $node.addChildren(XValueChildrenList.singleton((XNamedValue)this$0.new InfoNode("coroutine.view.fetching.not_found")), true);
            }
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView$EmptyNode;", "Lcom/intellij/xdebugger/impl/ui/tree/nodes/XValueContainerNode;", "Lcom/intellij/xdebugger/frame/XValueContainer;", "<init>", "(Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView;)V", "kotlin.jvm-debugger.coroutines"})
    public final class EmptyNode
    extends XValueContainerNode<XValueContainer> {
        public EmptyNode() {
            super(CoroutineView.this.panel.getTree(), null, true, new XValueContainer(){});
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView$ErrorNode;", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView$RendererContainer;", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView;", "error", "", "<init>", "(Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView;Ljava/lang/String;)V", "getError", "()Ljava/lang/String;", "kotlin.jvm-debugger.coroutines"})
    public final class ErrorNode
    extends RendererContainer {
        @NotNull
        private final String error;

        public ErrorNode(String error) {
            Intrinsics.checkNotNullParameter((Object)error, (String)"error");
            super(CoroutineView.this.renderer.renderErrorNode(error));
            this.error = error;
        }

        @NotNull
        public final String getError() {
            return this.error;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView$FramesContainer;", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView$RendererContainer;", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView;", "infoData", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutineInfoData;", "suspendContext", "Lcom/intellij/debugger/engine/SuspendContextImpl;", "isCurrent", "", "parentGroupNameToHideFromContext", "", "<init>", "(Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView;Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutineInfoData;Lcom/intellij/debugger/engine/SuspendContextImpl;ZLjava/lang/String;)V", "computeChildren", "", "node", "Lcom/intellij/xdebugger/frame/XCompositeNode;", "kotlin.jvm-debugger.coroutines"})
    @SourceDebugExtension(value={"SMAP\nCoroutineView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoroutineView.kt\norg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView$FramesContainer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,383:1\n1863#2,2:384\n*S KotlinDebug\n*F\n+ 1 CoroutineView.kt\norg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView$FramesContainer\n*L\n309#1:384,2\n*E\n"})
    public final class FramesContainer
    extends RendererContainer {
        @NotNull
        private final CoroutineInfoData infoData;
        @NotNull
        private final SuspendContextImpl suspendContext;

        public FramesContainer(@NotNull CoroutineInfoData infoData, SuspendContextImpl suspendContext, @NotNull boolean isCurrent, String parentGroupNameToHideFromContext) {
            Intrinsics.checkNotNullParameter((Object)infoData, (String)"infoData");
            Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
            Intrinsics.checkNotNullParameter((Object)parentGroupNameToHideFromContext, (String)"parentGroupNameToHideFromContext");
            super(CoroutineView.this.renderer.render(infoData, isCurrent, parentGroupNameToHideFromContext));
            this.infoData = infoData;
            this.suspendContext = suspendContext;
        }

        public void computeChildren(@NotNull XCompositeNode node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            node.setAlreadySorted(true);
            CoroutineViewKt.access$invokeInSuspendContext(CoroutineView.this.debugProcess, this.suspendContext, arg_0 -> FramesContainer.computeChildren$lambda$1(this, CoroutineView.this, node, arg_0));
        }

        private static final Unit computeChildren$lambda$1(FramesContainer this$0, CoroutineView this$1, XCompositeNode $node, SuspendContextImpl suspendContext) {
            Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
            XValueChildrenList children = new XValueChildrenList();
            CoroutineFrameBuilder.Companion.CoroutineFrameItemLists doubleFrameList = CoroutineFrameBuilder.Companion.build(this$0.infoData, suspendContext);
            Object object = doubleFrameList;
            if (object != null && (object = ((CoroutineFrameBuilder.Companion.CoroutineFrameItemLists)object).getFrames()) != null) {
                Iterable $this$forEach$iv = (Iterable)object;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    CoroutineStackFrameItem it = (CoroutineStackFrameItem)((Object)element$iv);
                    boolean bl = false;
                    children.add((XNamedValue)this$1.new CoroutineFrameValue(it));
                }
            }
            CoroutineFrameBuilder.Companion.CoroutineFrameItemLists coroutineFrameItemLists = doubleFrameList;
            List<CreationCoroutineStackFrameItem> creationFrames = coroutineFrameItemLists != null ? coroutineFrameItemLists.getCreationFrames() : null;
            Collection collection = creationFrames;
            if (!(collection == null || collection.isEmpty())) {
                children.add((XNamedValue)this$1.new CreationFramesContainer(creationFrames));
            }
            $node.addChildren(children, true);
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView$InfoNode;", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView$RendererContainer;", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView;", "error", "", "<init>", "(Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView;Ljava/lang/String;)V", "getError", "()Ljava/lang/String;", "kotlin.jvm-debugger.coroutines"})
    public final class InfoNode
    extends RendererContainer {
        @NotNull
        private final String error;

        public InfoNode(String error) {
            Intrinsics.checkNotNullParameter((Object)error, (String)"error");
            super(CoroutineView.this.renderer.renderInfoNode(error));
            this.error = error;
        }

        @NotNull
        public final String getError() {
            return this.error;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0012\u0010\u000f\u001a\u00020\u00102\n\u0010\u0011\u001a\u00060\u0000R\u00020\u0002J\u000e\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u000eJ\u0010\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000b\u001a\f\u0012\b\u0012\u00060\u0000R\u00020\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView$JobContainer;", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView$RendererContainer;", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView;", "suspendContext", "Lcom/intellij/debugger/engine/SuspendContextImpl;", "jobName", "", "isCurrent", "", "<init>", "(Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView;Lcom/intellij/debugger/engine/SuspendContextImpl;Ljava/lang/String;Z)V", "jobs", "", "coroutines", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutineInfoData;", "addJob", "", "jobContainer", "addCoroutine", "coroutine", "computeChildren", "node", "Lcom/intellij/xdebugger/frame/XCompositeNode;", "kotlin.jvm-debugger.coroutines"})
    @SourceDebugExtension(value={"SMAP\nCoroutineView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoroutineView.kt\norg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView$JobContainer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,383:1\n1863#2,2:384\n1863#2,2:386\n*S KotlinDebug\n*F\n+ 1 CoroutineView.kt\norg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView$JobContainer\n*L\n225#1:384,2\n229#1:386,2\n*E\n"})
    public final class JobContainer
    extends RendererContainer {
        @NotNull
        private final SuspendContextImpl suspendContext;
        @NotNull
        private final String jobName;
        @NotNull
        private final List<JobContainer> jobs;
        @NotNull
        private final List<CoroutineInfoData> coroutines;

        public JobContainer(@NotNull SuspendContextImpl suspendContext, String jobName, boolean isCurrent) {
            Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
            Intrinsics.checkNotNullParameter((Object)jobName, (String)"jobName");
            super(CoroutineView.this.renderer.renderThreadGroup(jobName, isCurrent));
            this.suspendContext = suspendContext;
            this.jobName = jobName;
            this.jobs = new ArrayList();
            this.coroutines = new ArrayList();
        }

        public final void addJob(@NotNull JobContainer jobContainer) {
            Intrinsics.checkNotNullParameter((Object)((Object)jobContainer), (String)"jobContainer");
            this.jobs.add(jobContainer);
        }

        public final void addCoroutine(@NotNull CoroutineInfoData coroutine) {
            Intrinsics.checkNotNullParameter((Object)coroutine, (String)"coroutine");
            this.coroutines.add(coroutine);
        }

        public void computeChildren(@NotNull XCompositeNode node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            node.setAlreadySorted(true);
            CoroutineViewKt.access$invokeInSuspendContext(CoroutineView.this.debugProcess, this.suspendContext, arg_0 -> JobContainer.computeChildren$lambda$2(this, node, CoroutineView.this, arg_0));
        }

        private static final Unit computeChildren$lambda$2(JobContainer this$0, XCompositeNode $node, CoroutineView this$1, SuspendContextImpl suspendContext) {
            Object it;
            Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
            XValueChildrenList children = new XValueChildrenList();
            Iterable $this$forEach$iv = this$0.jobs;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (JobContainer)((Object)element$iv);
                boolean bl = false;
                children.add((XNamedValue)it);
            }
            $this$forEach$iv = this$0.coroutines;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (CoroutineInfoData)element$iv;
                boolean bl = false;
                boolean isCurrent = ((CoroutineInfoData)it).isRunningOnCurrentThread((SuspendContext)suspendContext);
                children.add((XNamedValue)this$1.new FramesContainer((CoroutineInfoData)it, suspendContext, isCurrent, this$0.jobName));
            }
            if (children.size() > 0) {
                $node.addChildren(children, true);
            } else {
                $node.addChildren(XValueChildrenList.singleton((XNamedValue)this$1.new InfoNode("coroutine.view.fetching.not_found")), true);
            }
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView$JobsContainer;", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView$RendererContainer;", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView;", "suspendContext", "Lcom/intellij/debugger/engine/SuspendContextImpl;", "<init>", "(Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView;Lcom/intellij/debugger/engine/SuspendContextImpl;)V", "getSuspendContext", "()Lcom/intellij/debugger/engine/SuspendContextImpl;", "computeChildren", "", "node", "Lcom/intellij/xdebugger/frame/XCompositeNode;", "kotlin.jvm-debugger.coroutines"})
    @SourceDebugExtension(value={"SMAP\nCoroutineView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoroutineView.kt\norg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView$JobsContainer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,383:1\n774#2:384\n865#2,2:385\n1216#2,2:387\n1246#2,4:389\n1863#2:393\n1863#2,2:394\n1864#2:396\n*S KotlinDebug\n*F\n+ 1 CoroutineView.kt\norg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView$JobsContainer\n*L\n169#1:384\n169#1:385,2\n170#1:387,2\n170#1:389,4\n171#1:393\n175#1:394,2\n171#1:396\n*E\n"})
    public final class JobsContainer
    extends RendererContainer {
        @NotNull
        private final SuspendContextImpl suspendContext;

        public JobsContainer(SuspendContextImpl suspendContext) {
            Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
            super(CoroutineView.this.renderer.renderNoIconNode(KotlinDebuggerCoroutinesBundle.message("coroutine.view.node.jobs", new Object[0])));
            this.suspendContext = suspendContext;
        }

        @NotNull
        public final SuspendContextImpl getSuspendContext() {
            return this.suspendContext;
        }

        public void computeChildren(@NotNull XCompositeNode node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            CoroutineViewKt.access$invokeInSuspendContext(CoroutineView.this.debugProcess, this.suspendContext, arg_0 -> JobsContainer.computeChildren$lambda$8(node, CoroutineView.this, arg_0));
        }

        private static final JobContainer computeChildren$lambda$8$lambda$7$lambda$6$lambda$4(Map $jobToCoroutineInfo, CoroutineView this$0, SuspendContextImpl $suspendContext, boolean $isCurrent, Ref.ObjectRef $parent, XValueChildrenList $jobs, String jobDetails) {
            JobContainer jobContainer;
            String coroutineName;
            Intrinsics.checkNotNullParameter((Object)jobDetails, (String)"jobDetails");
            Object object = (CoroutineInfoData)$jobToCoroutineInfo.get(jobDetails);
            String string = coroutineName = object != null && (object = ((CoroutineInfoData)object).getDescriptor()) != null ? ((CoroutineDescriptor)object).formatName() : null;
            String jobName = (String)(string != null ? "\"" + string + "\":" : "") + jobDetails;
            JobContainer jobContainer2 = jobContainer = this$0.new JobContainer($suspendContext, jobName, $isCurrent);
            boolean bl = false;
            if ($parent.element == null) {
                $jobs.add((XNamedValue)jobContainer2);
            } else {
                Object object2 = $parent.element;
                Intrinsics.checkNotNull((Object)object2);
                ((JobContainer)((Object)object2)).addJob(jobContainer2);
            }
            return jobContainer;
        }

        private static final JobContainer computeChildren$lambda$8$lambda$7$lambda$6$lambda$5(Function1 $tmp0, Object p0) {
            return (JobContainer)((Object)$tmp0.invoke(p0));
        }

        /*
         * WARNING - void declaration
         */
        private static final Unit computeChildren$lambda$8(XCompositeNode $node, CoroutineView this$0, SuspendContextImpl suspendContext) {
            void $this$associateByTo$iv$iv;
            void $this$associateBy$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
            CoroutineInfoCache coroutineCache = new CoroutineDebugProbesProxy(suspendContext).dumpCoroutines();
            if (!coroutineCache.isOk()) {
                $node.addChildren(XValueChildrenList.singleton((XNamedValue)this$0.new ErrorNode("coroutine.view.fetching.error")), true);
                return Unit.INSTANCE;
            }
            Map jobNodes = new LinkedHashMap();
            XValueChildrenList jobs = new XValueChildrenList();
            XValueChildrenList coroutines = new XValueChildrenList();
            List<CoroutineInfoData> cache2 = coroutineCache.getCache();
            Iterable iterable = cache2;
            boolean $i$f$filter = false;
            void var11_10 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                CoroutineInfoData it = (CoroutineInfoData)element$iv$iv;
                boolean bl = false;
                boolean bl2 = !((Collection)it.getJobHierarchy()).isEmpty();
                if (!bl2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            destination$iv$iv = $this$associateBy$iv;
            Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                CoroutineInfoData bl = (CoroutineInfoData)element$iv$iv;
                Map map = destination$iv$iv2;
                boolean bl3 = false;
                CoroutineInfoData it = (CoroutineInfoData)element$iv$iv;
                String string = (String)CollectionsKt.first(it.getJobHierarchy());
                boolean bl4 = false;
                CoroutineInfoData coroutineInfoData = it;
                map.put(string, coroutineInfoData);
            }
            Map jobToCoroutineInfo = destination$iv$iv2;
            Iterable $this$forEach$iv = cache2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CoroutineInfoData coroutine = (CoroutineInfoData)element$iv;
                boolean bl = false;
                boolean isCurrent = coroutine.isRunningOnCurrentThread((SuspendContext)suspendContext);
                if (!((Collection)coroutine.getJobHierarchy()).isEmpty()) {
                    Ref.ObjectRef parent = new Ref.ObjectRef();
                    Iterable $this$forEach$iv2 = CollectionsKt.reversed((Iterable)coroutine.getJobHierarchy());
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv2 : $this$forEach$iv2) {
                        String it = (String)element$iv2;
                        boolean bl5 = false;
                        parent.element = jobNodes.computeIfAbsent(it, arg_0 -> JobsContainer.computeChildren$lambda$8$lambda$7$lambda$6$lambda$5(arg_0 -> JobsContainer.computeChildren$lambda$8$lambda$7$lambda$6$lambda$4(jobToCoroutineInfo, this$0, suspendContext, isCurrent, parent, jobs, arg_0), arg_0));
                    }
                    Object v = jobNodes.get(coroutine.getJobHierarchy().get(0));
                    Intrinsics.checkNotNull(v);
                    ((JobContainer)((Object)v)).addCoroutine(coroutine);
                    continue;
                }
                coroutines.add((XNamedValue)this$0.new FramesContainer(coroutine, suspendContext, isCurrent, ""));
            }
            if (jobs.size() + coroutines.size() > 0) {
                $node.addChildren(jobs, true);
                $node.addChildren(coroutines, true);
            } else {
                $node.addChildren(XValueChildrenList.singleton((XNamedValue)this$0.new InfoNode("coroutine.view.fetching.not_found")), true);
            }
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0096\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView$RendererContainer;", "Lcom/intellij/xdebugger/frame/XNamedValue;", "presentation", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/SimpleColoredTextIcon;", "<init>", "(Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView;Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/SimpleColoredTextIcon;)V", "getPresentation", "()Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/SimpleColoredTextIcon;", "computePresentation", "", "node", "Lcom/intellij/xdebugger/frame/XValueNode;", "place", "Lcom/intellij/xdebugger/frame/XValuePlace;", "kotlin.jvm-debugger.coroutines"})
    public class RendererContainer
    extends XNamedValue {
        @NotNull
        private final SimpleColoredTextIcon presentation;

        public RendererContainer(SimpleColoredTextIcon presentation) {
            Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
            super(presentation.simpleString());
            this.presentation = presentation;
        }

        @NotNull
        public final SimpleColoredTextIcon getPresentation() {
            return this.presentation;
        }

        public void computePresentation(@NotNull XValueNode node, @NotNull XValuePlace place) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)place, (String)"place");
            CoroutineView.this.applyRenderer(node, this.presentation);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\f\u0012\b\u0012\u00060\u0002R\u00020\u00030\u0001B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView$XCoroutinesRootNode;", "Lcom/intellij/xdebugger/impl/ui/tree/nodes/XValueContainerNode;", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView$CoroutineTopGroupContainer;", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView;", "suspendContext", "Lcom/intellij/debugger/engine/SuspendContextImpl;", "<init>", "(Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView;Lcom/intellij/debugger/engine/SuspendContextImpl;)V", "kotlin.jvm-debugger.coroutines"})
    public final class XCoroutinesRootNode
    extends XValueContainerNode<CoroutineTopGroupContainer> {
        public XCoroutinesRootNode(SuspendContextImpl suspendContext) {
            Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
            super(CoroutineView.this.panel.getTree(), null, false, (XValueContainer)new CoroutineTopGroupContainer(suspendContext));
        }
    }
}

