/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.gradleJava.scripting;

import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFileBase;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.gradleJava.scripting.GradleImportHelperKt;
import org.jetbrains.kotlin.idea.gradleJava.scripting.UtilsKt;
import org.jetbrains.kotlin.idea.gradleJava.scripting.roots.GradleBuildRoot;
import org.jetbrains.kotlin.idea.gradleJava.scripting.roots.GradleBuildRootsLocator;
import org.jetbrains.kotlin.idea.gradleJava.scripting.roots.GradleBuildRootsManager;
import org.jetbrains.kotlin.idea.gradleJava.scripting.roots.GradleScriptInfo;
import org.jetbrains.kotlin.idea.util.FileUtils;
import org.jetbrains.kotlin.scripting.definitions.ScriptDefinitionProvider;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/gradleJava/scripting/LoadKtGradleConfigurationAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "<init>", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "ensureValidActionVisibility", "getNotificationVisibility", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "getKotlinScriptFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "kotlin.gradle.gradle-java"})
public final class LoadKtGradleConfigurationAction
extends AnAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (editor == null) {
            return;
        }
        Editor editor2 = editor;
        VirtualFile virtualFile = this.getKotlinScriptFile(editor2);
        if (virtualFile == null) {
            return;
        }
        VirtualFile file = virtualFile;
        Object object = GradleBuildRootsManager.Companion.getInstance(project2);
        if (object == null || (object = ((GradleBuildRootsLocator)object).getScriptInfo(file)) == null || (object = ((GradleScriptInfo)object).getBuildRoot()) == null) {
            return;
        }
        Object root = object;
        GradleImportHelperKt.runPartialGradleImport(project2, (GradleBuildRoot)root);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.ensureValidActionVisibility(e);
    }

    private final void ensureValidActionVisibility(AnActionEvent e) {
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (editor == null) {
            return;
        }
        Editor editor2 = editor;
        e.getPresentation().setVisible(this.getNotificationVisibility(editor2));
    }

    private final boolean getNotificationVisibility(Editor editor) {
        if (!GradleImportHelperKt.getScriptConfigurationsNeedToBeUpdatedBalloon()) {
            return false;
        }
        if (DiffUtil.isDiffEditor((Editor)editor)) {
            return false;
        }
        Project project = editor.getProject();
        if (project == null) {
            return false;
        }
        Project project2 = project;
        if (ScriptDefinitionProvider.Companion.getServiceIfCreated(project2) == null) {
            return false;
        }
        VirtualFile virtualFile = this.getKotlinScriptFile(editor);
        if (virtualFile == null) {
            return false;
        }
        VirtualFile file = virtualFile;
        if (GradleImportHelperKt.autoReloadScriptConfigurations(project2, file)) {
            return false;
        }
        GradleBuildRootsManager gradleBuildRootsManager = GradleBuildRootsManager.Companion.getInstance(project2);
        return gradleBuildRootsManager != null ? gradleBuildRootsManager.isConfigurationOutOfDate(file) : false;
    }

    private final VirtualFile getKotlinScriptFile(Editor editor) {
        Object object;
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(editor.getDocument());
        if (virtualFile != null) {
            VirtualFile virtualFile2;
            VirtualFile it = virtualFile2 = virtualFile;
            boolean bl = false;
            object = !(it instanceof LightVirtualFileBase) && it.isValid() && FileUtils.isKotlinFileType(it) && UtilsKt.isGradleKotlinScript(it) ? virtualFile2 : null;
        } else {
            object = null;
        }
        return object;
    }
}

