/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2.codeinsight.fixes;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.components.KaTypeRelationChecker;
import org.jetbrains.kotlin.analysis.api.fir.diagnostics.KaFirDiagnostic;
import org.jetbrains.kotlin.analysis.api.types.KaType;
import org.jetbrains.kotlin.idea.codeinsight.api.applicators.fixes.KotlinQuickFixFactory;
import org.jetbrains.kotlin.idea.k2.codeinsight.fixes.ConvertClassToKClassFixFactoriesKt;
import org.jetbrains.kotlin.idea.quickfix.ConvertKClassToClassFix;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtExpressionCodeFragment;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiFactory;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0012\u001a\u0004\u0018\u00010\u0013*\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018H\u0002R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\bR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\bR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\b\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/fixes/ConvertKClassToClassFixFactories;", "", "<init>", "()V", "argumentTypeMismatchFixFactory", "Lorg/jetbrains/kotlin/idea/codeinsight/api/applicators/fixes/KotlinQuickFixFactory$ModCommandBased;", "Lorg/jetbrains/kotlin/analysis/api/fir/diagnostics/KaFirDiagnostic$ArgumentTypeMismatch;", "getArgumentTypeMismatchFixFactory", "()Lorg/jetbrains/kotlin/idea/codeinsight/api/applicators/fixes/KotlinQuickFixFactory$ModCommandBased;", "returnTypeMismatchFixFactory", "Lorg/jetbrains/kotlin/analysis/api/fir/diagnostics/KaFirDiagnostic$ReturnTypeMismatch;", "getReturnTypeMismatchFixFactory", "initializerTypeMismatchFixFactory", "Lorg/jetbrains/kotlin/analysis/api/fir/diagnostics/KaFirDiagnostic$InitializerTypeMismatch;", "getInitializerTypeMismatchFixFactory", "assignmentTypeMismatchFixFactory", "Lorg/jetbrains/kotlin/analysis/api/fir/diagnostics/KaFirDiagnostic$AssignmentTypeMismatch;", "getAssignmentTypeMismatchFixFactory", "createFixIfAvailable", "Lorg/jetbrains/kotlin/idea/quickfix/ConvertKClassToClassFix;", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "element", "Lcom/intellij/psi/PsiElement;", "expectedType", "Lorg/jetbrains/kotlin/analysis/api/types/KaType;", "actualType", "kotlin.code-insight.fixes.k2"})
public final class ConvertKClassToClassFixFactories {
    @NotNull
    public static final ConvertKClassToClassFixFactories INSTANCE = new ConvertKClassToClassFixFactories();
    @NotNull
    private static final KotlinQuickFixFactory.ModCommandBased<KaFirDiagnostic.ArgumentTypeMismatch> argumentTypeMismatchFixFactory = ConvertKClassToClassFixFactories::argumentTypeMismatchFixFactory$lambda$0;
    @NotNull
    private static final KotlinQuickFixFactory.ModCommandBased<KaFirDiagnostic.ReturnTypeMismatch> returnTypeMismatchFixFactory = ConvertKClassToClassFixFactories::returnTypeMismatchFixFactory$lambda$1;
    @NotNull
    private static final KotlinQuickFixFactory.ModCommandBased<KaFirDiagnostic.InitializerTypeMismatch> initializerTypeMismatchFixFactory = ConvertKClassToClassFixFactories::initializerTypeMismatchFixFactory$lambda$2;
    @NotNull
    private static final KotlinQuickFixFactory.ModCommandBased<KaFirDiagnostic.AssignmentTypeMismatch> assignmentTypeMismatchFixFactory = ConvertKClassToClassFixFactories::assignmentTypeMismatchFixFactory$lambda$3;

    private ConvertKClassToClassFixFactories() {
    }

    @NotNull
    public final KotlinQuickFixFactory.ModCommandBased<KaFirDiagnostic.ArgumentTypeMismatch> getArgumentTypeMismatchFixFactory() {
        return argumentTypeMismatchFixFactory;
    }

    @NotNull
    public final KotlinQuickFixFactory.ModCommandBased<KaFirDiagnostic.ReturnTypeMismatch> getReturnTypeMismatchFixFactory() {
        return returnTypeMismatchFixFactory;
    }

    @NotNull
    public final KotlinQuickFixFactory.ModCommandBased<KaFirDiagnostic.InitializerTypeMismatch> getInitializerTypeMismatchFixFactory() {
        return initializerTypeMismatchFixFactory;
    }

    @NotNull
    public final KotlinQuickFixFactory.ModCommandBased<KaFirDiagnostic.AssignmentTypeMismatch> getAssignmentTypeMismatchFixFactory() {
        return assignmentTypeMismatchFixFactory;
    }

    private final ConvertKClassToClassFix createFixIfAvailable(KaSession $this$createFixIfAvailable, PsiElement element, KaType expectedType, KaType actualType) {
        if (!(element instanceof KtExpression)) {
            return null;
        }
        if (!ConvertClassToKClassFixFactoriesKt.isKClass($this$createFixIfAvailable, actualType) || !ConvertClassToKClassFixFactoriesKt.isJavaClass($this$createFixIfAvailable, expectedType)) {
            return null;
        }
        Project project = ((KtExpression)element).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KtExpressionCodeFragment codeFragment = new KtPsiFactory(project, false, 2, null).createExpressionCodeFragment(((KtExpression)element).getText() + ".java", element);
        KtExpression ktExpression = codeFragment.getContentElement();
        if (ktExpression == null) {
            return null;
        }
        KtExpression contentElement = ktExpression;
        KaType kaType = $this$createFixIfAvailable.getExpressionType(contentElement);
        if (kaType == null) {
            return null;
        }
        KaType javaLangClassType = kaType;
        if (!KaTypeRelationChecker.isSubtypeOf$default((KaTypeRelationChecker)$this$createFixIfAvailable, javaLangClassType, expectedType, null, 2, null)) {
            return null;
        }
        return new ConvertKClassToClassFix((KtExpression)element);
    }

    private static final List argumentTypeMismatchFixFactory$lambda$0(KaSession $context_receiver_0, KaFirDiagnostic.ArgumentTypeMismatch diagnostic) {
        Intrinsics.checkNotNullParameter((Object)$context_receiver_0, (String)"$context_receiver_0");
        Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
        return CollectionsKt.listOfNotNull((Object)((Object)INSTANCE.createFixIfAvailable($context_receiver_0, (PsiElement)diagnostic.getPsi(), diagnostic.getExpectedType(), diagnostic.getActualType())));
    }

    private static final List returnTypeMismatchFixFactory$lambda$1(KaSession $context_receiver_0, KaFirDiagnostic.ReturnTypeMismatch diagnostic) {
        Intrinsics.checkNotNullParameter((Object)$context_receiver_0, (String)"$context_receiver_0");
        Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
        return CollectionsKt.listOfNotNull((Object)((Object)INSTANCE.createFixIfAvailable($context_receiver_0, (PsiElement)diagnostic.getPsi(), diagnostic.getExpectedType(), diagnostic.getActualType())));
    }

    private static final List initializerTypeMismatchFixFactory$lambda$2(KaSession $context_receiver_0, KaFirDiagnostic.InitializerTypeMismatch diagnostic) {
        Intrinsics.checkNotNullParameter((Object)$context_receiver_0, (String)"$context_receiver_0");
        Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
        Object PSI = diagnostic.getPsi();
        KtProperty ktProperty = PSI instanceof KtProperty ? (KtProperty)PSI : null;
        return CollectionsKt.listOfNotNull((Object)((Object)INSTANCE.createFixIfAvailable($context_receiver_0, (PsiElement)(ktProperty != null ? ktProperty.getInitializer() : null), diagnostic.getExpectedType(), diagnostic.getActualType())));
    }

    private static final List assignmentTypeMismatchFixFactory$lambda$3(KaSession $context_receiver_0, KaFirDiagnostic.AssignmentTypeMismatch diagnostic) {
        Intrinsics.checkNotNullParameter((Object)$context_receiver_0, (String)"$context_receiver_0");
        Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
        return CollectionsKt.listOfNotNull((Object)((Object)INSTANCE.createFixIfAvailable($context_receiver_0, (PsiElement)diagnostic.getPsi(), diagnostic.getExpectedType(), diagnostic.getActualType())));
    }
}

