/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2.codeinsight.inspections;

import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.components.KaTypeRelationChecker;
import org.jetbrains.kotlin.analysis.api.symbols.KaClassKind;
import org.jetbrains.kotlin.analysis.api.symbols.KaClassLikeSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaClassSymbol;
import org.jetbrains.kotlin.analysis.api.types.KaClassType;
import org.jetbrains.kotlin.analysis.api.types.KaType;
import org.jetbrains.kotlin.analysis.api.types.TypeUtilsKt;
import org.jetbrains.kotlin.idea.base.psi.TextRangeUtilsKt;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.applicable.inspections.KotlinApplicableInspectionBase;
import org.jetbrains.kotlin.idea.codeinsight.api.applicable.inspections.KotlinModCommandQuickFix;
import org.jetbrains.kotlin.idea.codeinsight.api.applicators.ApplicabilityRange;
import org.jetbrains.kotlin.idea.codeinsight.utils.KotlinPsiUtilsKt;
import org.jetbrains.kotlin.idea.codeinsight.utils.RemoveExplicitTypeUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.VisitorWrappersKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001 B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\u0006\u001a\u00020\u0007*\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0014\u0010\u000b\u001a\u00020\u0007*\u00020\b2\u0006\u0010\f\u001a\u00020\u0002H\u0002J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0007H\u0016J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u0002H\u0016J\u001d\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u0003H\u0014\u00a2\u0006\u0002\u0010\u0019J#\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u0003H\u0014\u00a2\u0006\u0002\u0010\u001cJ\u0010\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0002H\u0016J\u001b\u0010\u001e\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0015\u001a\u00020\u0002H\u0016R\u00020\b\u00a2\u0006\u0002\u0010\u001f\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/inspections/RedundantExplicitTypeInspection;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/applicable/inspections/KotlinApplicableInspectionBase$Simple;", "Lorg/jetbrains/kotlin/psi/KtProperty;", "", "<init>", "()V", "isCompanionObject", "", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "type", "Lorg/jetbrains/kotlin/analysis/api/types/KaType;", "hasRedundantType", "property", "buildVisitor", "Lorg/jetbrains/kotlin/psi/KtVisitorVoid;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "getApplicableRanges", "", "Lcom/intellij/openapi/util/TextRange;", "element", "getProblemDescription", "", "context", "(Lorg/jetbrains/kotlin/psi/KtProperty;Lkotlin/Unit;)Ljava/lang/String;", "createQuickFix", "Lorg/jetbrains/kotlin/idea/codeinsight/api/applicable/inspections/KotlinModCommandQuickFix;", "(Lorg/jetbrains/kotlin/psi/KtProperty;Lkotlin/Unit;)Lorg/jetbrains/kotlin/idea/codeinsight/api/applicable/inspections/KotlinModCommandQuickFix;", "isApplicableByPsi", "prepareContext", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtProperty;)Lkotlin/Unit;", "RemoveRedundantTypeFix", "kotlin.code-insight.inspections.k2"})
@SourceDebugExtension(value={"SMAP\nRedundantExplicitTypeInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RedundantExplicitTypeInspection.kt\norg/jetbrains/kotlin/idea/k2/codeinsight/inspections/RedundantExplicitTypeInspection\n+ 2 ApplicabilityRange.kt\norg/jetbrains/kotlin/idea/codeinsight/api/applicators/ApplicabilityRange\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ContextProvider.kt\norg/jetbrains/kotlin/idea/codeinsight/api/applicable/ContextProviderKt\n*L\n1#1,102:1\n23#2,6:103\n1557#3:109\n1628#3,3:110\n43#4:113\n*S KotlinDebug\n*F\n+ 1 RedundantExplicitTypeInspection.kt\norg/jetbrains/kotlin/idea/k2/codeinsight/inspections/RedundantExplicitTypeInspection\n*L\n84#1:103,6\n84#1:109\n84#1:110,3\n100#1:113\n*E\n"})
public final class RedundantExplicitTypeInspection
extends KotlinApplicableInspectionBase.Simple<KtProperty, Unit> {
    private final boolean isCompanionObject(KaSession $this$isCompanionObject, KaType type2) {
        KaClassLikeSymbol kaClassLikeSymbol = TypeUtilsKt.getSymbol(type2);
        KaClassSymbol kaClassSymbol = kaClassLikeSymbol instanceof KaClassSymbol ? (KaClassSymbol)kaClassLikeSymbol : null;
        if (kaClassSymbol == null) {
            return false;
        }
        KaClassSymbol symbol = kaClassSymbol;
        return symbol.getClassKind() == KaClassKind.COMPANION_OBJECT;
    }

    private final boolean hasRedundantType(KaSession $this$hasRedundantType, KtProperty property) {
        if (!property.isLocal()) {
            return false;
        }
        KtTypeReference ktTypeReference = property.getTypeReference();
        if (ktTypeReference == null) {
            return false;
        }
        KtTypeReference typeReference = ktTypeReference;
        if (!((Collection)typeReference.getAnnotationEntries()).isEmpty()) {
            return false;
        }
        KtExpression ktExpression = property.getInitializer();
        if (ktExpression == null) {
            return false;
        }
        KtExpression initializer2 = ktExpression;
        KaType type2 = $this$hasRedundantType.getReturnType((KtDeclaration)property);
        if (type2.getAbbreviation() != null) {
            return false;
        }
        KtExpression ktExpression2 = initializer2;
        if (ktExpression2 instanceof KtConstantExpression) {
            ClassId classId = KotlinPsiUtilsKt.getClassId((KtConstantExpression)initializer2);
            if (classId == null || (classId = classId.asSingleFqName()) == null) {
                return false;
            }
            ClassId fqName2 = classId;
            KaClassType kaClassType = type2 instanceof KaClassType ? (KaClassType)type2 : null;
            if (kaClassType == null) {
                return false;
            }
            KaClassType classType = kaClassType;
            ClassId classId2 = classType.getSymbol().getClassId();
            if (classId2 == null || (classId2 = classId2.asSingleFqName()) == null) {
                return false;
            }
            ClassId typeFqName = classId2;
            if (!Intrinsics.areEqual((Object)typeFqName, (Object)fqName2) || $this$hasRedundantType.isMarkedNullable(type2)) {
                return false;
            }
        } else if (ktExpression2 instanceof KtStringTemplateExpression) {
            if (!$this$hasRedundantType.isStringType(type2) || $this$hasRedundantType.isMarkedNullable(type2)) {
                return false;
            }
        } else if (ktExpression2 instanceof KtNameReferenceExpression) {
            if (!Intrinsics.areEqual((Object)typeReference.getText(), (Object)((KtNameReferenceExpression)initializer2).getReferencedName())) {
                return false;
            }
            KaType kaType = $this$hasRedundantType.getExpressionType(initializer2);
            if (kaType == null) {
                return false;
            }
            KaType initializerType = kaType;
            if (!KaTypeRelationChecker.semanticallyEquals$default($this$hasRedundantType, initializerType, type2, null, 2, null) && this.isCompanionObject($this$hasRedundantType, initializerType)) {
                return false;
            }
        } else if (ktExpression2 instanceof KtCallExpression) {
            KtExpression ktExpression3 = ((KtCallExpression)initializer2).getCalleeExpression();
            if (!Intrinsics.areEqual((Object)typeReference.getText(), (Object)(ktExpression3 != null ? ktExpression3.getText() : null))) {
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    @NotNull
    public KtVisitorVoid buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return VisitorWrappersKt.propertyVisitor(arg_0 -> RedundantExplicitTypeInspection.buildVisitor$lambda$0(this, holder, isOnTheFly, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<TextRange> getApplicableRanges(@NotNull KtProperty element) {
        void $this$mapTo$iv$iv$iv$iv;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        ApplicabilityRange this_$iv = ApplicabilityRange.INSTANCE;
        boolean $i$f$single = false;
        ApplicabilityRange this_$iv$iv = this_$iv;
        boolean $i$f$multiple = false;
        PsiElement it$iv = (PsiElement)element;
        boolean bl = false;
        KtProperty it = (KtProperty)((PsiElement)element);
        boolean bl2 = false;
        Iterable $this$map$iv$iv$iv = CollectionsKt.listOfNotNull((Object)((PsiElement)it.getTypeReference()));
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv$iv$iv;
        Collection destination$iv$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv$iv$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv$iv$iv : $this$mapTo$iv$iv$iv$iv) {
            void it$iv$iv;
            PsiElement psiElement = (PsiElement)item$iv$iv$iv$iv;
            Collection collection = destination$iv$iv$iv$iv;
            boolean bl3 = false;
            collection.add(TextRangeUtilsKt.textRangeIn((PsiElement)it$iv$iv, (PsiElement)element));
        }
        return (List)destination$iv$iv$iv$iv;
    }

    @Override
    @NotNull
    protected String getProblemDescription(@NotNull KtProperty element, @NotNull Unit context2) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return KotlinBundle.message((String)"explicitly.given.type.is.redundant.here", (Object[])new Object[0]);
    }

    @Override
    @NotNull
    protected KotlinModCommandQuickFix<KtProperty> createQuickFix(@NotNull KtProperty element, @NotNull Unit context2) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return new RemoveRedundantTypeFix();
    }

    @Override
    public boolean isApplicableByPsi(@NotNull KtProperty element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return element.getTypeReference() != null;
    }

    @Override
    @Nullable
    public Unit prepareContext(@NotNull KaSession $context_receiver_0, @NotNull KtProperty element) {
        Intrinsics.checkNotNullParameter((Object)$context_receiver_0, (String)"$context_receiver_0");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        boolean $this$asUnit$iv = this.hasRedundantType($context_receiver_0, element);
        boolean $i$f$getAsUnit = false;
        return $this$asUnit$iv ? Unit.INSTANCE : null;
    }

    private static final Unit buildVisitor$lambda$0(RedundantExplicitTypeInspection this$0, ProblemsHolder $holder, boolean $isOnTheFly, KtProperty it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.visitTargetElement((KtElement)it, $holder, $isOnTheFly);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\rH\u0014\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/inspections/RedundantExplicitTypeInspection$RemoveRedundantTypeFix;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/applicable/inspections/KotlinModCommandQuickFix;", "Lorg/jetbrains/kotlin/psi/KtProperty;", "<init>", "()V", "getFamilyName", "", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "element", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "kotlin.code-insight.inspections.k2"})
    private static final class RemoveRedundantTypeFix
    extends KotlinModCommandQuickFix<KtProperty> {
        @Override
        @NotNull
        public String getFamilyName() {
            return KotlinBundle.message((String)"remove.explicit.type.specification", (Object[])new Object[0]);
        }

        @Override
        protected void applyFix(@NotNull Project project, @NotNull KtProperty element, @NotNull ModPsiUpdater updater2) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)updater2, (String)"updater");
            RemoveExplicitTypeUtilsKt.removeDeclarationTypeReference((KtDeclaration)element);
        }
    }
}

