/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.codeInsight.ShortenReferencesFacility;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyDelegate;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtTypeReference;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\u0005H\u0016J!\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000eH\u0094\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ConvertLateinitPropertyToNotNullDelegateFix;", "Lcom/intellij/modcommand/PsiUpdateModCommandAction;", "Lorg/jetbrains/kotlin/psi/KtProperty;", "element", "type", "", "<init>", "(Lorg/jetbrains/kotlin/psi/KtProperty;Ljava/lang/String;)V", "getFamilyName", "invoke", "", "actionContext", "Lcom/intellij/modcommand/ActionContext;", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "kotlin.fir.frontend-independent"})
public final class ConvertLateinitPropertyToNotNullDelegateFix
extends PsiUpdateModCommandAction<KtProperty> {
    @NotNull
    private final String type;

    public ConvertLateinitPropertyToNotNullDelegateFix(@NotNull KtProperty element, @NotNull String type2) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        super((PsiElement)element);
        this.type = type2;
    }

    @NotNull
    public String getFamilyName() {
        return KotlinBundle.message((String)"convert.to.notnull.delegate", (Object[])new Object[0]);
    }

    protected void invoke(@NotNull ActionContext actionContext, @NotNull KtProperty element, @NotNull ModPsiUpdater updater2) {
        Intrinsics.checkNotNullParameter((Object)actionContext, (String)"actionContext");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)updater2, (String)"updater");
        KtTypeReference ktTypeReference = element.getTypeReference();
        if (ktTypeReference == null) {
            return;
        }
        KtTypeReference typeReference = ktTypeReference;
        Project project = actionContext.project();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project(...)");
        KtPsiFactory psiFactory = new KtPsiFactory(project, false, 2, null);
        element.removeModifier(KtTokens.LATEINIT_KEYWORD);
        KtPropertyDelegate propertyDelegate = psiFactory.createPropertyDelegate(psiFactory.createExpression("kotlin.properties.Delegates.notNull<" + this.type + ">()"));
        element.addAfter((PsiElement)propertyDelegate, (PsiElement)typeReference);
        element.setTypeReference(null);
        ShortenReferencesFacility.Companion.getInstance().shorten((KtElement)element);
    }
}

