/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.move;

import com.intellij.psi.PsiElement;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.containers.MultiMap;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\f\rB\u0019\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001c\u0010\b\u001a\u00020\u00052\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000b0\nH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0001\u0002\u000e\u000f\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/move/OuterInstanceReferenceUsageInfo;", "Lcom/intellij/usageView/UsageInfo;", "element", "Lcom/intellij/psi/PsiElement;", "isIndirectOuter", "", "<init>", "(Lcom/intellij/psi/PsiElement;Z)V", "reportConflictIfAny", "conflicts", "Lcom/intellij/util/containers/MultiMap;", "", "ExplicitThis", "ImplicitReceiver", "Lorg/jetbrains/kotlin/idea/refactoring/move/OuterInstanceReferenceUsageInfo$ExplicitThis;", "Lorg/jetbrains/kotlin/idea/refactoring/move/OuterInstanceReferenceUsageInfo$ImplicitReceiver;", "kotlin.idea"})
public abstract class OuterInstanceReferenceUsageInfo
extends UsageInfo {
    private final boolean isIndirectOuter;

    private OuterInstanceReferenceUsageInfo(PsiElement element, boolean isIndirectOuter) {
        super(element);
        this.isIndirectOuter = isIndirectOuter;
    }

    public boolean reportConflictIfAny(@NotNull MultiMap<PsiElement, String> conflicts) {
        Intrinsics.checkNotNullParameter(conflicts, (String)"conflicts");
        PsiElement psiElement = this.getElement();
        if (psiElement == null) {
            return false;
        }
        PsiElement element = psiElement;
        if (this.isIndirectOuter) {
            Object[] objectArray = new Object[]{element.getText()};
            conflicts.putValue((Object)element, (Object)KotlinBundle.message((String)"text.indirect.outer.instances.will.not.be.extracted.0", (Object[])objectArray));
            return true;
        }
        return false;
    }

    public /* synthetic */ OuterInstanceReferenceUsageInfo(PsiElement element, boolean isIndirectOuter, DefaultConstructorMarker $constructor_marker) {
        this(element, isIndirectOuter);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/move/OuterInstanceReferenceUsageInfo$ExplicitThis;", "Lorg/jetbrains/kotlin/idea/refactoring/move/OuterInstanceReferenceUsageInfo;", "expression", "Lorg/jetbrains/kotlin/psi/KtThisExpression;", "isIndirectOuter", "", "<init>", "(Lorg/jetbrains/kotlin/psi/KtThisExpression;Z)V", "getExpression", "()Lorg/jetbrains/kotlin/psi/KtThisExpression;", "kotlin.idea"})
    public static final class ExplicitThis
    extends OuterInstanceReferenceUsageInfo {
        public ExplicitThis(@NotNull KtThisExpression expression, boolean isIndirectOuter) {
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            super((PsiElement)expression, isIndirectOuter, null);
        }

        @NotNull
        public final KtThisExpression getExpression() {
            PsiElement psiElement = this.getElement();
            Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtThisExpression");
            return (KtThisExpression)psiElement;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001c\u0010\u000b\u001a\u00020\u00052\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rH\u0016R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/move/OuterInstanceReferenceUsageInfo$ImplicitReceiver;", "Lorg/jetbrains/kotlin/idea/refactoring/move/OuterInstanceReferenceUsageInfo;", "callElement", "Lorg/jetbrains/kotlin/psi/KtElement;", "isIndirectOuter", "", "isDoubleReceiver", "<init>", "(Lorg/jetbrains/kotlin/psi/KtElement;ZZ)V", "getCallElement", "()Lorg/jetbrains/kotlin/psi/KtElement;", "reportConflictIfAny", "conflicts", "Lcom/intellij/util/containers/MultiMap;", "Lcom/intellij/psi/PsiElement;", "", "kotlin.idea"})
    public static final class ImplicitReceiver
    extends OuterInstanceReferenceUsageInfo {
        private final boolean isDoubleReceiver;

        public ImplicitReceiver(@NotNull KtElement callElement, boolean isIndirectOuter, boolean isDoubleReceiver) {
            Intrinsics.checkNotNullParameter((Object)callElement, (String)"callElement");
            super((PsiElement)callElement, isIndirectOuter, null);
            this.isDoubleReceiver = isDoubleReceiver;
        }

        @NotNull
        public final KtElement getCallElement() {
            PsiElement psiElement = this.getElement();
            Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtElement");
            return (KtElement)psiElement;
        }

        @Override
        public boolean reportConflictIfAny(@NotNull MultiMap<PsiElement, String> conflicts) {
            boolean bl;
            Intrinsics.checkNotNullParameter(conflicts, (String)"conflicts");
            if (super.reportConflictIfAny(conflicts)) {
                return true;
            }
            KtQualifiedExpression ktQualifiedExpression = KtPsiUtilKt.getQualifiedExpressionForSelector((KtElement)this.getCallElement());
            KtElement fullCall = ktQualifiedExpression != null ? (KtElement)ktQualifiedExpression : this.getCallElement();
            if (fullCall instanceof KtQualifiedExpression) {
                Object[] objectArray = new Object[]{((KtQualifiedExpression)fullCall).getText()};
                conflicts.putValue((Object)fullCall, (Object)KotlinBundle.message((String)"text.qualified.call.will.not.be.processed.0", (Object[])objectArray));
                bl = true;
            } else if (this.isDoubleReceiver) {
                Object[] objectArray = new Object[]{fullCall.getText()};
                conflicts.putValue((Object)fullCall, (Object)KotlinBundle.message((String)"text.member.extension.call.will.not.be.processed.0", (Object[])objectArray));
                bl = true;
            } else {
                bl = false;
            }
            return bl;
        }
    }
}

