/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.nj2k.conversions;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.nj2k.NewJ2kConverterContext;
import org.jetbrains.kotlin.nj2k.RecursiveConversion;
import org.jetbrains.kotlin.nj2k.conversions.LiteralConversionKt;
import org.jetbrains.kotlin.nj2k.symbols.JKMethodSymbol;
import org.jetbrains.kotlin.nj2k.tree.FormattingKt;
import org.jetbrains.kotlin.nj2k.tree.JKArgument;
import org.jetbrains.kotlin.nj2k.tree.JKArgumentImpl;
import org.jetbrains.kotlin.nj2k.tree.JKArgumentList;
import org.jetbrains.kotlin.nj2k.tree.JKCallExpressionImpl;
import org.jetbrains.kotlin.nj2k.tree.JKElement;
import org.jetbrains.kotlin.nj2k.tree.JKExpression;
import org.jetbrains.kotlin.nj2k.tree.JKFormattingOwner;
import org.jetbrains.kotlin.nj2k.tree.JKLiteralExpression;
import org.jetbrains.kotlin.nj2k.tree.JKQualifiedExpression;
import org.jetbrains.kotlin.nj2k.tree.JKTreeElement;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0010\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0019\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007H\u0016R\u00020\b\u00a2\u0006\u0002\u0010\nJ\f\u0010\u000b\u001a\u00020\f*\u00020\rH\u0002J\u0012\u0010\u000e\u001a\u00020\u000f2\b\b\u0001\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\rH\u0002J\f\u0010\u0013\u001a\u00020\u0014*\u00020\rH\u0002J\f\u0010\u0015\u001a\u00020\u0011*\u00020\rH\u0002J\f\u0010\u0016\u001a\u00020\u0017*\u00020\u0011H\u0002J\f\u0010\u0018\u001a\u00020\u0011*\u00020\rH\u0002J\f\u0010\u0019\u001a\u00020\u0011*\u00020\rH\u0002J\f\u0010\u001a\u001a\u00020\u0011*\u00020\rH\u0002J\u0014\u0010\u001b\u001a\u00020\u0011*\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u0017H\u0002J\u0014\u0010\u001d\u001a\u00020\u0011*\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u0017H\u0002J\u0014\u0010\u001e\u001a\u00020\u0011*\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u0017H\u0002J\f\u0010\u001f\u001a\u00020\u0011*\u00020\u0011H\u0002J\f\u0010 \u001a\u00020\u0011*\u00020\u0011H\u0002J\f\u0010!\u001a\u00020\u0011*\u00020\rH\u0002J\f\u0010\"\u001a\u00020\u0011*\u00020\rH\u0002J\f\u0010#\u001a\u00020\u0011*\u00020\rH\u0002J\u0014\u0010$\u001a\u00020\u0011*\u00020\u00112\u0006\u0010%\u001a\u00020\u0011H\u0002J\f\u0010&\u001a\u00020\u0011*\u00020\u0011H\u0002\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/nj2k/conversions/LiteralConversion;", "Lorg/jetbrains/kotlin/nj2k/RecursiveConversion;", "context", "Lorg/jetbrains/kotlin/nj2k/NewJ2kConverterContext;", "<init>", "(Lorg/jetbrains/kotlin/nj2k/NewJ2kConverterContext;)V", "applyToElement", "Lorg/jetbrains/kotlin/nj2k/tree/JKTreeElement;", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "element", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/nj2k/tree/JKTreeElement;)Lorg/jetbrains/kotlin/nj2k/tree/JKTreeElement;", "addTrimIndentCall", "Lorg/jetbrains/kotlin/nj2k/tree/JKQualifiedExpression;", "Lorg/jetbrains/kotlin/nj2k/tree/JKLiteralExpression;", "createTodoCall", "Lorg/jetbrains/kotlin/nj2k/tree/JKCallExpressionImpl;", "message", "", "cannotConvertLiteralMessage", "convertLiteral", "", "toDoubleLiteral", "isHexLiteral", "", "toFloatLiteral", "toLongLiteral", "toIntLiteral", "convertHexLiteral", "isLongLiteral", "convertBinaryLiteral", "convertOctalLiteral", "cleanFloatAndDoubleLiterals", "cleanIntAndLongLiterals", "convertCharLiteral", "toStringLiteral", "toRawStringLiteral", "replaceOctalEscapes", "format", "replaceFormFeed", "kotlin.j2k.shared"})
@SourceDebugExtension(value={"SMAP\nLiteralConversion.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LiteralConversion.kt\norg/jetbrains/kotlin/nj2k/conversions/LiteralConversion\n+ 2 treeUtils.kt\norg/jetbrains/kotlin/nj2k/tree/TreeUtilsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,218:1\n76#2:219\n73#2,6:220\n216#3,2:226\n216#3,2:228\n*S KotlinDebug\n*F\n+ 1 LiteralConversion.kt\norg/jetbrains/kotlin/nj2k/conversions/LiteralConversion\n*L\n29#1:219\n29#1:220,6\n158#1:226,2\n160#1:228,2\n*E\n"})
public final class LiteralConversion
extends RecursiveConversion {
    public LiteralConversion(@NotNull NewJ2kConverterContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        super(context2);
    }

    @Override
    @NotNull
    public JKTreeElement applyToElement(@NotNull KaSession $context_receiver_0, @NotNull JKTreeElement element) {
        JKTreeElement jKTreeElement;
        Intrinsics.checkNotNullParameter((Object)$context_receiver_0, (String)"$context_receiver_0");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!(element instanceof JKLiteralExpression)) {
            return this.recurse($context_receiver_0, element);
        }
        try {
            JKLiteralExpression $this$applyToElement_u24lambda_u240 = (JKLiteralExpression)element;
            boolean bl = false;
            this.convertLiteral($this$applyToElement_u24lambda_u240);
            jKTreeElement = $this$applyToElement_u24lambda_u240.getType() == JKLiteralExpression.LiteralType.TEXT_BLOCK ? (JKExpression)this.addTrimIndentCall($this$applyToElement_u24lambda_u240) : (JKExpression)$this$applyToElement_u24lambda_u240;
        }
        catch (NumberFormatException numberFormatException) {
            jKTreeElement = this.createTodoCall(this.cannotConvertLiteralMessage((JKLiteralExpression)element));
        }
        return jKTreeElement;
    }

    private final JKQualifiedExpression addTrimIndentCall(JKLiteralExpression $this$addTrimIndentCall) {
        JKTreeElement jKTreeElement;
        JKTreeElement $this$copyTreeAndDetach$iv = $this$addTrimIndentCall;
        boolean $i$f$copyTreeAndDetach = false;
        JKTreeElement $this$copyTree$iv$iv = $this$copyTreeAndDetach$iv;
        boolean $i$f$copyTree = false;
        JKFormattingOwner jKFormattingOwner = FormattingKt.withFormattingFrom((JKFormattingOwner)$this$copyTree$iv$iv.copy(), (JKFormattingOwner)$this$copyTree$iv$iv);
        if (jKFormattingOwner == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.nj2k.tree.JKLiteralExpression");
        }
        JKTreeElement it$iv = jKTreeElement = (JKTreeElement)((JKLiteralExpression)jKFormattingOwner);
        boolean bl = false;
        if (it$iv.getParent() != null) {
            JKElement jKElement = it$iv.getParent();
            Intrinsics.checkNotNull((Object)jKElement);
            it$iv.detach(jKElement);
        }
        return (JKQualifiedExpression)FormattingKt.withFormattingFrom((JKFormattingOwner)new JKQualifiedExpression((JKExpression)jKTreeElement, new JKCallExpressionImpl(this.getSymbolProvider().provideMethodSymbol("kotlin.text.trimIndent"), null, null, this.getTypeFactory().getTypes().getString(), false, 22, null), null, 4, null), (JKFormattingOwner)$this$addTrimIndentCall);
    }

    private final JKCallExpressionImpl createTodoCall(@NonNls String message2) {
        JKMethodSymbol todoMethodSymbol = this.getSymbolProvider().provideMethodSymbol("kotlin.TODO");
        JKArgumentImpl todoMessageArgument = new JKArgumentImpl(new JKLiteralExpression("\"" + message2 + "\"", JKLiteralExpression.LiteralType.STRING, null, 4, null));
        JKArgument[] jKArgumentArray = new JKArgument[]{todoMessageArgument};
        return new JKCallExpressionImpl(todoMethodSymbol, new JKArgumentList(jKArgumentArray), null, null, false, 28, null);
    }

    private final String cannotConvertLiteralMessage(JKLiteralExpression element) {
        String string = element.getType().toString();
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
        String string2 = string.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        String literalType = string2;
        String literalValue = element.getLiteral();
        return "Could not convert " + literalType + " literal '" + literalValue + "' to Kotlin";
    }

    private final void convertLiteral(JKLiteralExpression $this$convertLiteral) {
        String string;
        switch (WhenMappings.$EnumSwitchMapping$0[$this$convertLiteral.getType().ordinal()]) {
            case 1: {
                string = this.toDoubleLiteral($this$convertLiteral);
                break;
            }
            case 2: {
                string = this.toFloatLiteral($this$convertLiteral);
                break;
            }
            case 3: {
                string = this.toLongLiteral($this$convertLiteral);
                break;
            }
            case 4: {
                string = this.toIntLiteral($this$convertLiteral);
                break;
            }
            case 5: {
                string = this.convertCharLiteral($this$convertLiteral);
                break;
            }
            case 6: {
                string = this.toStringLiteral($this$convertLiteral);
                break;
            }
            case 7: {
                string = this.toRawStringLiteral($this$convertLiteral);
                break;
            }
            default: {
                return;
            }
        }
        $this$convertLiteral.setLiteral(string);
    }

    private final String toDoubleLiteral(JKLiteralExpression $this$toDoubleLiteral) {
        Object text = this.cleanFloatAndDoubleLiterals($this$toDoubleLiteral.getLiteral());
        if (this.isHexLiteral((String)text)) {
            text = String.valueOf(Double.parseDouble((String)text));
        }
        if (!StringsKt.contains$default((CharSequence)((CharSequence)text), (CharSequence)".", (boolean)false, (int)2, null) && !StringsKt.contains((CharSequence)((CharSequence)text), (CharSequence)"e", (boolean)true)) {
            text = (String)text + ".";
        }
        if (StringsKt.endsWith$default((String)text, (String)".", (boolean)false, (int)2, null)) {
            text = (String)text + "0";
        }
        return text;
    }

    private final boolean isHexLiteral(String $this$isHexLiteral) {
        return StringsKt.startsWith((String)$this$isHexLiteral, (String)"0x", (boolean)true);
    }

    private final String toFloatLiteral(JKLiteralExpression $this$toFloatLiteral) {
        Object text = this.cleanFloatAndDoubleLiterals($this$toFloatLiteral.getLiteral());
        if (this.isHexLiteral((String)text)) {
            text = String.valueOf(Float.parseFloat((String)text));
        }
        if (!StringsKt.endsWith$default((String)text, (String)"f", (boolean)false, (int)2, null)) {
            text = (String)text + "f";
        }
        return text;
    }

    private final String toLongLiteral(JKLiteralExpression $this$toLongLiteral) {
        return this.convertOctalLiteral(this.convertBinaryLiteral(this.convertHexLiteral(this.cleanIntAndLongLiterals($this$toLongLiteral.getLiteral()), true), true), true) + "L";
    }

    private final String toIntLiteral(JKLiteralExpression $this$toIntLiteral) {
        return this.convertOctalLiteral(this.convertBinaryLiteral(this.convertHexLiteral(this.cleanIntAndLongLiterals($this$toIntLiteral.getLiteral()), false), false), false);
    }

    private final String convertHexLiteral(String $this$convertHexLiteral, boolean isLongLiteral) {
        Object object;
        if (!this.isHexLiteral($this$convertHexLiteral)) {
            return $this$convertHexLiteral;
        }
        BigInteger value = new BigInteger(StringsKt.drop((String)$this$convertHexLiteral, (int)2), 16);
        if (isLongLiteral && value.bitLength() > 63) {
            String string = Long.toString(value.longValue(), CharsKt.checkRadix((int)16));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String string2 = string.substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            object = "-0x" + string2;
        } else if (!isLongLiteral && value.bitLength() > 31) {
            String string = Integer.toString(value.intValue(), CharsKt.checkRadix((int)16));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String string3 = string.substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            object = "-0x" + string3;
        } else {
            object = $this$convertHexLiteral;
        }
        return object;
    }

    private final String convertBinaryLiteral(String $this$convertBinaryLiteral, boolean isLongLiteral) {
        String string;
        if (!StringsKt.startsWith((String)$this$convertBinaryLiteral, (String)"0b", (boolean)true)) {
            return $this$convertBinaryLiteral;
        }
        BigInteger value = new BigInteger(StringsKt.drop((String)$this$convertBinaryLiteral, (int)2), 2);
        if (isLongLiteral) {
            String string2 = Long.toString(value.longValue(), CharsKt.checkRadix((int)10));
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        } else {
            string = String.valueOf(value.intValue());
        }
        return string;
    }

    private final String convertOctalLiteral(String $this$convertOctalLiteral, boolean isLongLiteral) {
        String string;
        if (!StringsKt.startsWith$default((String)$this$convertOctalLiteral, (String)"0", (boolean)false, (int)2, null) || $this$convertOctalLiteral.length() == 1 || Character.toLowerCase($this$convertOctalLiteral.charAt(1)) == 'x') {
            return $this$convertOctalLiteral;
        }
        BigInteger value = new BigInteger(StringsKt.drop((String)$this$convertOctalLiteral, (int)1), 8);
        if (isLongLiteral) {
            String string2 = Long.toString(value.longValue(), CharsKt.checkRadix((int)10));
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        } else {
            String string3 = Integer.toString(value.intValue(), CharsKt.checkRadix((int)10));
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
        }
        return string;
    }

    private final String cleanFloatAndDoubleLiterals(String $this$cleanFloatAndDoubleLiterals) {
        return StringsKt.replace$default((String)StringsKt.replace((String)StringsKt.replace((String)StringsKt.replace((String)StringsKt.replace((String)StringsKt.replace((String)$this$cleanFloatAndDoubleLiterals, (String)"L", (String)"", (boolean)true), (String)"d", (String)"", (boolean)true), (String)".e", (String)"e", (boolean)true), (String)".f", (String)"", (boolean)true), (String)"f", (String)"", (boolean)true), (String)"_", (String)"", (boolean)false, (int)4, null);
    }

    private final String cleanIntAndLongLiterals(String $this$cleanIntAndLongLiterals) {
        return StringsKt.replace$default((String)StringsKt.replace((String)$this$cleanIntAndLongLiterals, (String)"l", (String)"", (boolean)true), (String)"_", (String)"", (boolean)false, (int)4, null);
    }

    private final String convertCharLiteral(JKLiteralExpression $this$convertCharLiteral) {
        CharSequence charSequence = $this$convertCharLiteral.getLiteral();
        Regex regex = LiteralConversionKt.access$getCharOctalEscapeRegex$p();
        Function1 function1 = LiteralConversion::convertCharLiteral$lambda$1;
        return regex.replace(charSequence, function1);
    }

    private final String toStringLiteral(JKLiteralExpression $this$toStringLiteral) {
        CharSequence charSequence = this.replaceOctalEscapes($this$toStringLiteral.getLiteral(), "%s\\u%04x");
        Regex regex = LiteralConversionKt.access$getDollarRegex$p();
        String string = "\\\\$0";
        return this.replaceFormFeed(regex.replace(charSequence, string));
    }

    private final String toRawStringLiteral(JKLiteralExpression $this$toRawStringLiteral) {
        Map.Entry entry;
        Map.Entry element$iv;
        CharSequence charSequence = $this$toRawStringLiteral.getLiteral();
        Regex regex = LiteralConversionKt.access$getImplicitNewlineRegex$p();
        Object object = "$1";
        $this$toRawStringLiteral.setLiteral(regex.replace(charSequence, (String)object));
        while (StringsKt.contains$default((CharSequence)$this$toRawStringLiteral.getLiteral(), (CharSequence)"\\n", (boolean)false, (int)2, null)) {
            charSequence = $this$toRawStringLiteral.getLiteral();
            regex = LiteralConversionKt.access$getEscapedNewlineRegex$p();
            object = "\n$1$2\n$1";
            $this$toRawStringLiteral.setLiteral(regex.replace(charSequence, (String)object));
        }
        Map $this$forEach$iv = LiteralConversionKt.access$getRawStringSpecialCharSimpleReplacements$p();
        boolean $i$f$forEach = false;
        object = $this$forEach$iv.entrySet().iterator();
        while (object.hasNext()) {
            entry = element$iv = (Map.Entry)object.next();
            boolean bl = false;
            String old = (String)entry.getKey();
            String string = (String)entry.getValue();
            $this$toRawStringLiteral.setLiteral(StringsKt.replace$default((String)$this$toRawStringLiteral.getLiteral(), (String)old, (String)string, (boolean)false, (int)4, null));
        }
        $this$forEach$iv = LiteralConversionKt.access$getRawStringSpecialCharRegexReplacements$p();
        $i$f$forEach = false;
        object = $this$forEach$iv.entrySet().iterator();
        while (object.hasNext()) {
            entry = element$iv = object.next();
            boolean bl = false;
            Regex pattern2 = (Regex)entry.getKey();
            String replacement = (String)entry.getValue();
            CharSequence charSequence2 = $this$toRawStringLiteral.getLiteral();
            Function1 function1 = arg_0 -> LiteralConversion.toRawStringLiteral$lambda$4$lambda$3(replacement, arg_0);
            $this$toRawStringLiteral.setLiteral(pattern2.replace(charSequence2, function1));
        }
        charSequence = StringsKt.replace$default((String)this.replaceOctalEscapes($this$toRawStringLiteral.getLiteral(), "%s${'\\u%04x'}"), (String)"\\\\", (String)"\\", (boolean)false, (int)4, null);
        Regex regex2 = LiteralConversionKt.access$getClosingTripleQuoteRegex$p();
        object = "\n$1$2\n$1\"\"\"";
        return regex2.replace(charSequence, (String)object);
    }

    private final String replaceOctalEscapes(String $this$replaceOctalEscapes, String format) {
        CharSequence charSequence = $this$replaceOctalEscapes;
        Regex regex = LiteralConversionKt.access$getStringOctalEscapeRegex$p();
        Function1 function1 = arg_0 -> LiteralConversion.replaceOctalEscapes$lambda$5(format, arg_0);
        return regex.replace(charSequence, function1);
    }

    private final String replaceFormFeed(String $this$replaceFormFeed) {
        CharSequence charSequence = $this$replaceFormFeed;
        Regex regex = LiteralConversionKt.access$getFormFeedRegex$p();
        Function1 function1 = LiteralConversion::replaceFormFeed$lambda$6;
        return regex.replace(charSequence, function1);
    }

    private static final CharSequence convertCharLiteral$lambda$1(MatchResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = "\\u%04x";
        Object[] objectArray = new Object[]{Integer.parseInt((String)it.getGroupValues().get(1), 8)};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    private static final CharSequence toRawStringLiteral$lambda$4$lambda$3(String $replacement, MatchResult matchResult) {
        Intrinsics.checkNotNullParameter((Object)matchResult, (String)"matchResult");
        Object e = matchResult.getGroupValues().get(1);
        Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
        String leadingBackslashes = (String)e;
        return (CharSequence)(leadingBackslashes.length() % 2 == 0 ? leadingBackslashes + $replacement : matchResult.getValue());
    }

    private static final CharSequence replaceOctalEscapes$lambda$5(String $format, MatchResult matchResult) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)matchResult, (String)"matchResult");
        Object e = matchResult.getGroupValues().get(1);
        Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
        String leadingBackslashes = (String)e;
        if (leadingBackslashes.length() % 2 == 0) {
            Object[] objectArray = new Object[]{leadingBackslashes, Integer.parseInt((String)matchResult.getGroupValues().get(2), 8)};
            String string = String.format($format, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
            charSequence = string;
        } else {
            charSequence = matchResult.getValue();
        }
        return charSequence;
    }

    private static final CharSequence replaceFormFeed$lambda$6(MatchResult matchResult) {
        Intrinsics.checkNotNullParameter((Object)matchResult, (String)"matchResult");
        Object e = matchResult.getGroupValues().get(1);
        Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
        String leadingBackslashes = (String)e;
        return leadingBackslashes.length() % 2 == 0 ? (CharSequence)(leadingBackslashes + "\\u000c") : (CharSequence)matchResult.getValue();
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[JKLiteralExpression.LiteralType.values().length];
            try {
                nArray[JKLiteralExpression.LiteralType.DOUBLE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JKLiteralExpression.LiteralType.FLOAT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JKLiteralExpression.LiteralType.LONG.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JKLiteralExpression.LiteralType.INT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JKLiteralExpression.LiteralType.CHAR.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JKLiteralExpression.LiteralType.STRING.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JKLiteralExpression.LiteralType.TEXT_BLOCK.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

