/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.css.parser.property;

import com.openhtmltopdf.css.constants.CSSName;
import com.openhtmltopdf.css.parser.CSSParseException;
import com.openhtmltopdf.css.parser.CSSPrimitiveValue;
import com.openhtmltopdf.css.parser.CounterData;
import com.openhtmltopdf.css.parser.PropertyValue;
import com.openhtmltopdf.css.parser.property.AbstractPropertyBuilder;
import com.openhtmltopdf.css.sheet.PropertyDeclaration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class CounterPropertyBuilder
extends AbstractPropertyBuilder {
    protected abstract int getDefaultValue();

    @Override
    public List<PropertyDeclaration> buildDeclarations(CSSName cssName, List<PropertyValue> values, int origin, boolean important, boolean inheritAllowed) {
        if (values.size() == 1) {
            PropertyValue value2 = values.get(0);
            this.checkInheritAllowed(value2, inheritAllowed);
            if (value2.getCssValueType() == 0) {
                return Collections.singletonList(new PropertyDeclaration(cssName, value2, important, origin));
            }
            if (value2.getPrimitiveType() == 21) {
                if (value2.getCssText().equals("none")) {
                    return Collections.singletonList(new PropertyDeclaration(cssName, value2, important, origin));
                }
                CounterData data = new CounterData(value2.getStringValue(), this.getDefaultValue());
                return Collections.singletonList(new PropertyDeclaration(cssName, new PropertyValue(Collections.singletonList(data), true), important, origin));
            }
            throw new CSSParseException("The syntax of the " + cssName + " property is invalid", -1);
        }
        ArrayList<CounterData> result2 = new ArrayList<CounterData>();
        for (int i = 0; i < values.size(); ++i) {
            int cValue;
            String name;
            PropertyValue value3 = values.get(i);
            if (value3.getPrimitiveType() == 21) {
                name = value3.getStringValue();
                cValue = this.getDefaultValue();
                if (i < values.size() - 1) {
                    PropertyValue next = values.get(i + 1);
                    if (next.getPrimitiveType() == 1) {
                        this.checkNumberIsInteger(cssName, next);
                        cValue = (int)next.getFloatValue();
                    }
                    ++i;
                }
            } else {
                throw new CSSParseException("The syntax of the " + cssName + " property is invalid", -1);
            }
            result2.add(new CounterData(name, cValue));
        }
        return Collections.singletonList(new PropertyDeclaration(cssName, new PropertyValue(result2, true), important, origin));
    }

    private void checkNumberIsInteger(CSSName cssName, CSSPrimitiveValue value2) {
        if ((int)value2.getFloatValue((short)1) != Math.round(value2.getFloatValue((short)1))) {
            throw new CSSParseException("The value " + value2.getFloatValue((short)1) + " in " + cssName + " must be an integer", -1);
        }
    }

    public static class CounterIncrement
    extends CounterPropertyBuilder {
        @Override
        protected int getDefaultValue() {
            return 1;
        }
    }

    public static class CounterReset
    extends CounterPropertyBuilder {
        @Override
        protected int getDefaultValue() {
            return 0;
        }
    }
}

