/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.dependency.impl;

import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.text.StringUtilRt;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.dependency.GraphDataInput;
import org.jetbrains.jps.dependency.GraphDataOutput;
import org.jetbrains.jps.dependency.NodeSource;

public final class PathSource
implements NodeSource {
    @NotNull
    private final String myPath;

    public PathSource(@NotNull String path) {
        if (path == null) {
            PathSource.$$$reportNull$$$0(0);
        }
        this.myPath = File.separatorChar != '/' ? path.replace(File.separatorChar, '/') : path;
    }

    public PathSource(@NotNull GraphDataInput in) throws IOException {
        if (in == null) {
            PathSource.$$$reportNull$$$0(1);
        }
        this.myPath = in.readUTF();
    }

    @Override
    public void write(GraphDataOutput out) throws IOException {
        out.writeUTF(this.myPath);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PathSource that = (PathSource)o;
        if (this.myPath == that.myPath) {
            return true;
        }
        return SystemInfoRt.isFileSystemCaseSensitive ? this.myPath.equals(that.myPath) : this.myPath.equalsIgnoreCase(that.myPath);
    }

    @Override
    public int hashCode() {
        if (this.myPath.isEmpty()) {
            return 0;
        }
        return SystemInfoRt.isFileSystemCaseSensitive ? this.myPath.hashCode() : StringUtilRt.stringHashCodeInsensitive((CharSequence)this.myPath);
    }

    @Override
    public String toString() {
        return this.myPath;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "path";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "in";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/jps/dependency/impl/PathSource";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

