/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.driver;

import java.awt.Component;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import org.assertj.core.util.Preconditions;
import org.assertj.swing.annotation.RunsInEDT;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.dependency.jsr305.Nullable;
import org.assertj.swing.driver.MenuElementComponentQuery;
import org.assertj.swing.edt.GuiActionRunner;
import org.assertj.swing.edt.GuiQuery;

final class JPopupMenuElementsAsTextQuery {
    @Nonnull
    @RunsInEDT
    static String[] menuElementsAsText(final @Nonnull JPopupMenu popupMenu) {
        String[] result = GuiActionRunner.execute(new GuiQuery<String[]>(){

            @Override
            protected String[] executeInEDT() throws Throwable {
                MenuElement[] subElements = popupMenu.getSubElements();
                String[] result = new String[subElements.length];
                for (int i = 0; i < subElements.length; ++i) {
                    MenuElement subElement = Preconditions.checkNotNull(subElements[i]);
                    result[i] = JPopupMenuElementsAsTextQuery.textOf(subElement);
                }
                return result;
            }
        });
        return Preconditions.checkNotNull(result);
    }

    @Nullable
    private static String textOf(@Nonnull MenuElement e) {
        Component c = MenuElementComponentQuery.componentIn(e);
        if (c instanceof JMenuItem) {
            return ((JMenuItem)c).getText();
        }
        return "-";
    }

    private JPopupMenuElementsAsTextQuery() {
    }
}

