/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.execution;

import com.intellij.gradle.toolingExtension.GradleToolingExtensionClass;
import com.intellij.gradle.toolingExtension.impl.GradleToolingExtensionImplClass;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.io.NioPathUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.execution.GradleGroovyUtil;
import org.jetbrains.plugins.gradle.settings.GradleExecutionSettings;
import org.jetbrains.plugins.gradle.tooling.internal.init.Init;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000h\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0015\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0007\n\u0002\u0010\u0012\n\u0002\b\u0002\u001a \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0010\u0010\r\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f0\u000e\u001a\u0006\u0010\u0010\u001a\u00020\n\u001a&\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0004\u001a&\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0004\u001a:\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u00042\u0010\u0010\r\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f0\u000e2\b\u0010\u001a\u001a\u0004\u0018\u00010\u0004\u001a\u0006\u0010\u001b\u001a\u00020\n\u001a\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0007\u001a(\u0010 \u001a\u00020\n2\b\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020$2\u0006\u0010&\u001a\u00020$\u001a\u0006\u0010'\u001a\u00020\n\u001a\u0006\u0010(\u001a\u00020\u0004\u001a\u0006\u0010)\u001a\u00020\u0004\u001a\u0006\u0010*\u001a\u00020\u0004\u001a\u0006\u00100\u001a\u00020\u0004\u001a\u0006\u00101\u001a\u00020\u0004\u001ad\u00102\u001a\u00020\u00042\u0006\u00103\u001a\u00020\u00042\u0006\u00104\u001a\u00020\u00042\u0006\u00105\u001a\u00020\u00042\u0006\u00106\u001a\u00020\u00042\u0006\u00107\u001a\u00020\u00042\b\u00108\u001a\u0004\u0018\u00010\u00042\b\u00109\u001a\u0004\u0018\u00010\u00042\b\u0010:\u001a\u0004\u0018\u00010\u00042\u0006\u0010;\u001a\u00020\f2\u0006\u0010<\u001a\u00020\f2\u0006\u0010=\u001a\u00020\f\u001a\u001c\u0010>\u001a\u00020\u00042\u0012\u0010?\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040,0,H\u0002\u001a!\u0010@\u001a\u00020\u00042\u0012\u0010A\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040B\"\u00020\u0004H\u0002\u00a2\u0006\u0002\u0010C\u001a&\u0010D\u001a\u00020\u00042\u0006\u0010E\u001a\u00020\u00042\u0014\b\u0002\u0010F\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040GH\u0002\u001a0\u0010D\u001a\u00020\u00042\n\u0010H\u001a\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010E\u001a\u00020\u00042\u0012\u0010F\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040GH\u0002\u001a\u001c\u0010D\u001a\u00020\u00042\n\u0010H\u001a\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010E\u001a\u00020\u0004H\u0002\u001a\u0016\u0010I\u001a\u00020\n2\u0006\u0010J\u001a\u00020\u00042\u0006\u0010K\u001a\u00020\u0004\u001a\u001a\u0010L\u001a\u00020\u00042\u0012\b\u0002\u0010\r\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f0\u000e\u001a\u0018\u0010M\u001a\u00020\f2\u0006\u0010N\u001a\u00020\n2\u0006\u0010K\u001a\u00020OH\u0002\u001a \u0010P\u001a\b\u0012\u0004\u0012\u00020\u00040\u000e2\u0010\u0010\r\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f0\u000eH\u0002\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00040,X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00040,X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00040,X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00040,X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006Q"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "MAIN_INIT_SCRIPT_NAME", "", "MAPPER_INIT_SCRIPT_NAME", "WRAPPER_INIT_SCRIPT_NAME", "TEST_INIT_SCRIPT_NAME", "IDEA_PLUGIN_CONFIGURATOR_SCRIPT_NAME", "createMainInitScript", "Ljava/nio/file/Path;", "isBuildSrcProject", "", "toolingExtensionClasses", "", "Ljava/lang/Class;", "createIdeaPluginConfiguratorInitScript", "loadDownloadSourcesInitScript", "dependencyNotation", "taskName", "downloadTarget", "externalProjectPath", "loadLegacyDownloadSourcesInitScript", "loadTaskInitScript", "projectPath", "taskType", "taskConfiguration", "createTargetPathMapperInitScript", "attachTargetPathMapperInitScript", "", "settings", "Lorg/jetbrains/plugins/gradle/settings/GradleExecutionSettings;", "createWrapperInitScript", "gradleVersion", "Lorg/gradle/util/GradleVersion;", "jarFile", "Ljava/io/File;", "scriptFile", "fileWithPathToProperties", "createTestInitScript", "loadCommonTasksUtilsScript", "loadCommonDebuggerUtilsScript", "loadJvmDebugInitScript", "JUNIT_3_COMPARISON_FAILURE", "", "JUNIT_4_COMPARISON_FAILURE", "ASSERTION_FAILED_ERROR", "FILE_COMPARISON_FAILURE", "loadIjTestLoggerInitScript", "loadFileComparisonTestLoggerInitScript", "loadApplicationInitScript", "gradlePath", "runAppTaskName", "mainClassToRun", "javaExePath", "sourceSetName", "params", "intelliJRtPath", "workingDirectory", "useManifestJar", "useArgsFile", "useClasspathFile", "loadEnhanceGradleDaemonClasspathInit", "classesNames", "joinInitScripts", "initScripts", "", "([Ljava/lang/String;)Ljava/lang/String;", "loadInitScript", "resourcePath", "parameters", "", "aClass", "createInitScript", "prefix", "content", "loadToolingExtensionProvidingInitScript", "isContentEquals", "path", "", "getToolingExtensionsJarPaths", "intellij.gradle"})
@JvmName(name="GradleInitScriptUtil")
public final class GradleInitScriptUtil {
    @NotNull
    private static final Logger LOG;
    @NotNull
    public static final String MAIN_INIT_SCRIPT_NAME = "ijInit";
    @NotNull
    public static final String MAPPER_INIT_SCRIPT_NAME = "ijMapper";
    @NotNull
    public static final String WRAPPER_INIT_SCRIPT_NAME = "ijWrapper";
    @NotNull
    public static final String TEST_INIT_SCRIPT_NAME = "ijTestInit";
    @NotNull
    public static final String IDEA_PLUGIN_CONFIGURATOR_SCRIPT_NAME = "ijIdeaPluginConfigurator";
    @NotNull
    private static final List<String> JUNIT_3_COMPARISON_FAILURE;
    @NotNull
    private static final List<String> JUNIT_4_COMPARISON_FAILURE;
    @NotNull
    private static final List<String> ASSERTION_FAILED_ERROR;
    @NotNull
    private static final List<String> FILE_COMPARISON_FAILURE;

    @NotNull
    public static final Path createMainInitScript(boolean isBuildSrcProject, @NotNull Set<? extends Class<?>> toolingExtensionClasses) {
        Intrinsics.checkNotNullParameter(toolingExtensionClasses, (String)"toolingExtensionClasses");
        String[] stringArray = new String[]{GradleInitScriptUtil.loadToolingExtensionProvidingInitScript(toolingExtensionClasses), GradleInitScriptUtil.loadInitScript$default("/org/jetbrains/plugins/gradle/tooling/internal/init/RegistryProcessor.gradle", null, 2, null), GradleInitScriptUtil.loadInitScript$default("/org/jetbrains/plugins/gradle/tooling/internal/init/JetGradlePlugin.gradle", null, 2, null), GradleInitScriptUtil.loadInitScript("/org/jetbrains/plugins/gradle/tooling/internal/init/Init.gradle", MapsKt.mapOf((Pair)TuplesKt.to((Object)"IS_BUILD_SCR_PROJECT", (Object)String.valueOf(isBuildSrcProject))))};
        String initScript = GradleInitScriptUtil.joinInitScripts(stringArray);
        return GradleInitScriptUtil.createInitScript(MAIN_INIT_SCRIPT_NAME, initScript);
    }

    @NotNull
    public static final Path createIdeaPluginConfiguratorInitScript() {
        String initScript = GradleInitScriptUtil.loadInitScript$default("/org/jetbrains/plugins/gradle/tooling/internal/init/IdeaPluginConfigurator.gradle", null, 2, null);
        return GradleInitScriptUtil.createInitScript(IDEA_PLUGIN_CONFIGURATOR_SCRIPT_NAME, initScript);
    }

    @NotNull
    public static final String loadDownloadSourcesInitScript(@NotNull String dependencyNotation, @NotNull String taskName, @NotNull Path downloadTarget, @NotNull String externalProjectPath2) {
        Intrinsics.checkNotNullParameter((Object)dependencyNotation, (String)"dependencyNotation");
        Intrinsics.checkNotNullParameter((Object)taskName, (String)"taskName");
        Intrinsics.checkNotNullParameter((Object)downloadTarget, (String)"downloadTarget");
        Intrinsics.checkNotNullParameter((Object)externalProjectPath2, (String)"externalProjectPath");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"DEPENDENCY_NOTATION", (Object)GradleGroovyUtil.toGroovyStringLiteral(dependencyNotation)), TuplesKt.to((Object)"TARGET_PATH", (Object)GradleGroovyUtil.toGroovyStringLiteral(NioPathUtil.toCanonicalPath((Path)downloadTarget))), TuplesKt.to((Object)"GRADLE_TASK_NAME", (Object)GradleGroovyUtil.toGroovyStringLiteral(taskName)), TuplesKt.to((Object)"GRADLE_PROJECT_PATH", (Object)GradleGroovyUtil.toGroovyStringLiteral(externalProjectPath2))};
        return GradleInitScriptUtil.loadInitScript("/org/jetbrains/plugins/gradle/tooling/internal/init/downloadSources.gradle", MapsKt.mapOf((Pair[])pairArray));
    }

    @NotNull
    public static final String loadLegacyDownloadSourcesInitScript(@NotNull String dependencyNotation, @NotNull String taskName, @NotNull Path downloadTarget, @NotNull String externalProjectPath2) {
        Intrinsics.checkNotNullParameter((Object)dependencyNotation, (String)"dependencyNotation");
        Intrinsics.checkNotNullParameter((Object)taskName, (String)"taskName");
        Intrinsics.checkNotNullParameter((Object)downloadTarget, (String)"downloadTarget");
        Intrinsics.checkNotNullParameter((Object)externalProjectPath2, (String)"externalProjectPath");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"DEPENDENCY_NOTATION", (Object)GradleGroovyUtil.toGroovyStringLiteral(dependencyNotation)), TuplesKt.to((Object)"TARGET_PATH", (Object)GradleGroovyUtil.toGroovyStringLiteral(NioPathUtil.toCanonicalPath((Path)downloadTarget))), TuplesKt.to((Object)"GRADLE_TASK_NAME", (Object)GradleGroovyUtil.toGroovyStringLiteral(taskName)), TuplesKt.to((Object)"GRADLE_PROJECT_PATH", (Object)GradleGroovyUtil.toGroovyStringLiteral(externalProjectPath2))};
        return GradleInitScriptUtil.loadInitScript("/org/jetbrains/plugins/gradle/tooling/internal/init/legacyDownloadSources.gradle", MapsKt.mapOf((Pair[])pairArray));
    }

    @NotNull
    public static final String loadTaskInitScript(@NotNull String projectPath, @NotNull String taskName, @NotNull String taskType, @NotNull Set<? extends Class<?>> toolingExtensionClasses, @Nullable String taskConfiguration) {
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        Intrinsics.checkNotNullParameter((Object)taskName, (String)"taskName");
        Intrinsics.checkNotNullParameter((Object)taskType, (String)"taskType");
        Intrinsics.checkNotNullParameter(toolingExtensionClasses, (String)"toolingExtensionClasses");
        String[] stringArray = new String[2];
        stringArray[0] = GradleInitScriptUtil.loadToolingExtensionProvidingInitScript(toolingExtensionClasses);
        Pair[] pairArray = new Pair[4];
        pairArray[0] = TuplesKt.to((Object)"PROJECT_PATH", (Object)GradleGroovyUtil.toGroovyStringLiteral(projectPath));
        pairArray[1] = TuplesKt.to((Object)"TASK_NAME", (Object)GradleGroovyUtil.toGroovyStringLiteral(taskName));
        pairArray[2] = TuplesKt.to((Object)"TASK_TYPE", (Object)taskType);
        String string = taskConfiguration;
        if (string == null) {
            string = "";
        }
        pairArray[3] = TuplesKt.to((Object)"TASK_CONFIGURATION", (Object)string);
        stringArray[1] = GradleInitScriptUtil.loadInitScript("/org/jetbrains/plugins/gradle/tooling/internal/init/TaskInit.gradle", MapsKt.mapOf((Pair[])pairArray));
        return GradleInitScriptUtil.joinInitScripts(stringArray);
    }

    @NotNull
    public static final Path createTargetPathMapperInitScript() {
        String initScript = GradleInitScriptUtil.loadInitScript$default("/org/jetbrains/plugins/gradle/tooling/internal/init/MapperInit.gradle", null, 2, null);
        return GradleInitScriptUtil.createInitScript(MAPPER_INIT_SCRIPT_NAME, initScript);
    }

    @ApiStatus.Internal
    public static final void attachTargetPathMapperInitScript(@NotNull GradleExecutionSettings settings) {
        Intrinsics.checkNotNullParameter((Object)((Object)settings), (String)"settings");
        Path file = GradleInitScriptUtil.createTargetPathMapperInitScript();
        String[] stringArray = new String[]{"--init-script", ((Object)file).toString()};
        settings.prependArguments(stringArray);
    }

    @NotNull
    public static final Path createWrapperInitScript(@Nullable GradleVersion gradleVersion, @NotNull File jarFile, @NotNull File scriptFile, @NotNull File fileWithPathToProperties) {
        Intrinsics.checkNotNullParameter((Object)jarFile, (String)"jarFile");
        Intrinsics.checkNotNullParameter((Object)scriptFile, (String)"scriptFile");
        Intrinsics.checkNotNullParameter((Object)fileWithPathToProperties, (String)"fileWithPathToProperties");
        Pair[] pairArray = new Pair[4];
        Object object = gradleVersion;
        if (object == null || (object = object.getVersion()) == null || (object = GradleGroovyUtil.toGroovyStringLiteral((String)object)) == null) {
            object = "null";
        }
        pairArray[0] = TuplesKt.to((Object)"GRADLE_VERSION", (Object)object);
        String string = jarFile.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        pairArray[1] = TuplesKt.to((Object)"JAR_FILE", (Object)GradleGroovyUtil.toGroovyStringLiteral(string));
        String string2 = scriptFile.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
        pairArray[2] = TuplesKt.to((Object)"SCRIPT_FILE", (Object)GradleGroovyUtil.toGroovyStringLiteral(string2));
        String string3 = fileWithPathToProperties.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getPath(...)");
        pairArray[3] = TuplesKt.to((Object)"FILE_WITH_PATH_TO_PROPERTIES", (Object)GradleGroovyUtil.toGroovyStringLiteral(string3));
        String initScript = GradleInitScriptUtil.loadInitScript("/org/jetbrains/plugins/gradle/tooling/internal/init/WrapperInit.gradle", MapsKt.mapOf((Pair[])pairArray));
        return GradleInitScriptUtil.createInitScript(WRAPPER_INIT_SCRIPT_NAME, initScript);
    }

    @NotNull
    public static final Path createTestInitScript() {
        String[] stringArray = new String[]{GradleInitScriptUtil.loadInitScript$default("/org/jetbrains/plugins/gradle/tooling/internal/init/TestInit.gradle", null, 2, null)};
        String initScript = GradleInitScriptUtil.joinInitScripts(stringArray);
        return GradleInitScriptUtil.createInitScript(TEST_INIT_SCRIPT_NAME, initScript);
    }

    @NotNull
    public static final String loadCommonTasksUtilsScript() {
        return GradleInitScriptUtil.loadInitScript$default("/org/jetbrains/plugins/gradle/tooling/internal/init/GradleTasksUtil.gradle", null, 2, null);
    }

    @NotNull
    public static final String loadCommonDebuggerUtilsScript() {
        return GradleInitScriptUtil.loadInitScript$default("/org/jetbrains/plugins/gradle/tooling/internal/init/GradleDebuggerUtil.gradle", null, 2, null);
    }

    @NotNull
    public static final String loadJvmDebugInitScript() {
        return GradleInitScriptUtil.loadInitScript$default("/org/jetbrains/plugins/gradle/tooling/internal/init/JvmDebugInit.gradle", null, 2, null);
    }

    @NotNull
    public static final String loadIjTestLoggerInitScript() {
        String[] stringArray = new String[4];
        stringArray[0] = GradleInitScriptUtil.loadInitScript$default("/org/jetbrains/plugins/gradle/tooling/internal/init/TestEventLogger.gradle", null, 2, null);
        stringArray[1] = GradleInitScriptUtil.loadInitScript$default("/org/jetbrains/plugins/gradle/tooling/internal/init/IjTestEventLogger.gradle", null, 2, null);
        stringArray[2] = GradleInitScriptUtil.loadInitScript$default("/org/jetbrains/plugins/gradle/tooling/internal/init/IjTestEventLoggerInit.gradle", null, 2, null);
        Object[] objectArray = new List[]{JUNIT_3_COMPARISON_FAILURE, JUNIT_4_COMPARISON_FAILURE, ASSERTION_FAILED_ERROR, FILE_COMPARISON_FAILURE};
        stringArray[3] = GradleInitScriptUtil.loadEnhanceGradleDaemonClasspathInit(CollectionsKt.listOf((Object[])objectArray));
        return GradleInitScriptUtil.joinInitScripts(stringArray);
    }

    @NotNull
    public static final String loadFileComparisonTestLoggerInitScript() {
        String[] stringArray = new String[]{GradleInitScriptUtil.loadInitScript$default("/org/jetbrains/plugins/gradle/tooling/internal/init/TestEventLogger.gradle", null, 2, null), GradleInitScriptUtil.loadInitScript$default("/org/jetbrains/plugins/gradle/tooling/internal/init/FileComparisonTestEventLogger.gradle", null, 2, null), GradleInitScriptUtil.loadInitScript$default("/org/jetbrains/plugins/gradle/tooling/internal/init/FileComparisonTestEventLoggerInit.gradle", null, 2, null), GradleInitScriptUtil.loadEnhanceGradleDaemonClasspathInit(CollectionsKt.listOf(FILE_COMPARISON_FAILURE))};
        return GradleInitScriptUtil.joinInitScripts(stringArray);
    }

    @NotNull
    public static final String loadApplicationInitScript(@NotNull String gradlePath2, @NotNull String runAppTaskName, @NotNull String mainClassToRun, @NotNull String javaExePath, @NotNull String sourceSetName, @Nullable String params, @Nullable String intelliJRtPath, @Nullable String workingDirectory, boolean useManifestJar, boolean useArgsFile, boolean useClasspathFile) {
        Intrinsics.checkNotNullParameter((Object)gradlePath2, (String)"gradlePath");
        Intrinsics.checkNotNullParameter((Object)runAppTaskName, (String)"runAppTaskName");
        Intrinsics.checkNotNullParameter((Object)mainClassToRun, (String)"mainClassToRun");
        Intrinsics.checkNotNullParameter((Object)javaExePath, (String)"javaExePath");
        Intrinsics.checkNotNullParameter((Object)sourceSetName, (String)"sourceSetName");
        String[] stringArray = new String[2];
        stringArray[0] = GradleInitScriptUtil.loadToolingExtensionProvidingInitScript$default(null, 1, null);
        Pair[] pairArray = new Pair[11];
        pairArray[0] = TuplesKt.to((Object)"GRADLE_PATH", (Object)GradleGroovyUtil.toGroovyStringLiteral(gradlePath2));
        pairArray[1] = TuplesKt.to((Object)"RUN_APP_TASK_NAME", (Object)GradleGroovyUtil.toGroovyStringLiteral(runAppTaskName));
        pairArray[2] = TuplesKt.to((Object)"MAIN_CLASS_TO_RUN", (Object)GradleGroovyUtil.toGroovyStringLiteral(mainClassToRun));
        pairArray[3] = TuplesKt.to((Object)"JAVA_EXE_PATH", (Object)("mapPath(" + GradleGroovyUtil.toGroovyStringLiteral(javaExePath) + ")"));
        pairArray[4] = TuplesKt.to((Object)"SOURCE_SET_NAME", (Object)GradleGroovyUtil.toGroovyStringLiteral(sourceSetName));
        CharSequence charSequence = intelliJRtPath;
        pairArray[5] = TuplesKt.to((Object)"INTELLIJ_RT_PATH", (Object)(charSequence == null || charSequence.length() == 0 ? "null" : "mapPath(" + GradleGroovyUtil.toGroovyStringLiteral(intelliJRtPath) + ")"));
        charSequence = workingDirectory;
        pairArray[6] = TuplesKt.to((Object)"WORKING_DIRECTORY", (Object)(charSequence == null || charSequence.length() == 0 ? "null" : "mapPath(" + GradleGroovyUtil.toGroovyStringLiteral(workingDirectory) + ")"));
        charSequence = params;
        pairArray[7] = TuplesKt.to((Object)"PARAMS", (Object)(charSequence == null || charSequence.length() == 0 ? "// NO PARAMS" : params));
        pairArray[8] = TuplesKt.to((Object)"USE_MANIFEST_JAR", (Object)String.valueOf(useManifestJar));
        pairArray[9] = TuplesKt.to((Object)"USE_ARGS_FILE", (Object)String.valueOf(useArgsFile));
        pairArray[10] = TuplesKt.to((Object)"USE_CLASSPATH_FILE", (Object)String.valueOf(useClasspathFile));
        stringArray[1] = GradleInitScriptUtil.loadInitScript("/org/jetbrains/plugins/gradle/tooling/internal/init/ApplicationTaskInitScript.gradle", MapsKt.mapOf((Pair[])pairArray));
        return GradleInitScriptUtil.joinInitScripts(stringArray);
    }

    private static final String loadEnhanceGradleDaemonClasspathInit(List<? extends List<String>> classesNames) {
        return GradleInitScriptUtil.loadInitScript("/org/jetbrains/plugins/gradle/tooling/internal/init/EnhanceGradleDaemonClasspathInit.gradle", MapsKt.mapOf((Pair)TuplesKt.to((Object)"CLASS_NAMES", (Object)GradleGroovyUtil.toGroovyListLiteral((Collection)classesNames, GradleInitScriptUtil::loadEnhanceGradleDaemonClasspathInit$lambda$1))));
    }

    private static final String joinInitScripts(String ... initScripts) {
        String string = System.lineSeparator();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"lineSeparator(...)");
        return ArraysKt.joinToString$default((Object[])initScripts, (CharSequence)string, null, null, (int)0, null, null, (int)62, null);
    }

    private static final String loadInitScript(String resourcePath, Map<String, String> parameters) {
        return GradleInitScriptUtil.loadInitScript(Init.class, resourcePath, parameters);
    }

    static /* synthetic */ String loadInitScript$default(String string, Map map, int n, Object object) {
        if ((n & 2) != 0) {
            map = MapsKt.emptyMap();
        }
        return GradleInitScriptUtil.loadInitScript(string, map);
    }

    private static final String loadInitScript(Class<?> aClass, String resourcePath, Map<String, String> parameters) {
        String script = GradleInitScriptUtil.loadInitScript(aClass, resourcePath);
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            String replacement = Matcher.quoteReplacement(value);
            CharSequence charSequence = script;
            Regex regex = new Regex(key);
            Intrinsics.checkNotNull((Object)replacement);
            String string = replacement;
            script = regex.replaceFirst(charSequence, string);
        }
        return script;
    }

    private static final String loadInitScript(Class<?> aClass, String resourcePath) {
        URL resource = aClass.getResource(resourcePath);
        if (resource == null) {
            throw new IllegalArgumentException("Cannot find init file " + resourcePath);
        }
        try {
            URL uRL = resource;
            Charset charset = Charsets.UTF_8;
            byte[] byArray = TextStreamsKt.readBytes((URL)uRL);
            return new String(byArray, charset);
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot read init file " + resourcePath, e);
        }
    }

    @NotNull
    public static final Path createInitScript(@NotNull String prefix, @NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        byte[] contentBytes = StringsKt.encodeToByteArray((String)content);
        Path tempDirectory = Path.of(FileUtil.getTempDirectory(), new String[0]);
        Intrinsics.checkNotNull((Object)tempDirectory);
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(tempDirectory, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createDirectories(...)");
        int suffix = 0;
        while (true) {
            String candidateName = prefix + ++suffix + ".gradle";
            Path candidate = tempDirectory.resolve(candidateName);
            try {
                Intrinsics.checkNotNull((Object)candidate);
                FileAttribute[] fileAttributeArray2 = new FileAttribute[]{};
                Intrinsics.checkNotNullExpressionValue((Object)Files.createFile(candidate, Arrays.copyOf(fileAttributeArray2, fileAttributeArray2.length)), (String)"createFile(...)");
                OpenOption[] openOptionArray = new OpenOption[]{};
                Files.write(candidate, contentBytes, Arrays.copyOf(openOptionArray, openOptionArray.length));
                candidate.toFile().deleteOnExit();
                return candidate;
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                Intrinsics.checkNotNull((Object)candidate);
                if (!GradleInitScriptUtil.isContentEquals(candidate, contentBytes)) continue;
                return candidate;
            }
            break;
        }
    }

    @NotNull
    public static final String loadToolingExtensionProvidingInitScript(@NotNull Set<? extends Class<?>> toolingExtensionClasses) {
        Intrinsics.checkNotNullParameter(toolingExtensionClasses, (String)"toolingExtensionClasses");
        String tapiClasspath = GradleGroovyUtil.toGroovyListLiteral((Collection)GradleInitScriptUtil.getToolingExtensionsJarPaths(toolingExtensionClasses), GradleInitScriptUtil::loadToolingExtensionProvidingInitScript$lambda$2);
        return GradleInitScriptUtil.loadInitScript("/org/jetbrains/plugins/gradle/tooling/internal/init/ClassPathExtensionInitScript.gradle", MapsKt.mapOf((Pair)TuplesKt.to((Object)"EXTENSIONS_JARS_PATH", (Object)tapiClasspath)));
    }

    public static /* synthetic */ String loadToolingExtensionProvidingInitScript$default(Set set, int n, Object object) {
        if ((n & 1) != 0) {
            Object[] objectArray = new Class[]{GradleToolingExtensionImplClass.class, GradleToolingExtensionClass.class};
            set = SetsKt.setOf((Object[])objectArray);
        }
        return GradleInitScriptUtil.loadToolingExtensionProvidingInitScript(set);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isContentEquals(Path path, byte[] content) {
        if ((long)content.length != Files.size(path)) return false;
        byte[] byArray = Files.readAllBytes(path);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readAllBytes(...)");
        if (!Arrays.equals(content, byArray)) return false;
        return true;
    }

    private static final Set<String> getToolingExtensionsJarPaths(Set<? extends Class<?>> toolingExtensionClasses) {
        Set set = ContainerUtil.map2SetNotNull((Collection)toolingExtensionClasses, arg_0 -> GradleInitScriptUtil.getToolingExtensionsJarPaths$lambda$4(GradleInitScriptUtil::getToolingExtensionsJarPaths$lambda$3, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"map2SetNotNull(...)");
        return set;
    }

    private static final String loadEnhanceGradleDaemonClasspathInit$lambda$1$lambda$0(String $this$toGroovyListLiteral) {
        Intrinsics.checkNotNullParameter((Object)$this$toGroovyListLiteral, (String)"$this$toGroovyListLiteral");
        return GradleGroovyUtil.toGroovyStringLiteral($this$toGroovyListLiteral);
    }

    private static final String loadEnhanceGradleDaemonClasspathInit$lambda$1(List $this$toGroovyListLiteral) {
        Intrinsics.checkNotNullParameter((Object)$this$toGroovyListLiteral, (String)"$this$toGroovyListLiteral");
        return GradleGroovyUtil.toGroovyListLiteral($this$toGroovyListLiteral, GradleInitScriptUtil::loadEnhanceGradleDaemonClasspathInit$lambda$1$lambda$0);
    }

    private static final String loadToolingExtensionProvidingInitScript$lambda$2(String $this$toGroovyListLiteral) {
        Intrinsics.checkNotNullParameter((Object)$this$toGroovyListLiteral, (String)"$this$toGroovyListLiteral");
        return "mapPath(" + GradleGroovyUtil.toGroovyStringLiteral($this$toGroovyListLiteral) + ")";
    }

    private static final String getToolingExtensionsJarPaths$lambda$3(Class aClass) {
        Intrinsics.checkNotNullParameter((Object)aClass, (String)"aClass");
        String string = PathManager.getJarPathForClass((Class)aClass);
        if (string == null) {
            return null;
        }
        String path = string;
        if (Intrinsics.areEqual((Object)FileUtilRt.getNameWithoutExtension((String)path), (Object)("gradle-api-" + GradleVersion.current().getBaseVersion()))) {
            LOG.warn("The gradle api jar shouldn't be added to the gradle daemon classpath: {" + aClass + "," + path + "}");
            return null;
        }
        String string2 = FileUtil.normalize((String)path);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"normalize(...)");
        if (StringsKt.endsWith$default((String)string2, (String)"lib/app.jar", (boolean)false, (int)2, null)) {
            String message = "Attempting to pass whole IDEA app [" + path + "] into Gradle Daemon for class [" + aClass + "]";
            if (ApplicationManagerEx.isInIntegrationTest()) {
                LOG.error(message);
            } else {
                LOG.warn(message);
            }
        }
        return FileUtil.toCanonicalPath((String)path);
    }

    private static final String getToolingExtensionsJarPaths$lambda$4(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    static {
        Logger logger = Logger.getInstance((String)"org.jetbrains.plugins.gradle.service.execution.GradleInitScriptUtil");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        JUNIT_3_COMPARISON_FAILURE = CollectionsKt.listOf((Object)"junit.framework.ComparisonFailure");
        JUNIT_4_COMPARISON_FAILURE = CollectionsKt.listOf((Object)"org.junit.ComparisonFailure");
        ASSERTION_FAILED_ERROR = CollectionsKt.listOf((Object)"org.opentest4j.AssertionFailedError");
        Object[] objectArray = new String[]{"com.intellij.rt.execution.junit.FileComparisonFailure", "junit.framework.ComparisonFailure"};
        FILE_COMPARISON_FAILURE = CollectionsKt.listOf((Object[])objectArray);
    }
}

