/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class VcsRootChecker {
    public static final ExtensionPointName<VcsRootChecker> EXTENSION_POINT_NAME = new ExtensionPointName("com.intellij.vcsRootChecker");

    public boolean isRoot(@NotNull VirtualFile file) {
        if (file == null) {
            VcsRootChecker.$$$reportNull$$$0(0);
        }
        return this.isRoot(file.getPath());
    }

    @Deprecated
    public boolean isRoot(@NotNull String path) {
        if (path == null) {
            VcsRootChecker.$$$reportNull$$$0(1);
        }
        Logger.getInstance(VcsRootChecker.class).warn("Deprecated API used in " + this, new Throwable());
        VirtualFile file = LocalFileSystem.getInstance().findFileByIoFile(new File(path));
        return file != null && this.isRoot(file);
    }

    public boolean validateRoot(@NotNull VirtualFile file) {
        if (file == null) {
            VcsRootChecker.$$$reportNull$$$0(2);
        }
        return this.isRoot(file);
    }

    @Deprecated
    public boolean validateRoot(@NotNull String path) {
        if (path == null) {
            VcsRootChecker.$$$reportNull$$$0(3);
        }
        return this.isRoot(path);
    }

    @NotNull
    public abstract VcsKey getSupportedVcs();

    public boolean isVcsDir(@NotNull String dirName) {
        if (dirName == null) {
            VcsRootChecker.$$$reportNull$$$0(4);
        }
        return false;
    }

    public boolean isIgnored(@NotNull VirtualFile root, @NotNull VirtualFile checkForIgnore) {
        if (root == null) {
            VcsRootChecker.$$$reportNull$$$0(5);
        }
        if (checkForIgnore == null) {
            VcsRootChecker.$$$reportNull$$$0(6);
        }
        return false;
    }

    @NotNull
    public List<VirtualFile> suggestDependentRoots(@NotNull VirtualFile vcsRoot) {
        if (vcsRoot == null) {
            VcsRootChecker.$$$reportNull$$$0(7);
        }
        List<VirtualFile> list2 = Collections.emptyList();
        if (list2 == null) {
            VcsRootChecker.$$$reportNull$$$0(8);
        }
        return list2;
    }

    public boolean areChildrenValidMappings() {
        return false;
    }

    @Nullable
    public Collection<VirtualFile> detectProjectMappings(@NotNull Project project2, @NotNull Collection<VirtualFile> projectRoots, @NotNull Set<VirtualFile> mappedDirs) throws VcsException {
        if (project2 == null) {
            VcsRootChecker.$$$reportNull$$$0(9);
        }
        if (projectRoots == null) {
            VcsRootChecker.$$$reportNull$$$0(10);
        }
        if (mappedDirs == null) {
            VcsRootChecker.$$$reportNull$$$0(11);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkForIgnore";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsRoot";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/VcsRootChecker";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectRoots";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mappedDirs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/VcsRootChecker";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestDependentRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isRoot";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "validateRoot";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isVcsDir";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isIgnored";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "suggestDependentRoots";
                break;
            }
            case 8: {
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "detectProjectMappings";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 8 -> new IllegalStateException(string2);
        };
    }
}

