/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.stack;

import java.io.IOException;
import java.time.Duration;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ice4j.ResponseCollector;
import org.ice4j.StunException;
import org.ice4j.StunMessageEvent;
import org.ice4j.StunResponseEvent;
import org.ice4j.StunTimeoutEvent;
import org.ice4j.TransportAddress;
import org.ice4j.message.Request;
import org.ice4j.message.Response;
import org.ice4j.stack.StunStack;
import org.ice4j.stack.TransactionID;
import org.ice4j.util.PeriodicRunnable;
import org.jitsi.utils.concurrent.ExecutorFactory;

public class StunClientTransaction {
    private static final Logger logger = Logger.getLogger(StunClientTransaction.class.getName());
    public static final int DEFAULT_MAX_RETRANSMISSIONS = 6;
    public static final int DEFAULT_MAX_WAIT_INTERVAL = 1600;
    public static final int DEFAULT_ORIGINAL_WAIT_INTERVAL = 100;
    private static final ScheduledExecutorService retransmissionTimer = ExecutorFactory.createSingleThreadScheduledExecutor("ice4j.StunClientTransaction-timer-", 60, TimeUnit.SECONDS);
    private static final ExecutorService retransmissionExecutor = ExecutorFactory.createCachedThreadPool("ice4j.StunClientTransaction-executor-");
    public int maxRetransmissions = 6;
    public int originalWaitInterval = 100;
    public int maxWaitInterval = 1600;
    private final StunStack stackCallback;
    private final Request request;
    private final TransportAddress requestDestination;
    private final TransactionID transactionID;
    private final TransportAddress localAddress;
    private final ResponseCollector responseCollector;
    private final AtomicBoolean cancelled = new AtomicBoolean(false);
    private final Retransmitter retransmitter;

    public StunClientTransaction(StunStack stackCallback, Request request, TransportAddress requestDestination, TransportAddress localAddress, ResponseCollector responseCollector) {
        this(stackCallback, request, requestDestination, localAddress, responseCollector, TransactionID.createNewTransactionID());
    }

    public StunClientTransaction(StunStack stackCallback, Request request, TransportAddress requestDestination, TransportAddress localAddress, ResponseCollector responseCollector, TransactionID transactionID) {
        this.stackCallback = stackCallback;
        this.request = request;
        this.localAddress = localAddress;
        this.responseCollector = responseCollector;
        this.requestDestination = requestDestination;
        this.initTransactionConfiguration();
        this.retransmitter = new Retransmitter();
        this.transactionID = transactionID;
        try {
            request.setTransactionID(transactionID.getBytes());
        }
        catch (StunException ex) {
            throw new IllegalArgumentException("The TransactionID class generated an invalid transaction ID");
        }
    }

    void sendRequest() throws IllegalArgumentException, IOException {
        logger.fine("sending STUN  tid " + this.transactionID + " from " + this.localAddress + " to " + this.requestDestination);
        this.sendRequest0();
        this.retransmitter.schedule();
    }

    private void sendRequest0() throws IllegalArgumentException, IOException {
        if (this.cancelled.get()) {
            logger.finer("Trying to resend a cancelled transaction.");
        } else {
            this.stackCallback.getNetAccessManager().sendMessage(this.request, this.localAddress, this.requestDestination);
        }
    }

    Request getRequest() {
        return this.request;
    }

    void cancel() {
        this.cancelled.set(true);
        this.retransmitter.cancel();
    }

    public void handleResponse(StunMessageEvent evt) {
        TransactionID transactionID = this.getTransactionID();
        logger.fine("handleResponse tid " + transactionID);
        if (!Boolean.getBoolean("org.ice4j.KEEP_CRANS_AFTER_A_RESPONSE")) {
            this.cancel();
        }
        this.responseCollector.processResponse(new StunResponseEvent(this.stackCallback, evt.getRawMessage(), (Response)evt.getMessage(), this.request, transactionID));
    }

    TransactionID getTransactionID() {
        return this.transactionID;
    }

    private void initTransactionConfiguration() {
        String maxWaitIntervalStr;
        String originalWaitIntervalStr;
        String maxRetransmissionsStr = System.getProperty("org.ice4j.MAX_RETRANSMISSIONS");
        if (maxRetransmissionsStr != null && maxRetransmissionsStr.trim().length() > 0) {
            try {
                this.maxRetransmissions = Integer.parseInt(maxRetransmissionsStr);
            }
            catch (NumberFormatException e) {
                logger.log(Level.FINE, "Failed to parse MAX_RETRANSMISSIONS", e);
                this.maxRetransmissions = 6;
            }
        }
        if ((originalWaitIntervalStr = System.getProperty("org.ice4j.FIRST_CTRAN_RETRANS_AFTER")) != null && originalWaitIntervalStr.trim().length() > 0) {
            try {
                this.originalWaitInterval = Integer.parseInt(originalWaitIntervalStr);
            }
            catch (NumberFormatException e) {
                logger.log(Level.FINE, "Failed to parse ORIGINAL_WAIT_INTERVAL", e);
                this.originalWaitInterval = 100;
            }
        }
        if ((maxWaitIntervalStr = System.getProperty("org.ice4j.MAX_CTRAN_RETRANS_TIMER")) != null && maxWaitIntervalStr.trim().length() > 0) {
            try {
                this.maxWaitInterval = Integer.parseInt(maxWaitIntervalStr);
            }
            catch (NumberFormatException e) {
                logger.log(Level.FINE, "Failed to parse MAX_WAIT_INTERVAL", e);
                this.maxWaitInterval = 1600;
            }
        }
    }

    public TransportAddress getLocalAddress() {
        return this.localAddress;
    }

    public TransportAddress getRemoteAddress() {
        return this.requestDestination;
    }

    private final class Retransmitter
    extends PeriodicRunnable {
        private int retransmissionCounter;
        private int nextRetransmissionDelay;

        protected Retransmitter() {
            super(retransmissionTimer, retransmissionExecutor);
            this.retransmissionCounter = 0;
            this.nextRetransmissionDelay = StunClientTransaction.this.originalWaitInterval;
        }

        @Override
        protected Duration getDelayUntilNextRun() {
            return Duration.ofMillis(this.nextRetransmissionDelay);
        }

        @Override
        protected void run() {
            ++this.retransmissionCounter;
            int curWaitInterval = this.nextRetransmissionDelay;
            this.nextRetransmissionDelay = Math.min(StunClientTransaction.this.maxWaitInterval, 2 * this.nextRetransmissionDelay);
            if (this.retransmissionCounter <= StunClientTransaction.this.maxRetransmissions) {
                try {
                    logger.fine("retrying STUN tid " + StunClientTransaction.this.transactionID + " from " + StunClientTransaction.this.localAddress + " to " + StunClientTransaction.this.requestDestination + " waited " + curWaitInterval + " ms retrans " + this.retransmissionCounter + " of " + StunClientTransaction.this.maxRetransmissions);
                    StunClientTransaction.this.sendRequest0();
                }
                catch (Exception ex) {
                    logger.log(Level.INFO, "A client tran retransmission failed", ex);
                }
            } else {
                StunClientTransaction.this.stackCallback.removeClientTransaction(StunClientTransaction.this);
                StunClientTransaction.this.responseCollector.processTimeout(new StunTimeoutEvent(StunClientTransaction.this.stackCallback, StunClientTransaction.this.getRequest(), StunClientTransaction.this.getLocalAddress(), StunClientTransaction.this.getTransactionID()));
                this.nextRetransmissionDelay = -1;
            }
        }
    }
}

