/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct VREvent_Process_t")
public class VREventProcess
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int PID;
    public static final int OLDPID;
    public static final int BFORCED;
    public static final int BCONNECTIONLOST;

    public VREventProcess(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VREventProcess.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint32_t")
    public int pid() {
        return VREventProcess.npid(this.address());
    }

    @NativeType(value="uint32_t")
    public int oldPid() {
        return VREventProcess.noldPid(this.address());
    }

    @NativeType(value="bool")
    public boolean bForced() {
        return VREventProcess.nbForced(this.address());
    }

    @NativeType(value="bool")
    public boolean bConnectionLost() {
        return VREventProcess.nbConnectionLost(this.address());
    }

    public static VREventProcess create(long address) {
        return (VREventProcess)VREventProcess.wrap(VREventProcess.class, (long)address);
    }

    @Nullable
    public static VREventProcess createSafe(long address) {
        return address == 0L ? null : (VREventProcess)VREventProcess.wrap(VREventProcess.class, (long)address);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VREventProcess.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VREventProcess.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static int npid(long struct) {
        return UNSAFE.getInt(null, struct + (long)PID);
    }

    public static int noldPid(long struct) {
        return UNSAFE.getInt(null, struct + (long)OLDPID);
    }

    public static boolean nbForced(long struct) {
        return UNSAFE.getByte(null, struct + (long)BFORCED) != 0;
    }

    public static boolean nbConnectionLost(long struct) {
        return UNSAFE.getByte(null, struct + (long)BCONNECTIONLOST) != 0;
    }

    static {
        Struct.Layout layout = VREventProcess.__struct((Struct.Member[])new Struct.Member[]{VREventProcess.__member((int)4), VREventProcess.__member((int)4), VREventProcess.__member((int)1), VREventProcess.__member((int)1)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        PID = layout.offsetof(0);
        OLDPID = layout.offsetof(1);
        BFORCED = layout.offsetof(2);
        BCONNECTIONLOST = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VREventProcess, Buffer> {
        private static final VREventProcess ELEMENT_FACTORY = VREventProcess.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VREventProcess getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint32_t")
        public int pid() {
            return VREventProcess.npid(this.address());
        }

        @NativeType(value="uint32_t")
        public int oldPid() {
            return VREventProcess.noldPid(this.address());
        }

        @NativeType(value="bool")
        public boolean bForced() {
            return VREventProcess.nbForced(this.address());
        }

        @NativeType(value="bool")
        public boolean bConnectionLost() {
            return VREventProcess.nbConnectionLost(this.address());
        }
    }
}

