/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.indexstatemanagement.model.destination;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.commons.destination.message.LegacyBaseMessage;
import org.opensearch.commons.destination.message.LegacyChimeMessage;
import org.opensearch.commons.destination.message.LegacyCustomWebhookMessage;
import org.opensearch.commons.destination.message.LegacySlackMessage;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.indexmanagement.indexstatemanagement.model.destination.Chime;
import org.opensearch.indexmanagement.indexstatemanagement.model.destination.CustomWebhook;
import org.opensearch.indexmanagement.indexstatemanagement.model.destination.DestinationType;
import org.opensearch.indexmanagement.indexstatemanagement.model.destination.Slack;
import org.opensearch.indexmanagement.opensearchapi.OpenSearchExtensionsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u0000 32\u00020\u00012\u00020\u0002:\u00013B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B+\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u000eJ\u0018\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001aJ\t\u0010\u001c\u001a\u00020\u0007H\u00c6\u0003J\u000b\u0010\u001d\u001a\u0004\u0018\u00010\tH\u00c6\u0003J\u000b\u0010\u001e\u001a\u0004\u0018\u00010\u000bH\u00c6\u0003J\u000b\u0010\u001f\u001a\u0004\u0018\u00010\rH\u00c6\u0003J\u000e\u0010 \u001a\u00020!2\u0006\u0010\u0006\u001a\u00020\u0007J7\u0010\"\u001a\u00020\u00002\b\b\u0002\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\rH\u00c6\u0001J\u0013\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010!H\u00d6\u0003J\u001a\u0010&\u001a\u00020\u001a2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u001b\u001a\u00020\u001aH\u0002J\t\u0010'\u001a\u00020(H\u00d6\u0001J\t\u0010)\u001a\u00020\u001aH\u00d6\u0001J\u0018\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020+2\u0006\u0010-\u001a\u00020.H\u0016J\u0010\u0010/\u001a\u0002002\u0006\u00101\u001a\u000202H\u0016R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u00064"}, d2={"Lorg/opensearch/indexmanagement/indexstatemanagement/model/destination/Destination;", "Lorg/opensearch/core/xcontent/ToXContentObject;", "Lorg/opensearch/core/common/io/stream/Writeable;", "sin", "Lorg/opensearch/core/common/io/stream/StreamInput;", "(Lorg/opensearch/core/common/io/stream/StreamInput;)V", "type", "Lorg/opensearch/indexmanagement/indexstatemanagement/model/destination/DestinationType;", "chime", "Lorg/opensearch/indexmanagement/indexstatemanagement/model/destination/Chime;", "slack", "Lorg/opensearch/indexmanagement/indexstatemanagement/model/destination/Slack;", "customWebhook", "Lorg/opensearch/indexmanagement/indexstatemanagement/model/destination/CustomWebhook;", "(Lorg/opensearch/indexmanagement/indexstatemanagement/model/destination/DestinationType;Lorg/opensearch/indexmanagement/indexstatemanagement/model/destination/Chime;Lorg/opensearch/indexmanagement/indexstatemanagement/model/destination/Slack;Lorg/opensearch/indexmanagement/indexstatemanagement/model/destination/CustomWebhook;)V", "getChime", "()Lorg/opensearch/indexmanagement/indexstatemanagement/model/destination/Chime;", "getCustomWebhook", "()Lorg/opensearch/indexmanagement/indexstatemanagement/model/destination/CustomWebhook;", "getSlack", "()Lorg/opensearch/indexmanagement/indexstatemanagement/model/destination/Slack;", "getType", "()Lorg/opensearch/indexmanagement/indexstatemanagement/model/destination/DestinationType;", "buildLegacyBaseMessage", "Lorg/opensearch/commons/destination/message/LegacyBaseMessage;", "compiledSubject", "", "compiledMessage", "component1", "component2", "component3", "component4", "constructResponseForDestinationType", "", "copy", "equals", "", "other", "getLegacyCustomWebhookMessageURL", "hashCode", "", "toString", "toXContent", "Lorg/opensearch/core/xcontent/XContentBuilder;", "builder", "params", "Lorg/opensearch/core/xcontent/ToXContent$Params;", "writeTo", "", "out", "Lorg/opensearch/core/common/io/stream/StreamOutput;", "Companion", "opensearch-index-management"})
public final class Destination
implements ToXContentObject,
Writeable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DestinationType type;
    @Nullable
    private final Chime chime;
    @Nullable
    private final Slack slack;
    @Nullable
    private final CustomWebhook customWebhook;
    @NotNull
    public static final String CHIME = "chime";
    @NotNull
    public static final String SLACK = "slack";
    @NotNull
    public static final String CUSTOMWEBHOOK = "custom_webhook";

    public Destination(@NotNull DestinationType type, @Nullable Chime chime, @Nullable Slack slack, @Nullable CustomWebhook customWebhook) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this.type = type;
        this.chime = chime;
        this.slack = slack;
        this.customWebhook = customWebhook;
    }

    @NotNull
    public final DestinationType getType() {
        return this.type;
    }

    @Nullable
    public final Chime getChime() {
        return this.chime;
    }

    @Nullable
    public final Slack getSlack() {
        return this.slack;
    }

    @Nullable
    public final CustomWebhook getCustomWebhook() {
        return this.customWebhook;
    }

    @NotNull
    public XContentBuilder toXContent(@NotNull XContentBuilder builder, @NotNull ToXContent.Params params) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        builder.startObject().field(this.type.getValue(), this.constructResponseForDestinationType(this.type)).endObject();
        return builder;
    }

    public Destination(@NotNull StreamInput sin) throws IOException {
        Intrinsics.checkNotNullParameter((Object)sin, (String)"sin");
        Enum enum_ = sin.readEnum(DestinationType.class);
        Intrinsics.checkNotNullExpressionValue((Object)enum_, (String)"sin.readEnum(DestinationType::class.java)");
        this((DestinationType)enum_, (Chime)sin.readOptionalWriteable(Chime::new), (Slack)sin.readOptionalWriteable(Slack::new), (CustomWebhook)sin.readOptionalWriteable(CustomWebhook::new));
    }

    public void writeTo(@NotNull StreamOutput out) throws IOException {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out.writeEnum((Enum)this.type);
        out.writeOptionalWriteable((Writeable)this.chime);
        out.writeOptionalWriteable((Writeable)this.slack);
        out.writeOptionalWriteable((Writeable)this.customWebhook);
    }

    @NotNull
    public final LegacyBaseMessage buildLegacyBaseMessage(@Nullable String compiledSubject, @NotNull String compiledMessage) throws IOException {
        Intrinsics.checkNotNullParameter((Object)compiledMessage, (String)"compiledMessage");
        LegacyBaseMessage destinationMessage = null;
        switch (WhenMappings.$EnumSwitchMapping$0[this.type.ordinal()]) {
            case 1: {
                Chime chime = this.chime;
                String messageContent = chime != null ? chime.constructMessageContent(compiledSubject, compiledMessage) : null;
                Chime chime2 = this.chime;
                LegacyChimeMessage legacyChimeMessage = new LegacyChimeMessage.Builder("chime_message").withUrl(chime2 != null ? chime2.getUrl() : null).withMessage(messageContent).build();
                Intrinsics.checkNotNullExpressionValue((Object)legacyChimeMessage, (String)"Builder(\"chime_message\")\u2026                 .build()");
                destinationMessage = (LegacyBaseMessage)legacyChimeMessage;
                break;
            }
            case 2: {
                Slack slack = this.slack;
                String messageContent = slack != null ? slack.constructMessageContent(compiledSubject, compiledMessage) : null;
                Slack slack2 = this.slack;
                LegacySlackMessage legacySlackMessage = new LegacySlackMessage.Builder("slack_message").withUrl(slack2 != null ? slack2.getUrl() : null).withMessage(messageContent).build();
                Intrinsics.checkNotNullExpressionValue((Object)legacySlackMessage, (String)"Builder(\"slack_message\")\u2026                 .build()");
                destinationMessage = (LegacyBaseMessage)legacySlackMessage;
                break;
            }
            case 3: {
                CustomWebhook customWebhook = this.customWebhook;
                LegacyCustomWebhookMessage legacyCustomWebhookMessage = new LegacyCustomWebhookMessage.Builder(CUSTOMWEBHOOK).withUrl(this.getLegacyCustomWebhookMessageURL(this.customWebhook, compiledMessage)).withHeaderParams(customWebhook != null ? customWebhook.getHeaderParams() : null).withMessage(compiledMessage).build();
                Intrinsics.checkNotNullExpressionValue((Object)legacyCustomWebhookMessage, (String)"Builder(\"custom_webhook\"\u2026(compiledMessage).build()");
                destinationMessage = (LegacyBaseMessage)legacyCustomWebhookMessage;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return destinationMessage;
    }

    @NotNull
    public final Object constructResponseForDestinationType(@NotNull DestinationType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Object content = null;
        switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: {
                Object object = this.chime;
                content = object != null && (object = OpenSearchExtensionsKt.convertToMap((ToXContent)object)) != null ? object.get(type.getValue()) : null;
                break;
            }
            case 2: {
                Object object = this.slack;
                content = object != null && (object = OpenSearchExtensionsKt.convertToMap((ToXContent)object)) != null ? object.get(type.getValue()) : null;
                break;
            }
            case 3: {
                Object object = this.customWebhook;
                Object v3 = object != null && (object = OpenSearchExtensionsKt.convertToMap((ToXContent)object)) != null ? object.get(type.getValue()) : (content = null);
            }
        }
        if (content == null) {
            throw new IllegalArgumentException("Content is NULL for destination type " + type.getValue());
        }
        return content;
    }

    private final String getLegacyCustomWebhookMessageURL(CustomWebhook customWebhook, String compiledMessage) {
        CustomWebhook customWebhook2 = customWebhook;
        CustomWebhook customWebhook3 = customWebhook;
        CustomWebhook customWebhook4 = customWebhook;
        CustomWebhook customWebhook5 = customWebhook;
        CustomWebhook customWebhook6 = customWebhook;
        CustomWebhook customWebhook7 = customWebhook;
        String string = new LegacyCustomWebhookMessage.Builder(CUSTOMWEBHOOK).withUrl(customWebhook2 != null ? customWebhook2.getUrl() : null).withScheme(customWebhook3 != null ? customWebhook3.getScheme() : null).withHost(customWebhook4 != null ? customWebhook4.getHost() : null).withPort(customWebhook5 != null ? Integer.valueOf(customWebhook5.getPort()) : null).withPath(customWebhook6 != null ? customWebhook6.getPath() : null).withQueryParams(customWebhook7 != null ? customWebhook7.getQueryParams() : null).withMessage(compiledMessage).build().getUri().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Builder(\"custom_webhook\"\u2026  .build().uri.toString()");
        return string;
    }

    @NotNull
    public final DestinationType component1() {
        return this.type;
    }

    @Nullable
    public final Chime component2() {
        return this.chime;
    }

    @Nullable
    public final Slack component3() {
        return this.slack;
    }

    @Nullable
    public final CustomWebhook component4() {
        return this.customWebhook;
    }

    @NotNull
    public final Destination copy(@NotNull DestinationType type, @Nullable Chime chime, @Nullable Slack slack, @Nullable CustomWebhook customWebhook) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        return new Destination(type, chime, slack, customWebhook);
    }

    public static /* synthetic */ Destination copy$default(Destination destination, DestinationType destinationType, Chime chime, Slack slack, CustomWebhook customWebhook, int n, Object object) {
        if ((n & 1) != 0) {
            destinationType = destination.type;
        }
        if ((n & 2) != 0) {
            chime = destination.chime;
        }
        if ((n & 4) != 0) {
            slack = destination.slack;
        }
        if ((n & 8) != 0) {
            customWebhook = destination.customWebhook;
        }
        return destination.copy(destinationType, chime, slack, customWebhook);
    }

    @NotNull
    public String toString() {
        return "Destination(type=" + this.type + ", chime=" + this.chime + ", slack=" + this.slack + ", customWebhook=" + this.customWebhook + ")";
    }

    public int hashCode() {
        int result2 = this.type.hashCode();
        result2 = result2 * 31 + (this.chime == null ? 0 : this.chime.hashCode());
        result2 = result2 * 31 + (this.slack == null ? 0 : this.slack.hashCode());
        result2 = result2 * 31 + (this.customWebhook == null ? 0 : this.customWebhook.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Destination)) {
            return false;
        }
        Destination destination = (Destination)other;
        if (this.type != destination.type) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.chime, (Object)destination.chime)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.slack, (Object)destination.slack)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.customWebhook, (Object)destination.customWebhook);
    }

    @JvmStatic
    @NotNull
    public static final Destination parse(@NotNull XContentParser xcp) throws IOException {
        return Companion.parse(xcp);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/opensearch/indexmanagement/indexstatemanagement/model/destination/Destination$Companion;", "", "()V", "CHIME", "", "CUSTOMWEBHOOK", "SLACK", "parse", "Lorg/opensearch/indexmanagement/indexstatemanagement/model/destination/Destination;", "xcp", "Lorg/opensearch/core/xcontent/XContentParser;", "opensearch-index-management"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @JvmStatic
        @NotNull
        public final Destination parse(@NotNull XContentParser xcp) throws IOException {
            DestinationType destinationType;
            Intrinsics.checkNotNullParameter((Object)xcp, (String)"xcp");
            Slack slack = null;
            Chime chime = null;
            CustomWebhook customWebhook = null;
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
            block5: while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
                String fieldName;
                block11: {
                    fieldName = xcp.currentName();
                    xcp.nextToken();
                    String string = fieldName;
                    if (string == null) throw new IllegalArgumentException("Invalid field: [" + fieldName + "] found in Destination.");
                    switch (string.hashCode()) {
                        case 109518736: {
                            if (string.equals(Destination.SLACK)) break;
                            throw new IllegalArgumentException("Invalid field: [" + fieldName + "] found in Destination.");
                        }
                        case 697640873: {
                            if (!string.equals(Destination.CUSTOMWEBHOOK)) {
                                throw new IllegalArgumentException("Invalid field: [" + fieldName + "] found in Destination.");
                            }
                            break block11;
                        }
                        case 94631228: {
                            if (!string.equals(Destination.CHIME)) throw new IllegalArgumentException("Invalid field: [" + fieldName + "] found in Destination.");
                            chime = Chime.Companion.parse(xcp);
                            continue block5;
                        }
                    }
                    slack = Slack.Companion.parse(xcp);
                    continue;
                }
                customWebhook = CustomWebhook.Companion.parse(xcp);
                continue;
                throw new IllegalArgumentException("Invalid field: [" + fieldName + "] found in Destination.");
            }
            if (chime != null) {
                destinationType = DestinationType.CHIME;
            } else if (slack != null) {
                destinationType = DestinationType.SLACK;
            } else {
                if (customWebhook == null) throw new IllegalArgumentException("Must specify a destination type");
                destinationType = DestinationType.CUSTOM_WEBHOOK;
            }
            DestinationType type = destinationType;
            return new Destination(type, chime, slack, customWebhook);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DestinationType.values().length];
            try {
                nArray[DestinationType.CHIME.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DestinationType.SLACK.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DestinationType.CUSTOM_WEBHOOK.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

