/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.indexstatemanagement.step.rollup;

import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.client.Client;
import org.opensearch.client.OpenSearchClient;
import org.opensearch.core.action.ActionListener;
import org.opensearch.indexmanagement.indexstatemanagement.step.rollup.WaitForRollupCompletionStep;
import org.opensearch.indexmanagement.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.indexmanagement.rollup.action.explain.ExplainRollupAction;
import org.opensearch.indexmanagement.rollup.action.explain.ExplainRollupRequest;
import org.opensearch.indexmanagement.rollup.action.explain.ExplainRollupResponse;
import org.opensearch.indexmanagement.rollup.model.RollupMetadata;
import org.opensearch.indexmanagement.spi.indexstatemanagement.Step;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.ActionMetaData;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.ActionProperties;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.ManagedIndexMetaData;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.StepMetaData;
import org.opensearch.transport.RemoteTransportException;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\u000f\u001a\u00020\u0001H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0014\u001a\u00020\u0004H\u0016J\"\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\b2\n\u0010\u0019\u001a\u00060\u001aj\u0002`\u001bJ\u001e\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u001eR\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0005R\u001c\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006 "}, d2={"Lorg/opensearch/indexmanagement/indexstatemanagement/step/rollup/WaitForRollupCompletionStep;", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/Step;", "()V", "hasRollupFailed", "", "Ljava/lang/Boolean;", "info", "", "", "", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "stepStatus", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/Step$StepStatus;", "execute", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getUpdatedManagedIndexMetadata", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/model/ManagedIndexMetaData;", "currentMetadata", "isIdempotent", "processFailure", "", "rollupJobId", "indexName", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "processRollupMetadataStatus", "rollupMetadata", "Lorg/opensearch/indexmanagement/rollup/model/RollupMetadata;", "Companion", "opensearch-index-management"})
public final class WaitForRollupCompletionStep
extends Step {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    @NotNull
    private Step.StepStatus stepStatus = Step.StepStatus.STARTING;
    @Nullable
    private Map<String, ? extends Object> info;
    @Nullable
    private Boolean hasRollupFailed;
    @NotNull
    public static final String name = "wait_for_rollup_completion";
    @NotNull
    public static final String JOB_STOPPED_MESSAGE = "Rollup job was stopped";

    public WaitForRollupCompletionStep() {
        super(name, false, 2, null);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public Object execute(@NotNull Continuation<? super Step> var1_1) {
        if (!(var1_1 instanceof execute.1)) ** GOTO lbl-1000
        var10_2 = var1_1;
        if ((var10_2.label & -2147483648) != 0) {
            var10_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ WaitForRollupCompletionStep this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.execute((Continuation<? super Step>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var11_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = this.getContext();
                if (v0 == null) {
                    return this;
                }
                context = v0;
                indexName = context.getMetadata().getIndex();
                managedIndexMetadata = context.getMetadata();
                v1 = managedIndexMetadata.getActionMetaData();
                v2 = v1 != null && (v1 = v1.getActionProperties()) != null ? v1.getRollupId() : (rollupJobId = null);
                if (rollupJobId != null) ** GOTO lbl25
                this.logger.error("No rollup job id passed down");
                this.stepStatus = Step.StepStatus.FAILED;
                this.info = MapsKt.mapOf((Pair)TuplesKt.to((Object)"message", (Object)WaitForRollupCompletionStep.Companion.getMissingRollupJobMessage(indexName)));
                ** GOTO lbl60
lbl25:
                // 1 sources

                explainRollupRequest = new ExplainRollupRequest(CollectionsKt.listOf((Object)rollupJobId));
                $continuation.L$0 = this;
                $continuation.L$1 = indexName;
                $continuation.L$2 = rollupJobId;
                $continuation.label = 1;
                v3 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)context.getClient(), (Function2)new Function2<Client, ActionListener<ExplainRollupResponse>, Unit>(explainRollupRequest){
                    final /* synthetic */ ExplainRollupRequest $explainRollupRequest;
                    {
                        this.$explainRollupRequest = $explainRollupRequest;
                        super(2);
                    }

                    public final void invoke(@NotNull Client $this$suspendUntil, @NotNull ActionListener<ExplainRollupResponse> it) {
                        Intrinsics.checkNotNullParameter((Object)$this$suspendUntil, (String)"$this$suspendUntil");
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        $this$suspendUntil.execute((ActionType)ExplainRollupAction.Companion.getINSTANCE(), (ActionRequest)this.$explainRollupRequest, it);
                    }
                }, $continuation);
                ** if (v3 != var11_4) goto lbl35
lbl34:
                // 1 sources

                return var11_4;
lbl35:
                // 1 sources

                ** GOTO lbl44
            }
            case 1: {
                rollupJobId = (String)$continuation.L$2;
                indexName = (String)$continuation.L$1;
                this = (WaitForRollupCompletionStep)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v3 = $result;
lbl44:
                    // 2 sources

                    response = (ExplainRollupResponse)v3;
                    this.logger.info("Received the status for jobs [" + response.getIdsToExplain$opensearch_index_management().keySet() + "]");
                    v4 = response.getIdsToExplain$opensearch_index_management().get(rollupJobId);
                    v5 = metadata = v4 != null ? v4.getMetadata() : null;
                    if ((v5 != null ? v5.getStatus() : null) == null) {
                        this.logger.warn("Job " + rollupJobId + " has not started yet");
                        this.stepStatus = Step.StepStatus.CONDITION_NOT_MET;
                        this.info = MapsKt.mapOf((Pair)TuplesKt.to((Object)"message", (Object)WaitForRollupCompletionStep.Companion.getJobProcessingMessage(rollupJobId, indexName)));
                    } else {
                        this.processRollupMetadataStatus(rollupJobId, indexName, metadata);
                    }
                }
                catch (RemoteTransportException e) {
                    this.processFailure(rollupJobId, indexName, (Exception)e);
                }
                catch (Exception e) {
                    this.processFailure(rollupJobId, indexName, e);
                }
lbl60:
                // 5 sources

                return this;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public final void processRollupMetadataStatus(@NotNull String rollupJobId, @NotNull String indexName, @NotNull RollupMetadata rollupMetadata) {
        Intrinsics.checkNotNullParameter((Object)rollupJobId, (String)"rollupJobId");
        Intrinsics.checkNotNullParameter((Object)indexName, (String)"indexName");
        Intrinsics.checkNotNullParameter((Object)rollupMetadata, (String)"rollupMetadata");
        switch (WhenMappings.$EnumSwitchMapping$0[rollupMetadata.getStatus().ordinal()]) {
            case 1: {
                this.stepStatus = Step.StepStatus.CONDITION_NOT_MET;
                this.info = MapsKt.mapOf((Pair)TuplesKt.to((Object)"message", (Object)Companion.getJobProcessingMessage(rollupJobId, indexName)));
                break;
            }
            case 2: {
                this.stepStatus = Step.StepStatus.CONDITION_NOT_MET;
                this.info = MapsKt.mapOf((Pair)TuplesKt.to((Object)"message", (Object)Companion.getJobProcessingMessage(rollupJobId, indexName)));
                break;
            }
            case 3: {
                this.stepStatus = Step.StepStatus.FAILED;
                this.hasRollupFailed = true;
                Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"message", (Object)Companion.getJobFailedMessage(rollupJobId, indexName)), TuplesKt.to((Object)"cause", (Object)String.valueOf(rollupMetadata.getFailureReason()))};
                this.info = MapsKt.mapOf((Pair[])pairArray);
                break;
            }
            case 4: {
                this.stepStatus = Step.StepStatus.COMPLETED;
                this.info = MapsKt.mapOf((Pair)TuplesKt.to((Object)"message", (Object)Companion.getJobCompletionMessage(rollupJobId, indexName)));
                break;
            }
            case 5: {
                this.stepStatus = Step.StepStatus.CONDITION_NOT_MET;
                this.info = MapsKt.mapOf((Pair)TuplesKt.to((Object)"message", (Object)Companion.getJobProcessingMessage(rollupJobId, indexName)));
                break;
            }
            case 6: {
                this.stepStatus = Step.StepStatus.FAILED;
                this.hasRollupFailed = true;
                Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"message", (Object)Companion.getJobFailedMessage(rollupJobId, indexName)), TuplesKt.to((Object)"cause", (Object)JOB_STOPPED_MESSAGE)};
                this.info = MapsKt.mapOf((Pair[])pairArray);
            }
        }
    }

    public final void processFailure(@NotNull String rollupJobId, @NotNull String indexName, @NotNull Exception e) {
        Intrinsics.checkNotNullParameter((Object)rollupJobId, (String)"rollupJobId");
        Intrinsics.checkNotNullParameter((Object)indexName, (String)"indexName");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.stepStatus = Step.StepStatus.FAILED;
        String message = Companion.getFailedMessage(rollupJobId, indexName);
        this.logger.error(message, (Throwable)e);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"message", (Object)message)};
        Map mutableInfo = MapsKt.mutableMapOf((Pair[])pairArray);
        String errorMessage = e.getMessage();
        if (errorMessage != null) {
            mutableInfo.put("cause", errorMessage);
        }
        this.info = MapsKt.toMap((Map)mutableInfo);
    }

    @NotNull
    public ManagedIndexMetaData getUpdatedManagedIndexMetadata(@NotNull ManagedIndexMetaData currentMetadata) {
        ActionMetaData actionMetaData;
        ActionMetaData currentActionMetaData;
        Intrinsics.checkNotNullParameter((Object)currentMetadata, (String)"currentMetadata");
        ActionMetaData actionMetaData2 = currentActionMetaData = currentMetadata.getActionMetaData();
        ActionProperties currentActionProperties = actionMetaData2 != null ? actionMetaData2.getActionProperties() : null;
        ActionMetaData actionMetaData3 = currentActionMetaData;
        if (actionMetaData3 != null) {
            ActionProperties actionProperties = currentActionProperties;
            actionMetaData = ActionMetaData.copy$default((ActionMetaData)actionMetaData3, null, null, (int)0, (boolean)false, (int)0, null, actionProperties != null ? ActionProperties.copy$default((ActionProperties)actionProperties, null, null, null, (Boolean)this.hasRollupFailed, null, null, (int)55, null) : null, (int)63, null);
        } else {
            actionMetaData = null;
        }
        ActionMetaData actionMetaData4 = actionMetaData;
        StepMetaData stepMetaData = new StepMetaData(this.getName(), this.getStepStartTime(currentMetadata).toEpochMilli(), this.stepStatus);
        Map<String, ? extends Object> map = this.info;
        return ManagedIndexMetaData.copy$default((ManagedIndexMetaData)currentMetadata, null, null, null, null, null, null, null, null, null, null, (ActionMetaData)actionMetaData4, (StepMetaData)stepMetaData, null, map, null, (long)0L, (long)0L, null, (int)250623, null);
    }

    public boolean isIdempotent() {
        return true;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004J\u0016\u0010\t\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004J\u0016\u0010\n\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004J\u0016\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004J\u000e\u0010\f\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/opensearch/indexmanagement/indexstatemanagement/step/rollup/WaitForRollupCompletionStep$Companion;", "", "()V", "JOB_STOPPED_MESSAGE", "", "name", "getFailedMessage", "rollupJob", "index", "getJobCompletionMessage", "getJobFailedMessage", "getJobProcessingMessage", "getMissingRollupJobMessage", "opensearch-index-management"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getFailedMessage(@NotNull String rollupJob, @NotNull String index2) {
            Intrinsics.checkNotNullParameter((Object)rollupJob, (String)"rollupJob");
            Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
            return "Failed to get the status of rollup job [" + rollupJob + "] [index=" + index2 + "]";
        }

        @NotNull
        public final String getJobProcessingMessage(@NotNull String rollupJob, @NotNull String index2) {
            Intrinsics.checkNotNullParameter((Object)rollupJob, (String)"rollupJob");
            Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
            return "Rollup job [" + rollupJob + "] is still processing [index=" + index2 + "]";
        }

        @NotNull
        public final String getJobCompletionMessage(@NotNull String rollupJob, @NotNull String index2) {
            Intrinsics.checkNotNullParameter((Object)rollupJob, (String)"rollupJob");
            Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
            return "Rollup job [" + rollupJob + "] completed [index=" + index2 + "]";
        }

        @NotNull
        public final String getJobFailedMessage(@NotNull String rollupJob, @NotNull String index2) {
            Intrinsics.checkNotNullParameter((Object)rollupJob, (String)"rollupJob");
            Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
            return "Rollup job [" + rollupJob + "] failed [index=" + index2 + "]";
        }

        @NotNull
        public final String getMissingRollupJobMessage(@NotNull String index2) {
            Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
            return "Rollup job was not found [index=" + index2 + "]";
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RollupMetadata.Status.values().length];
            try {
                nArray[RollupMetadata.Status.INIT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RollupMetadata.Status.STARTED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RollupMetadata.Status.FAILED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RollupMetadata.Status.FINISHED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RollupMetadata.Status.RETRY.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RollupMetadata.Status.STOPPED.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

