/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.codec.derivedsource;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.BytesRef;
import org.opensearch.knn.index.codec.derivedsource.DerivedSourceReaders;
import org.opensearch.knn.index.codec.derivedsource.NestedPerFieldParentToDocIdIterator;
import org.opensearch.knn.index.codec.derivedsource.ParentChildHelper;
import org.opensearch.knn.index.codec.derivedsource.PerFieldDerivedVectorInjector;
import org.opensearch.knn.index.vectorvalues.KNNVectorValues;
import org.opensearch.knn.index.vectorvalues.KNNVectorValuesFactory;

public class NestedPerFieldDerivedVectorInjector
implements PerFieldDerivedVectorInjector {
    @Generated
    private static final Logger log = LogManager.getLogger(NestedPerFieldDerivedVectorInjector.class);
    private final FieldInfo childFieldInfo;
    private final DerivedSourceReaders derivedSourceReaders;
    private final SegmentReadState segmentReadState;

    @Override
    public void inject(int parentDocId, Map<String, Object> sourceAsMap) throws IOException {
        int lowestDocIdForFieldWithParentAsOffset = this.getLowestDocIdForField(this.childFieldInfo.name, parentDocId);
        if (lowestDocIdForFieldWithParentAsOffset == parentDocId) {
            this.injectObject(parentDocId, sourceAsMap);
            return;
        }
        String childFieldName = ParentChildHelper.getChildField(this.childFieldInfo.name);
        String parentFieldName = ParentChildHelper.getParentField(this.childFieldInfo.name);
        if (parentFieldName == null) {
            return;
        }
        NestedPerFieldParentToDocIdIterator nestedPerFieldParentToDocIdIterator = new NestedPerFieldParentToDocIdIterator(this.childFieldInfo, this.segmentReadState, this.derivedSourceReaders, parentDocId);
        if (nestedPerFieldParentToDocIdIterator.numChildren() == 0) {
            return;
        }
        Object originalParentValue = sourceAsMap.get(parentFieldName);
        ArrayList<Map<String, Object>> reconstructedSource = originalParentValue instanceof Map ? new ArrayList<Map<String, Object>>(List.of((Map)originalParentValue)) : (ArrayList<Map<String, Object>>)originalParentValue;
        List<Integer> positions = this.mapObjectsToPositionInNestedList(reconstructedSource, nestedPerFieldParentToDocIdIterator.firstChild(), parentDocId);
        KNNVectorValues vectorValues = KNNVectorValuesFactory.getVectorValues(this.childFieldInfo, this.derivedSourceReaders.getDocValuesProducer(), this.derivedSourceReaders.getKnnVectorsReader());
        int offsetPositionsIndex = 0;
        while (nestedPerFieldParentToDocIdIterator.nextChild() != Integer.MAX_VALUE) {
            if (nestedPerFieldParentToDocIdIterator.childId() > vectorValues.docId()) {
                vectorValues.advance(nestedPerFieldParentToDocIdIterator.childId());
            }
            if (vectorValues.docId() != nestedPerFieldParentToDocIdIterator.childId()) continue;
            int docId = nestedPerFieldParentToDocIdIterator.childId();
            boolean isInsert = true;
            int position = positions.size();
            for (int i = offsetPositionsIndex; i < positions.size(); ++i) {
                if (docId < positions.get(i)) {
                    position = i;
                    break;
                }
                if (docId != positions.get(i)) continue;
                isInsert = false;
                position = i;
                break;
            }
            if (isInsert) {
                reconstructedSource.add(position, new HashMap());
                positions.add(position, docId);
            }
            ((Map)reconstructedSource.get(position)).put(childFieldName, vectorValues.conditionalCloneVector());
            offsetPositionsIndex = position + 1;
        }
        sourceAsMap.put(parentFieldName, reconstructedSource);
    }

    private void injectObject(int docId, Map<String, Object> sourceAsMap) throws IOException {
        KNNVectorValues vectorValues = KNNVectorValuesFactory.getVectorValues(this.childFieldInfo, this.derivedSourceReaders.getDocValuesProducer(), this.derivedSourceReaders.getKnnVectorsReader());
        if (vectorValues.docId() != docId && vectorValues.advance(docId) != docId) {
            return;
        }
        String[] fields = ParentChildHelper.splitPath(this.childFieldInfo.name);
        Map currentMap = sourceAsMap;
        for (int i = 0; i < fields.length - 1; ++i) {
            String field = fields[i];
            currentMap = (Map)currentMap.computeIfAbsent((String)field, k -> new HashMap());
        }
        currentMap.put(fields[fields.length - 1], vectorValues.getVector());
    }

    private List<Integer> mapObjectsToPositionInNestedList(List<Map<String, Object>> originals, int firstChild, int parent) throws IOException {
        ArrayList<Integer> positions = new ArrayList<Integer>();
        int offset = firstChild;
        for (Map<String, Object> docWithFields : originals) {
            int fieldMapping = this.mapToDocId(docWithFields, offset, parent);
            assert (fieldMapping != -1);
            positions.add(fieldMapping);
            offset = fieldMapping + 1;
        }
        return positions;
    }

    private int mapToDocId(Map<String, Object> doc, int offset, int parent) throws IOException {
        String key;
        int position = Integer.MAX_VALUE;
        Iterator<String> iterator = doc.keySet().iterator();
        while (iterator.hasNext() && (position = this.getLowestDocIdForField(ParentChildHelper.constructSiblingField(this.childFieldInfo.name, key = iterator.next()), offset)) >= parent) {
        }
        assert (position < parent);
        return position;
    }

    private int getLowestDocIdForField(String fieldToMatch, int offset) throws IOException {
        FieldInfo fieldInfo = this.segmentReadState.fieldInfos.fieldInfo(fieldToMatch);
        if (fieldInfo == null) {
            return Integer.MAX_VALUE;
        }
        NumericDocValues iterator = null;
        if (fieldInfo.hasNorms() && this.derivedSourceReaders.getNormsProducer() != null) {
            iterator = this.derivedSourceReaders.getNormsProducer().getNorms(fieldInfo);
        } else if (fieldInfo.getVectorDimension() != 0 && this.derivedSourceReaders.getKnnVectorsReader() != null) {
            switch (fieldInfo.getVectorEncoding()) {
                case FLOAT32: {
                    iterator = this.derivedSourceReaders.getKnnVectorsReader().getFloatVectorValues(fieldInfo.name);
                    break;
                }
                case BYTE: {
                    iterator = this.derivedSourceReaders.getKnnVectorsReader().getByteVectorValues(fieldInfo.name);
                }
            }
        } else if (fieldInfo.getDocValuesType() != DocValuesType.NONE && this.derivedSourceReaders.getDocValuesProducer() != null) {
            switch (fieldInfo.getDocValuesType()) {
                case NUMERIC: {
                    iterator = this.derivedSourceReaders.getDocValuesProducer().getNumeric(fieldInfo);
                    break;
                }
                case BINARY: {
                    iterator = this.derivedSourceReaders.getDocValuesProducer().getBinary(fieldInfo);
                    break;
                }
                case SORTED: {
                    iterator = this.derivedSourceReaders.getDocValuesProducer().getSorted(fieldInfo);
                    break;
                }
                case SORTED_NUMERIC: {
                    iterator = this.derivedSourceReaders.getDocValuesProducer().getSortedNumeric(fieldInfo);
                    break;
                }
                case SORTED_SET: {
                    iterator = this.derivedSourceReaders.getDocValuesProducer().getSortedSet(fieldInfo);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
        if (iterator != null) {
            return iterator.advance(offset);
        }
        if (this.derivedSourceReaders.getFieldsProducer() == null) {
            return Integer.MAX_VALUE;
        }
        Terms terms = this.derivedSourceReaders.getFieldsProducer().terms("_field_names");
        if (terms == null) {
            return Integer.MAX_VALUE;
        }
        TermsEnum fieldNameFieldsTerms = terms.iterator();
        BytesRef fieldToMatchRef = new BytesRef((CharSequence)fieldInfo.name);
        PostingsEnum postingsEnum = null;
        while (fieldNameFieldsTerms.next() != null) {
            BytesRef currentTerm = fieldNameFieldsTerms.term();
            if (!currentTerm.bytesEquals(fieldToMatchRef)) continue;
            postingsEnum = fieldNameFieldsTerms.postings(null);
            break;
        }
        if (postingsEnum == null) {
            return Integer.MAX_VALUE;
        }
        return postingsEnum.advance(offset);
    }

    @Generated
    public NestedPerFieldDerivedVectorInjector(FieldInfo childFieldInfo, DerivedSourceReaders derivedSourceReaders, SegmentReadState segmentReadState) {
        this.childFieldInfo = childFieldInfo;
        this.derivedSourceReaders = derivedSourceReaders;
        this.segmentReadState = segmentReadState;
    }
}

