/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.engine.algorithms.remote;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.Logger;
import org.opensearch.ExceptionsHelper;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.bulk.BackoffPolicy;
import org.opensearch.action.support.GroupedActionListener;
import org.opensearch.action.support.RetryableAction;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.collect.Tuple;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.util.TokenBucket;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.ml.common.FunctionName;
import org.opensearch.ml.common.connector.Connector;
import org.opensearch.ml.common.connector.ConnectorAction;
import org.opensearch.ml.common.connector.ConnectorClientConfig;
import org.opensearch.ml.common.connector.MLPreProcessFunction;
import org.opensearch.ml.common.dataset.MLInputDataset;
import org.opensearch.ml.common.dataset.TextDocsInputDataSet;
import org.opensearch.ml.common.dataset.remote.RemoteInferenceInputDataSet;
import org.opensearch.ml.common.input.MLInput;
import org.opensearch.ml.common.model.MLGuard;
import org.opensearch.ml.common.output.MLOutput;
import org.opensearch.ml.common.output.model.ModelTensorOutput;
import org.opensearch.ml.common.output.model.ModelTensors;
import org.opensearch.ml.common.transport.MLTaskResponse;
import org.opensearch.ml.engine.algorithms.remote.ConnectorUtils;
import org.opensearch.ml.engine.algorithms.remote.ExecutionContext;
import org.opensearch.ml.engine.algorithms.remote.RemoteConnectorThrottlingException;
import org.opensearch.script.ScriptService;

public interface RemoteConnectorExecutor {
    public static final String RETRY_EXECUTOR = "opensearch_ml_predict_remote";

    default public void executeAction(String action, MLInput mlInput, ActionListener<MLTaskResponse> actionListener) {
        ActionListener tensorActionListener = ActionListener.wrap(r -> {
            ModelTensors[] modelTensors = new ModelTensors[r.size()];
            r.forEach(sequenceNoAndModelTensor -> {
                modelTensors[((Integer)sequenceNoAndModelTensor.v1()).intValue()] = (ModelTensors)sequenceNoAndModelTensor.v2();
            });
            actionListener.onResponse((Object)new MLTaskResponse((MLOutput)new ModelTensorOutput(Arrays.asList(modelTensors))));
        }, arg_0 -> actionListener.onFailure(arg_0));
        try {
            if (mlInput.getInputDataset() instanceof TextDocsInputDataSet) {
                TextDocsInputDataSet textDocsInputDataSet = (TextDocsInputDataSet)mlInput.getInputDataset();
                Tuple<Integer, Integer> calculatedChunkSize = this.calculateChunkSize(action, textDocsInputDataSet);
                GroupedActionListener groupedActionListener = new GroupedActionListener(tensorActionListener, ((Integer)calculatedChunkSize.v1()).intValue());
                int sequence = 0;
                for (int processedDocs = 0; processedDocs < textDocsInputDataSet.getDocs().size(); processedDocs += ((Integer)calculatedChunkSize.v2()).intValue()) {
                    List textDocs = textDocsInputDataSet.getDocs().subList(processedDocs, Math.min(processedDocs + (Integer)calculatedChunkSize.v2(), textDocsInputDataSet.getDocs().size()));
                    this.preparePayloadAndInvoke(action, MLInput.builder().algorithm(FunctionName.TEXT_EMBEDDING).inputDataset((MLInputDataset)TextDocsInputDataSet.builder().docs(textDocs).build()).build(), new ExecutionContext(sequence++), (ActionListener<Tuple<Integer, ModelTensors>>)groupedActionListener);
                }
            } else {
                this.preparePayloadAndInvoke(action, mlInput, new ExecutionContext(0), (ActionListener<Tuple<Integer, ModelTensors>>)new GroupedActionListener(tensorActionListener, 1));
            }
        }
        catch (Exception e) {
            actionListener.onFailure(e);
        }
    }

    private Tuple<Integer, Integer> calculateChunkSize(String action, TextDocsInputDataSet textDocsInputDataSet) {
        int textDocsLength = textDocsInputDataSet.getDocs().size();
        Map parameters = this.getConnector().getParameters();
        if (parameters != null && parameters.containsKey("input_docs_processed_step_size")) {
            boolean isDivisible;
            int stepSize = Integer.parseInt((String)parameters.get("input_docs_processed_step_size"));
            if (stepSize <= 0) {
                throw new IllegalArgumentException("Invalid parameter: input_docs_processed_step_size. It must be positive integer.");
            }
            boolean bl = isDivisible = textDocsLength % stepSize == 0;
            if (isDivisible) {
                return Tuple.tuple((Object)(textDocsLength / stepSize), (Object)stepSize);
            }
            return Tuple.tuple((Object)(textDocsLength / stepSize + 1), (Object)stepSize);
        }
        Optional connectorAction = this.getConnector().findAction(action);
        if (connectorAction.isEmpty()) {
            throw new IllegalArgumentException("no " + action + " action found");
        }
        String preProcessFunction = ((ConnectorAction)connectorAction.get()).getPreProcessFunction();
        if (preProcessFunction == null) {
            return Tuple.tuple((Object)1, (Object)textDocsLength);
        }
        if ("connector.pre_process.bedrock.embedding".equals(preProcessFunction) || !MLPreProcessFunction.contains((String)preProcessFunction)) {
            return Tuple.tuple((Object)textDocsLength, (Object)1);
        }
        return Tuple.tuple((Object)1, (Object)textDocsLength);
    }

    default public void setScriptService(ScriptService scriptService) {
    }

    public ScriptService getScriptService();

    public Connector getConnector();

    public TokenBucket getRateLimiter();

    public Map<String, TokenBucket> getUserRateLimiterMap();

    public MLGuard getMlGuard();

    public Client getClient();

    public Logger getLogger();

    public ConnectorClientConfig getConnectorClientConfig();

    default public void setClient(Client client) {
    }

    default public void setConnectorPrivateIpEnabled(AtomicBoolean connectorPrivateIpEnabled) {
    }

    default public void setXContentRegistry(NamedXContentRegistry xContentRegistry) {
    }

    default public void setClusterService(ClusterService clusterService) {
    }

    default public void setRateLimiter(TokenBucket rateLimiter) {
    }

    default public void setUserRateLimiterMap(Map<String, TokenBucket> userRateLimiterMap) {
    }

    default public void setMlGuard(MLGuard mlGuard) {
    }

    default public void preparePayloadAndInvoke(String action, MLInput mlInput, ExecutionContext executionContext, ActionListener<Tuple<Integer, ModelTensors>> actionListener) {
        Connector connector = this.getConnector();
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (connector.getParameters() != null) {
            parameters.putAll(connector.getParameters());
        }
        MLInputDataset inputDataset = mlInput.getInputDataset();
        HashMap inputParameters = new HashMap();
        if (inputDataset instanceof RemoteInferenceInputDataSet && ((RemoteInferenceInputDataSet)inputDataset).getParameters() != null) {
            ConnectorUtils.escapeRemoteInferenceInputData((RemoteInferenceInputDataSet)inputDataset);
            inputParameters.putAll(((RemoteInferenceInputDataSet)inputDataset).getParameters());
        }
        parameters.putAll(inputParameters);
        RemoteInferenceInputDataSet inputData = ConnectorUtils.processInput(action, mlInput, connector, parameters, this.getScriptService());
        if (inputData.getParameters() != null) {
            parameters.putAll(inputData.getParameters());
        }
        parameters.putAll(inputParameters);
        String payload = (String)connector.createPayload(action, parameters);
        if (!Boolean.parseBoolean(parameters.getOrDefault("skip_validating_missing_parameters", "false"))) {
            connector.validatePayload(payload);
        }
        String userStr = (String)this.getClient().threadPool().getThreadContext().getTransient("_opendistro_security_user_info");
        User user = User.parse((String)userStr);
        if (this.getRateLimiter() != null && !this.getRateLimiter().request()) {
            this.getLogger().error("Request is throttled at model level.");
            throw new OpenSearchStatusException("Request is throttled at model level.", RestStatus.TOO_MANY_REQUESTS, new Object[0]);
        }
        if (user != null && this.getUserRateLimiterMap() != null && this.getUserRateLimiterMap().get(user.getName()) != null && !this.getUserRateLimiterMap().get(user.getName()).request()) {
            this.getLogger().error("Request is throttled at user level.");
            throw new OpenSearchStatusException("Request is throttled at user level. If you think there's an issue, please contact your cluster admin.", RestStatus.TOO_MANY_REQUESTS, new Object[0]);
        }
        if (this.getMlGuard() != null && !this.getMlGuard().validate(payload, MLGuard.Type.INPUT, parameters).booleanValue()) {
            this.getLogger().error("guardrails triggered for user input");
            throw new IllegalArgumentException("guardrails triggered for user input");
        }
        if (this.getConnectorClientConfig().getMaxRetryTimes() != 0) {
            this.invokeRemoteServiceWithRetry(action, mlInput, parameters, payload, executionContext, actionListener);
        } else {
            this.invokeRemoteService(action, mlInput, parameters, payload, executionContext, actionListener);
        }
    }

    default public BackoffPolicy getRetryBackoffPolicy(ConnectorClientConfig connectorClientConfig) {
        switch (connectorClientConfig.getRetryBackoffPolicy()) {
            case EXPONENTIAL_EQUAL_JITTER: {
                return BackoffPolicy.exponentialEqualJitterBackoff((long)connectorClientConfig.getRetryBackoffMillis().intValue(), (long)(connectorClientConfig.getRetryTimeoutSeconds() * 1000));
            }
            case EXPONENTIAL_FULL_JITTER: {
                return BackoffPolicy.exponentialFullJitterBackoff((long)connectorClientConfig.getRetryBackoffMillis().intValue());
            }
        }
        return BackoffPolicy.constantBackoff((TimeValue)TimeValue.timeValueMillis((long)connectorClientConfig.getRetryBackoffMillis().intValue()), (int)Integer.MAX_VALUE);
    }

    default public void invokeRemoteServiceWithRetry(final String action, final MLInput mlInput, final Map<String, String> parameters, final String payload, final ExecutionContext executionContext, ActionListener<Tuple<Integer, ModelTensors>> actionListener) {
        RetryableAction<Tuple<Integer, ModelTensors>> invokeRemoteModelAction = new RetryableAction<Tuple<Integer, ModelTensors>>(this.getLogger(), this.getClient().threadPool(), TimeValue.timeValueMillis((long)this.getConnectorClientConfig().getRetryBackoffMillis().intValue()), TimeValue.timeValueSeconds((long)this.getConnectorClientConfig().getRetryTimeoutSeconds().intValue()), actionListener, this.getRetryBackoffPolicy(this.getConnectorClientConfig()), RETRY_EXECUTOR){
            int retryTimes;
            {
                super(logger, threadPool, initialDelay, timeoutValue, listener, backoffPolicy, executor);
                this.retryTimes = 0;
            }

            public void tryAction(ActionListener<Tuple<Integer, ModelTensors>> listener) {
                RemoteConnectorExecutor.this.invokeRemoteService(action, mlInput, parameters, payload, executionContext, listener);
            }

            public boolean shouldRetry(Exception e) {
                Throwable cause = ExceptionsHelper.unwrapCause((Throwable)e);
                Integer maxRetryTimes = RemoteConnectorExecutor.this.getConnectorClientConfig().getMaxRetryTimes();
                boolean shouldRetry = cause instanceof RemoteConnectorThrottlingException;
                if (++this.retryTimes > maxRetryTimes && maxRetryTimes != -1) {
                    shouldRetry = false;
                }
                if (shouldRetry) {
                    RemoteConnectorExecutor.this.getLogger().debug(String.format(Locale.ROOT, "The %d-th retry for invoke remote model", this.retryTimes), (Throwable)e);
                }
                return shouldRetry;
            }
        };
        invokeRemoteModelAction.run();
    }

    public void invokeRemoteService(String var1, MLInput var2, Map<String, String> var3, String var4, ExecutionContext var5, ActionListener<Tuple<Integer, ModelTensors>> var6);
}

