/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.rest;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.client.node.NodeClient;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.ml.common.transport.deploy.MLDeployModelAction;
import org.opensearch.ml.common.transport.deploy.MLDeployModelRequest;
import org.opensearch.ml.settings.MLFeatureEnabledSetting;
import org.opensearch.ml.utils.TenantAwareHelper;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestToXContentListener;

public class RestMLDeployModelAction
extends BaseRestHandler {
    private static final String ML_DEPLOY_MODEL_ACTION = "ml_deploy_model_action";
    private final MLFeatureEnabledSetting mlFeatureEnabledSetting;

    public RestMLDeployModelAction(MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
    }

    public String getName() {
        return ML_DEPLOY_MODEL_ACTION;
    }

    public List<RestHandler.ReplacedRoute> replacedRoutes() {
        return ImmutableList.of((Object)new RestHandler.ReplacedRoute(RestRequest.Method.POST, String.format(Locale.ROOT, "%s/models/{%s}/_deploy", "/_plugins/_ml", "model_id"), RestRequest.Method.POST, String.format(Locale.ROOT, "%s/models/{%s}/_load", "/_plugins/_ml", "model_id")));
    }

    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        MLDeployModelRequest MLDeployModelRequest2 = this.getRequest(request);
        return channel -> client.execute((ActionType)MLDeployModelAction.INSTANCE, (ActionRequest)MLDeployModelRequest2, (ActionListener)new RestToXContentListener(channel));
    }

    @VisibleForTesting
    MLDeployModelRequest getRequest(RestRequest request) throws IOException {
        String modelId = request.param("model_id");
        String tenantId = TenantAwareHelper.getTenantID(this.mlFeatureEnabledSetting.isMultiTenancyEnabled(), request);
        if (!request.hasContent()) {
            return new MLDeployModelRequest(modelId, tenantId, false);
        }
        XContentParser parser = request.contentParser();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
        return MLDeployModelRequest.parse((XContentParser)parser, (String)modelId, (String)tenantId);
    }
}

