/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.query.planner.physical.node;

import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.client.Client;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.common.Strings;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.search.SearchHit;
import org.opensearch.sql.legacy.domain.Where;
import org.opensearch.sql.legacy.exception.SqlParseException;
import org.opensearch.sql.legacy.query.join.TableInJoinRequestBuilder;
import org.opensearch.sql.legacy.query.maker.QueryMaker;
import org.opensearch.sql.legacy.query.planner.core.ExecuteParams;
import org.opensearch.sql.legacy.query.planner.core.PlanNode;
import org.opensearch.sql.legacy.query.planner.physical.Row;
import org.opensearch.sql.legacy.query.planner.physical.estimation.Cost;
import org.opensearch.sql.legacy.query.planner.physical.node.BatchPhysicalOperator;
import org.opensearch.sql.legacy.query.planner.physical.node.SearchHitRow;
import org.opensearch.sql.legacy.query.planner.resource.ResourceManager;

public abstract class Paginate
extends BatchPhysicalOperator<SearchHit> {
    protected final TableInJoinRequestBuilder request;
    protected final int pageSize;
    protected Client client;
    protected SearchResponse searchResponse;
    protected Integer timeout;
    protected ResourceManager resourceMgr;

    public Paginate(TableInJoinRequestBuilder request, int pageSize) {
        this.request = request;
        this.pageSize = pageSize;
    }

    @Override
    public PlanNode[] children() {
        return new PlanNode[0];
    }

    @Override
    public Cost estimate() {
        return new Cost();
    }

    @Override
    public void open(ExecuteParams params) throws Exception {
        super.open(params);
        this.client = (Client)params.get(ExecuteParams.ExecuteParamType.CLIENT);
        this.timeout = (Integer)params.get(ExecuteParams.ExecuteParamType.TIMEOUT);
        this.resourceMgr = (ResourceManager)params.get(ExecuteParams.ExecuteParamType.RESOURCE_MANAGER);
        Object filter = params.get(ExecuteParams.ExecuteParamType.EXTRA_QUERY_FILTER);
        if (filter instanceof BoolQueryBuilder) {
            this.request.getRequestBuilder().setQuery(this.generateNewQueryWithExtraFilter((BoolQueryBuilder)filter));
            if (LOG.isDebugEnabled()) {
                LOG.debug("Received extra query filter, re-build query: {}", (Object)Strings.toString((MediaType)XContentType.JSON, (ToXContent)((SearchRequest)this.request.getRequestBuilder().request()).source(), (boolean)true, (boolean)true));
            }
        }
    }

    @Override
    protected Collection<Row<SearchHit>> prefetch() {
        Objects.requireNonNull(this.client, "Client connection is not ready");
        Objects.requireNonNull(this.resourceMgr, "ResourceManager is not set");
        Objects.requireNonNull(this.timeout, "Time out is not set");
        if (this.searchResponse == null) {
            this.loadFirstBatch();
            this.updateMetaResult();
        } else {
            this.loadNextBatch();
        }
        return this.wrapRowForCurrentBatch();
    }

    protected abstract void loadFirstBatch();

    protected abstract void loadNextBatch();

    protected QueryBuilder generateNewQueryWithExtraFilter(BoolQueryBuilder filter) throws SqlParseException {
        BoolQueryBuilder newQuery;
        Where where = this.request.getOriginalSelect().getWhere();
        if (where != null) {
            newQuery = QueryMaker.explain(where, false);
            newQuery.must((QueryBuilder)filter);
        } else {
            newQuery = filter;
        }
        return newQuery;
    }

    protected void updateMetaResult() {
        this.resourceMgr.getMetaResult().addTotalNumOfShards(this.searchResponse.getTotalShards());
        this.resourceMgr.getMetaResult().addSuccessfulShards(this.searchResponse.getSuccessfulShards());
        this.resourceMgr.getMetaResult().addFailedShards(this.searchResponse.getFailedShards());
        this.resourceMgr.getMetaResult().updateTimeOut(this.searchResponse.isTimedOut());
    }

    protected Collection<Row<SearchHit>> wrapRowForCurrentBatch() {
        SearchHit[] hits = this.searchResponse.getHits().getHits();
        Row[] rows = new Row[hits.length];
        for (int i = 0; i < hits.length; ++i) {
            rows[i] = new SearchHitRow(hits[i], this.request.getAlias());
        }
        return Arrays.asList(rows);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [ " + this.describeTable() + ", pageSize=" + this.pageSize + " ]";
    }

    protected String describeTable() {
        return this.request.getOriginalSelect().getFrom().get(0).getIndex() + " as " + this.request.getAlias();
    }

    public String getRequest() {
        return Strings.toString((MediaType)XContentType.JSON, (ToXContent)((SearchRequest)this.request.getRequestBuilder().request()).source());
    }
}

