/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.flowframework.transport;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessageFactory;
import org.opensearch.ExceptionsHelper;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.flowframework.common.FlowFrameworkSettings;
import org.opensearch.flowframework.exception.FlowFrameworkException;
import org.opensearch.flowframework.indices.FlowFrameworkIndicesHandler;
import org.opensearch.flowframework.model.WorkflowState;
import org.opensearch.flowframework.transport.GetWorkflowStateRequest;
import org.opensearch.flowframework.transport.GetWorkflowStateResponse;
import org.opensearch.flowframework.util.ParseUtils;
import org.opensearch.flowframework.util.TenantAwareHelper;
import org.opensearch.remote.metadata.client.SdkClient;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

public class GetWorkflowStateTransportAction
extends HandledTransportAction<GetWorkflowStateRequest, GetWorkflowStateResponse> {
    private final Logger logger = LogManager.getLogger(GetWorkflowStateTransportAction.class);
    private final FlowFrameworkIndicesHandler flowFrameworkIndicesHandler;
    private final FlowFrameworkSettings flowFrameworkSettings;
    private final Client client;
    private final SdkClient sdkClient;
    private final NamedXContentRegistry xContentRegistry;
    private volatile Boolean filterByEnabled;
    private final ClusterService clusterService;

    @Inject
    public GetWorkflowStateTransportAction(TransportService transportService, ActionFilters actionFilters, FlowFrameworkIndicesHandler flowFrameworkIndicesHandler, FlowFrameworkSettings flowFrameworkSettings, Client client, SdkClient sdkClient, NamedXContentRegistry xContentRegistry, ClusterService clusterService, Settings settings) {
        super("cluster:admin/opensearch/flow_framework/workflow_state/get", transportService, actionFilters, GetWorkflowStateRequest::new);
        this.flowFrameworkIndicesHandler = flowFrameworkIndicesHandler;
        this.flowFrameworkSettings = flowFrameworkSettings;
        this.client = client;
        this.sdkClient = sdkClient;
        this.xContentRegistry = xContentRegistry;
        this.filterByEnabled = (Boolean)FlowFrameworkSettings.FILTER_BY_BACKEND_ROLES.get(settings);
        this.clusterService = clusterService;
        clusterService.getClusterSettings().addSettingsUpdateConsumer(FlowFrameworkSettings.FILTER_BY_BACKEND_ROLES, it -> {
            this.filterByEnabled = it;
        });
    }

    protected void doExecute(Task task, GetWorkflowStateRequest request, ActionListener<GetWorkflowStateResponse> listener) {
        String tenantId = request.getTenantId();
        if (!TenantAwareHelper.validateTenantId(this.flowFrameworkSettings.isMultiTenancyEnabled(), tenantId, listener)) {
            return;
        }
        String workflowId = request.getWorkflowId();
        User user = ParseUtils.getUserContext(this.client);
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            ParseUtils.resolveUserAndExecute(user, workflowId, tenantId, this.filterByEnabled, true, this.flowFrameworkSettings.isMultiTenancyEnabled(), listener, () -> this.executeGetWorkflowStateRequest(request, tenantId, listener, context), this.client, this.sdkClient, this.clusterService, this.xContentRegistry);
        }
        catch (Exception e) {
            String errorMessage = ParameterizedMessageFactory.INSTANCE.newMessage("Failed to get workflow: {}", (Object)workflowId).getFormattedMessage();
            this.logger.error(errorMessage, (Throwable)e);
            listener.onFailure((Exception)((Object)new FlowFrameworkException(errorMessage, ExceptionsHelper.status((Throwable)e))));
        }
    }

    private void executeGetWorkflowStateRequest(GetWorkflowStateRequest request, String tenantId, ActionListener<GetWorkflowStateResponse> listener, ThreadContext.StoredContext context) {
        String workflowId = request.getWorkflowId();
        this.flowFrameworkIndicesHandler.getWorkflowState(workflowId, tenantId, (ActionListener<WorkflowState>)ActionListener.wrap(workflowState -> {
            GetWorkflowStateResponse workflowStateResponse = new GetWorkflowStateResponse((WorkflowState)workflowState, request.getAll());
            listener.onResponse((Object)workflowStateResponse);
        }, arg_0 -> listener.onFailure(arg_0)), context);
    }
}

