/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.afp.modca;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.fop.render.afp.modca.AbstractNamedAFPObject;
import org.apache.fop.render.afp.modca.InvokeMediumMap;
import org.apache.fop.render.afp.modca.PageObject;
import org.apache.fop.render.afp.modca.TagLogicalElement;

public class PageGroup
extends AbstractNamedAFPObject {
    private List _objects = new ArrayList();
    private List _tagLogicalElements = new ArrayList();
    private boolean _complete = false;

    public PageGroup(String name) {
        super(name);
    }

    public void addPage(PageObject page) {
        if (!this._objects.contains(page)) {
            this._objects.add(page);
        }
    }

    public String getName() {
        return this._name;
    }

    public void createTagLogicalElement(String name, String value) {
        TagLogicalElement tle = new TagLogicalElement(name, value);
        this._tagLogicalElements.add(tle);
    }

    public void createInvokeMediumMap(String name) {
        InvokeMediumMap imm = new InvokeMediumMap(name);
        this._objects.add(imm);
    }

    public void endPageGroup() {
        this._complete = true;
    }

    public boolean isComplete() {
        return this._complete;
    }

    public void writeDataStream(OutputStream os) throws IOException {
        this.writeStart(os);
        this.writeObjectList(this._tagLogicalElements, os);
        this.writeObjectList(this._objects, os);
        this.writeEnd(os);
    }

    private void writeStart(OutputStream os) throws IOException {
        byte[] data = new byte[17];
        data[0] = 90;
        data[1] = 0;
        data[2] = 16;
        data[3] = -45;
        data[4] = -88;
        data[5] = -83;
        data[6] = 0;
        data[7] = 0;
        data[8] = 0;
        for (int i = 0; i < this._nameBytes.length; ++i) {
            data[9 + i] = this._nameBytes[i];
        }
        os.write(data);
    }

    private void writeEnd(OutputStream os) throws IOException {
        byte[] data = new byte[17];
        data[0] = 90;
        data[1] = 0;
        data[2] = 16;
        data[3] = -45;
        data[4] = -87;
        data[5] = -83;
        data[6] = 0;
        data[7] = 0;
        data[8] = 0;
        for (int i = 0; i < this._nameBytes.length; ++i) {
            data[9 + i] = this._nameBytes[i];
        }
        os.write(data);
    }
}

