/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.tabcontrol.plaf;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import javax.swing.Icon;
import javax.swing.UIManager;
import org.openide.util.ImageUtilities;

abstract class BusyIcon
implements Icon {
    protected final int width;
    protected final int height;

    protected BusyIcon(int n, int n2) {
        this.width = n;
        this.height = n2;
    }

    public static BusyIcon create(boolean bl) {
        Icon icon = UIManager.getIcon("nb.tabcontrol.busy.icon." + (bl ? "selected" : "normal"));
        if (null != icon) {
            return new ImageBusyIcon(ImageUtilities.icon2Image((Icon)icon));
        }
        return VectorBusyIcon.create();
    }

    abstract void tick();

    @Override
    public final int getIconWidth() {
        return this.width;
    }

    @Override
    public final int getIconHeight() {
        return this.height;
    }

    private static int getBusyIconSize() {
        int n = UIManager.getInt("Nb.BusyIcon.Height");
        if (n < 1) {
            n = 16;
        }
        return n;
    }

    private static class VectorBusyIcon
    extends BusyIcon {
        private static final float MIN_ALPHA = 0.16f;
        private static final float MAX_ALPHA = 0.89f;
        private static final int ARMS = 12;
        private static final float STROKE_WIDTH = 1.25f;
        private static final double INNER_RADIUS = 4.0;
        private static final double OUTER_RADIUS = 7.0;
        private int darkestArm = 0;

        private VectorBusyIcon(int n) {
            super(n, n);
        }

        public static BusyIcon create() {
            return new VectorBusyIcon(BusyIcon.getBusyIconSize());
        }

        @Override
        void tick() {
            this.darkestArm = (this.darkestArm + 1) % 12;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            try {
                graphics2D.translate(n, n2);
                this.paintHelper(graphics2D);
            }
            finally {
                graphics2D.dispose();
            }
        }

        private void paintHelper(Graphics2D graphics2D) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
            graphics2D.setStroke(new BasicStroke(1.25f, 1, 1));
            graphics2D.translate((double)this.getIconWidth() / 2.0, (double)this.getIconHeight() / 2.0);
            for (int i = 0; i < 12; ++i) {
                graphics2D.setColor(new Color(0.0f, 0.0f, 0.0f, 0.16f + 0.73f * (float)Math.pow((float)((this.darkestArm + i) % 12) / 11.0f, 3.0)));
                double d = -0.5235987755982988 * (double)i;
                double d2 = Math.sin(d);
                double d3 = Math.cos(d);
                graphics2D.draw(new Line2D.Double(4.0 * d3, 4.0 * d2, 7.0 * d3, 7.0 * d2));
            }
        }
    }

    private static class ImageBusyIcon
    extends BusyIcon {
        private final Image img;
        private int state = 0;
        private AffineTransform at;
        private static final int STEP = 15;

        public ImageBusyIcon(Image image) {
            super(image.getWidth(null), image.getHeight(null));
            this.img = image;
        }

        @Override
        void tick() {
            this.state += 15;
            if (this.state >= 360) {
                this.state = 0;
            }
            this.at = new AffineTransform();
            this.at.rotate((double)this.state * Math.PI / 180.0, this.width / 2, this.height / 2);
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            if (graphics instanceof Graphics2D) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                graphics2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
                graphics2D.translate(n, n2);
                graphics2D.drawImage(this.img, this.at, null);
                graphics2D.translate(-n, -n2);
            }
        }
    }
}

