/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.patterns;

import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.ObjectPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.util.ProcessingContext;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.patterns.GroovyExpressionPattern;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J/\u0010\u0005\u001a\u00020\u00002\"\u0010\u0006\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\b\u0001\u0012\u00020\t0\b0\u0007\"\n\u0012\u0006\b\u0001\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u000b\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010\u000b\u001a\u00020\u00002\u000e\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\bJ\u0016\u0010\u000e\u001a\u00020\u00002\u000e\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\bJ\u0016\u0010\u0011\u001a\u00020\u00002\u000e\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\b\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/plugins/groovy/lang/psi/patterns/GroovyMethodCallPattern;", "Lorg/jetbrains/plugins/groovy/lang/psi/patterns/GroovyExpressionPattern;", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/path/GrCallExpression;", "<init>", "()V", "withArguments", "arguments", "", "Lcom/intellij/patterns/ElementPattern;", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrExpression;", "([Lcom/intellij/patterns/ElementPattern;)Lorg/jetbrains/plugins/groovy/lang/psi/patterns/GroovyMethodCallPattern;", "withMethodName", "methodName", "", "withMethod", "methodPattern", "Lcom/intellij/psi/PsiMethod;", "resolvesTo", "intellij.groovy.psi"})
public final class GroovyMethodCallPattern
extends GroovyExpressionPattern<GrCallExpression, GroovyMethodCallPattern> {
    @NotNull
    public static final GroovyMethodCallPattern INSTANCE = new GroovyMethodCallPattern();

    private GroovyMethodCallPattern() {
        super(GrCallExpression.class);
    }

    @NotNull
    public final GroovyMethodCallPattern withArguments(ElementPattern<? extends GrExpression> ... arguments2) {
        Intrinsics.checkNotNullParameter(arguments2, (String)"arguments");
        ObjectPattern objectPattern = this.with((PatternCondition)new PatternCondition<GrCallExpression>(arguments2){
            final /* synthetic */ ElementPattern<? extends GrExpression>[] $arguments;
            {
                this.$arguments = $arguments;
                super("withArguments");
            }

            public boolean accepts(GrCallExpression callExpression, ProcessingContext context) {
                Intrinsics.checkNotNullParameter((Object)callExpression, (String)"callExpression");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                GrArgumentList grArgumentList = callExpression.getArgumentList();
                if (grArgumentList == null) {
                    return false;
                }
                GrArgumentList argumentList = grArgumentList;
                Object[] objectArray = argumentList.getExpressionArguments();
                Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getExpressionArguments(...)");
                Object[] actualArguments = objectArray;
                if (this.$arguments.length != actualArguments.length) {
                    return false;
                }
                for (Pair pair : ArraysKt.zip((Object[])actualArguments, (Object[])this.$arguments)) {
                    GrExpression argument = (GrExpression)pair.component1();
                    ElementPattern argumentPattern = (ElementPattern)pair.component2();
                    if (argumentPattern.accepts((Object)argument, context)) continue;
                    return false;
                }
                return true;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)objectPattern, (String)"with(...)");
        return (GroovyMethodCallPattern)objectPattern;
    }

    @NotNull
    public final GroovyMethodCallPattern withMethodName(@NotNull String methodName) {
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        ObjectPattern objectPattern = StandardPatterns.string().equalTo((Object)methodName);
        Intrinsics.checkNotNullExpressionValue((Object)objectPattern, (String)"equalTo(...)");
        return this.withMethodName((ElementPattern<? extends String>)((ElementPattern)objectPattern));
    }

    @NotNull
    public final GroovyMethodCallPattern withMethodName(@NotNull ElementPattern<? extends String> methodName) {
        Intrinsics.checkNotNullParameter(methodName, (String)"methodName");
        ObjectPattern objectPattern = this.with((PatternCondition)new PatternCondition<GrCallExpression>(methodName){
            final /* synthetic */ ElementPattern<? extends String> $methodName;
            {
                this.$methodName = $methodName;
                super("withMethodName");
            }

            public boolean accepts(GrCallExpression callExpression, ProcessingContext context) {
                Intrinsics.checkNotNullParameter((Object)callExpression, (String)"callExpression");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                if (!(callExpression instanceof GrMethodCall)) {
                    return false;
                }
                GrExpression grExpression = ((GrMethodCall)callExpression).getInvokedExpression();
                GrReferenceExpression grReferenceExpression = grExpression instanceof GrReferenceExpression ? (GrReferenceExpression)grExpression : null;
                if (grReferenceExpression == null) {
                    return false;
                }
                GrReferenceExpression expression = grReferenceExpression;
                return this.$methodName.accepts((Object)expression.getReferenceName(), context);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)objectPattern, (String)"with(...)");
        return (GroovyMethodCallPattern)objectPattern;
    }

    @NotNull
    public final GroovyMethodCallPattern withMethod(@NotNull ElementPattern<? extends PsiMethod> methodPattern) {
        Intrinsics.checkNotNullParameter(methodPattern, (String)"methodPattern");
        ObjectPattern objectPattern = this.with((PatternCondition)new PatternCondition<GrCallExpression>(methodPattern){
            final /* synthetic */ ElementPattern<? extends PsiMethod> $methodPattern;
            {
                this.$methodPattern = $methodPattern;
                super("methodCall");
            }

            public boolean accepts(GrCallExpression callExpression, ProcessingContext context) {
                Intrinsics.checkNotNullParameter((Object)callExpression, (String)"callExpression");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                for (GroovyResolveResult result2 : callExpression.getCallVariants(null, false)) {
                    if (!this.$methodPattern.accepts((Object)result2.getElement(), context)) continue;
                    return true;
                }
                return false;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)objectPattern, (String)"with(...)");
        return (GroovyMethodCallPattern)objectPattern;
    }

    @NotNull
    public final GroovyMethodCallPattern resolvesTo(@NotNull ElementPattern<? extends PsiMethod> methodPattern) {
        Intrinsics.checkNotNullParameter(methodPattern, (String)"methodPattern");
        ObjectPattern objectPattern = this.with((PatternCondition)new PatternCondition<GrCallExpression>(methodPattern){
            final /* synthetic */ ElementPattern<? extends PsiMethod> $methodPattern;
            {
                this.$methodPattern = $methodPattern;
                super("resolvesTo");
            }

            public boolean accepts(GrCallExpression t, ProcessingContext context) {
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                PsiElement psiElement = t.advancedResolve().getElement();
                PsiMethod psiMethod = psiElement instanceof PsiMethod ? (PsiMethod)psiElement : null;
                if (psiMethod == null) {
                    return false;
                }
                PsiMethod result2 = psiMethod;
                return this.$methodPattern.accepts((Object)result2, context);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)objectPattern, (String)"with(...)");
        return (GroovyMethodCallPattern)objectPattern;
    }

    @NotNull
    public Object clone() {
        return super.clone();
    }
}

