/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.maven.model.impl;

import com.dynatrace.hash4j.hashing.HashFunnel;
import com.dynatrace.hash4j.hashing.HashSink;
import com.dynatrace.hash4j.hashing.Hashing;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import com.intellij.util.xmlb.annotations.OptionTag;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.XCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.maven.model.impl.MavenIdBean;
import org.jetbrains.jps.maven.model.impl.MavenProjectConfiguration;
import org.jetbrains.jps.maven.model.impl.ResourceRootConfiguration;

@ApiStatus.Internal
public final class MavenModuleResourceConfiguration {
    @Tag(value="id")
    @NotNull
    public MavenIdBean id;
    @Tag(value="parentId")
    @Nullable
    public MavenIdBean parentId;
    @Tag(value="directory")
    @NotNull
    public String directory;
    @Tag(value="manifest")
    @Nullable
    public String manifest;
    @Tag(value="classpath")
    @Nullable
    public String classpath;
    @Tag(value="delimiters-pattern")
    @NotNull
    public String delimitersPattern;
    @Tag(value="model-map")
    @MapAnnotation(surroundWithTag=false, surroundKeyWithTag=false, surroundValueWithTag=false)
    public Map<String, String> modelMap = new HashMap<String, String>();
    @Tag(value="properties")
    @MapAnnotation(surroundWithTag=false, surroundKeyWithTag=false, surroundValueWithTag=false)
    public Map<String, String> properties = new HashMap<String, String>();
    @XCollection(propertyElementName="filtering-excluded-extensions", elementName="extension")
    public Set<String> filteringExclusions = CollectionFactory.createFilePathSet();
    @OptionTag
    public String escapeString = null;
    @OptionTag
    public boolean escapeWindowsPaths = true;
    @OptionTag
    public boolean overwrite;
    @OptionTag
    public String outputDirectory = null;
    @OptionTag
    public String testOutputDirectory = null;
    @XCollection(propertyElementName="resources", elementName="resource")
    public List<ResourceRootConfiguration> resources = new ArrayList<ResourceRootConfiguration>();
    @XCollection(propertyElementName="test-resources", elementName="resource")
    public List<ResourceRootConfiguration> testResources = new ArrayList<ResourceRootConfiguration>();

    public Set<String> getFilteringExcludedExtensions() {
        if (this.filteringExclusions.isEmpty()) {
            return MavenProjectConfiguration.DEFAULT_FILTERING_EXCLUDED_EXTENSIONS;
        }
        Set result = CollectionFactory.createFilePathSet();
        result.addAll(MavenProjectConfiguration.DEFAULT_FILTERING_EXCLUDED_EXTENSIONS);
        result.addAll(this.filteringExclusions);
        return Collections.unmodifiableSet(result);
    }

    public void computeConfigurationHash(boolean forTestResources, @NotNull HashSink hash) {
        if (hash == null) {
            MavenModuleResourceConfiguration.$$$reportNull$$$0(0);
        }
        this.computeModuleConfigurationHash(hash);
        List<ResourceRootConfiguration> _resources = forTestResources ? this.testResources : this.resources;
        for (ResourceRootConfiguration resource : _resources) {
            resource.computeConfigurationHash(hash);
        }
        hash.putInt(_resources.size());
    }

    public void computeModuleConfigurationHash(@NotNull HashSink hash) {
        if (hash == null) {
            MavenModuleResourceConfiguration.$$$reportNull$$$0(1);
        }
        hash.putInt(this.parentId == null ? 0 : this.parentId.hashCode());
        hash.putString(this.directory);
        MavenModuleResourceConfiguration.hashNullableString(this.manifest, hash);
        MavenModuleResourceConfiguration.hashNullableString(this.classpath, hash);
        hash.putString(this.delimitersPattern);
        hash.putUnorderedIterable(this.filteringExclusions, HashFunnel.forString(), Hashing.komihash5_0());
        MavenModuleResourceConfiguration.hashNullableString(this.escapeString, hash);
        MavenModuleResourceConfiguration.hashNullableString(this.outputDirectory, hash);
        MavenModuleResourceConfiguration.hashNullableString(this.testOutputDirectory, hash);
        HashFunnel entryHashFunnel = HashFunnel.forEntry((HashFunnel)HashFunnel.forString(), (HashFunnel)HashFunnel.forString());
        hash.putUnorderedIterable(this.modelMap.entrySet(), entryHashFunnel, Hashing.komihash5_0());
        hash.putUnorderedIterable(this.properties.entrySet(), entryHashFunnel, Hashing.komihash5_0());
        hash.putBoolean(this.escapeWindowsPaths);
        hash.putBoolean(this.overwrite);
    }

    private static void hashNullableString(@Nullable String s, @NotNull HashSink hash) {
        if (hash == null) {
            MavenModuleResourceConfiguration.$$$reportNull$$$0(2);
        }
        if (s == null) {
            hash.putInt(-1);
        } else {
            hash.putString(s);
        }
    }

    public String toString() {
        return "MavenModuleResourceConfiguration{id=" + this.id + ", parentId=" + this.parentId + ", directory='" + this.directory + "', manifest='" + this.manifest + "', classpath='" + this.classpath + "', delimitersPattern='" + this.delimitersPattern + "', modelMap=" + this.modelMap + ", properties=" + this.properties + ", filteringExclusions=" + this.filteringExclusions + ", escapeString='" + this.escapeString + "', escapeWindowsPaths=" + this.escapeWindowsPaths + ", overwrite=" + this.overwrite + ", outputDirectory='" + this.outputDirectory + "', testOutputDirectory='" + this.testOutputDirectory + "', resources=" + this.resources + ", testResources=" + this.testResources + "}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "hash";
        objectArray2[1] = "org/jetbrains/jps/maven/model/impl/MavenModuleResourceConfiguration";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "computeConfigurationHash";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "computeModuleConfigurationHash";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "hashNullableString";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

