/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.AbstractObjectCollection;
import com.carrotsearch.hppc.ObjectCollection;
import com.carrotsearch.hppc.ObjectContainer;
import com.carrotsearch.hppc.ObjectLookupContainer;
import com.carrotsearch.hppc.ObjectObjectAssociativeContainer;
import com.carrotsearch.hppc.ObjectObjectHashMap;
import com.carrotsearch.hppc.ObjectObjectMap;
import com.carrotsearch.hppc.comparators.ObjectObjectComparator;
import com.carrotsearch.hppc.cursors.ObjectCursor;
import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import com.carrotsearch.hppc.predicates.ObjectObjectPredicate;
import com.carrotsearch.hppc.predicates.ObjectPredicate;
import com.carrotsearch.hppc.procedures.ObjectObjectProcedure;
import com.carrotsearch.hppc.procedures.ObjectProcedure;
import com.carrotsearch.hppc.sorting.QuickSort;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.IntBinaryOperator;

public class SortedIterationObjectObjectHashMap<KType, VType>
implements ObjectObjectMap<KType, VType> {
    public final ObjectObjectHashMap<KType, VType> delegate;
    public final int[] iterationOrder;

    public SortedIterationObjectObjectHashMap(ObjectObjectHashMap<KType, VType> delegate2, Comparator<KType> comparator) {
        this.delegate = delegate2;
        this.iterationOrder = this.sortIterationOrder(this.createEntryIndexes(), comparator);
    }

    public SortedIterationObjectObjectHashMap(ObjectObjectHashMap<KType, VType> delegate2, ObjectObjectComparator<KType, VType> comparator) {
        this.delegate = delegate2;
        this.iterationOrder = this.sortIterationOrder(this.createEntryIndexes(), comparator);
    }

    private int[] createEntryIndexes() {
        Object[] keys = this.delegate.keys;
        int size = this.delegate.size();
        int[] entryIndexes = new int[size];
        int entry2 = 0;
        if (this.delegate.hasEmptyKey) {
            entryIndexes[entry2++] = this.delegate.mask + 1;
        }
        int keyIndex = 0;
        while (entry2 < size) {
            if (keys[keyIndex] != null) {
                entryIndexes[entry2++] = keyIndex;
            }
            ++keyIndex;
        }
        return entryIndexes;
    }

    protected int[] sortIterationOrder(int[] entryIndexes, Comparator<KType> comparator) {
        QuickSort.sort(entryIndexes, (i, j) -> {
            Object[] keys = this.delegate.keys;
            return comparator.compare(keys[entryIndexes[i]], keys[entryIndexes[j]]);
        });
        return entryIndexes;
    }

    protected int[] sortIterationOrder(final int[] entryIndexes, final ObjectObjectComparator<KType, VType> comparator) {
        QuickSort.sort(entryIndexes, new IntBinaryOperator(){
            final KType[] keys;
            final VType[] values;
            {
                this.keys = SortedIterationObjectObjectHashMap.this.delegate.keys;
                this.values = SortedIterationObjectObjectHashMap.this.delegate.values;
            }

            @Override
            public int applyAsInt(int i, int j) {
                int index1 = entryIndexes[i];
                int index2 = entryIndexes[j];
                return comparator.compare(this.keys[index1], this.values[index1], this.keys[index2], this.values[index2]);
            }
        });
        return entryIndexes;
    }

    @Override
    public Iterator<ObjectObjectCursor<KType, VType>> iterator() {
        assert (this.checkUnmodified());
        return new EntryIterator();
    }

    @Override
    public boolean containsKey(KType key2) {
        return this.delegate.containsKey(key2);
    }

    @Override
    public int size() {
        assert (this.checkUnmodified());
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public int removeAll(ObjectContainer<? super KType> container) {
        throw SortedIterationObjectObjectHashMap.readOnlyException();
    }

    @Override
    public int removeAll(ObjectPredicate<? super KType> predicate) {
        throw SortedIterationObjectObjectHashMap.readOnlyException();
    }

    @Override
    public int removeAll(ObjectObjectPredicate<? super KType, ? super VType> predicate) {
        throw SortedIterationObjectObjectHashMap.readOnlyException();
    }

    @Override
    public <T extends ObjectObjectProcedure<? super KType, ? super VType>> T forEach(T procedure) {
        assert (this.checkUnmodified());
        int[] iterationOrder = this.iterationOrder;
        Object[] keys = this.delegate.keys;
        Object[] values = this.delegate.values;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            int slot = iterationOrder[i];
            procedure.apply((Object)keys[slot], (Object)values[slot]);
        }
        return procedure;
    }

    @Override
    public <T extends ObjectObjectPredicate<? super KType, ? super VType>> T forEach(T predicate) {
        int slot;
        assert (this.checkUnmodified());
        int[] iterationOrder = this.iterationOrder;
        Object[] keys = this.delegate.keys;
        Object[] values = this.delegate.values;
        int size = this.size();
        for (int i = 0; i < size && predicate.apply((Object)keys[slot = iterationOrder[i]], (Object)values[slot]); ++i) {
        }
        return predicate;
    }

    @Override
    public ObjectCollection<KType> keys() {
        assert (this.checkUnmodified());
        return new KeysContainer();
    }

    @Override
    public ObjectContainer<VType> values() {
        assert (this.checkUnmodified());
        return new ValuesContainer();
    }

    @Override
    public VType get(KType key2) {
        return this.delegate.get(key2);
    }

    @Override
    public VType getOrDefault(KType key2, VType defaultValue) {
        return this.delegate.getOrDefault(key2, defaultValue);
    }

    @Override
    public VType put(KType key2, VType value) {
        throw SortedIterationObjectObjectHashMap.readOnlyException();
    }

    @Override
    public int putAll(ObjectObjectAssociativeContainer<? extends KType, ? extends VType> container) {
        throw SortedIterationObjectObjectHashMap.readOnlyException();
    }

    @Override
    public int putAll(Iterable<? extends ObjectObjectCursor<? extends KType, ? extends VType>> iterable) {
        throw SortedIterationObjectObjectHashMap.readOnlyException();
    }

    @Override
    public VType remove(KType key2) {
        throw SortedIterationObjectObjectHashMap.readOnlyException();
    }

    @Override
    public int indexOf(KType key2) {
        return this.delegate.indexOf(key2);
    }

    @Override
    public boolean indexExists(int index) {
        return this.delegate.indexExists(index);
    }

    @Override
    public VType indexGet(int index) {
        return this.delegate.indexGet(index);
    }

    @Override
    public VType indexReplace(int index, VType newValue) {
        throw SortedIterationObjectObjectHashMap.readOnlyException();
    }

    @Override
    public void indexInsert(int index, KType key2, VType value) {
        throw SortedIterationObjectObjectHashMap.readOnlyException();
    }

    @Override
    public VType indexRemove(int index) {
        throw SortedIterationObjectObjectHashMap.readOnlyException();
    }

    @Override
    public void clear() {
        throw SortedIterationObjectObjectHashMap.readOnlyException();
    }

    @Override
    public void release() {
        throw SortedIterationObjectObjectHashMap.readOnlyException();
    }

    @Override
    public String visualizeKeyDistribution(int characters) {
        return this.delegate.visualizeKeyDistribution(characters);
    }

    private static RuntimeException readOnlyException() {
        throw new UnsupportedOperationException("Read-only view cannot be modified");
    }

    private boolean checkUnmodified() {
        assert (this.delegate.size() == this.iterationOrder.length) : "The delegate map changed; this is not supported by this read-only view";
        return true;
    }

    private final class EntryIterator
    extends AbstractIterator<ObjectObjectCursor<KType, VType>> {
        private final ObjectObjectCursor<KType, VType> cursor = new ObjectObjectCursor();
        private int index;

        private EntryIterator() {
        }

        @Override
        protected ObjectObjectCursor<KType, VType> fetch() {
            if (this.index < SortedIterationObjectObjectHashMap.this.iterationOrder.length) {
                int slot;
                this.cursor.index = slot = SortedIterationObjectObjectHashMap.this.iterationOrder[this.index++];
                this.cursor.key = SortedIterationObjectObjectHashMap.this.delegate.keys[slot];
                this.cursor.value = SortedIterationObjectObjectHashMap.this.delegate.values[slot];
                return this.cursor;
            }
            return (ObjectObjectCursor)this.done();
        }
    }

    private final class KeysContainer
    extends AbstractObjectCollection<KType>
    implements ObjectLookupContainer<KType> {
        private final SortedIterationObjectObjectHashMap<KType, VType> owner;

        private KeysContainer() {
            this.owner = SortedIterationObjectObjectHashMap.this;
        }

        @Override
        public boolean contains(KType e) {
            return this.owner.containsKey(e);
        }

        @Override
        public <T extends ObjectProcedure<? super KType>> T forEach(T procedure) {
            this.owner.forEach((k, v) -> procedure.apply(k));
            return procedure;
        }

        @Override
        public <T extends ObjectPredicate<? super KType>> T forEach(T predicate) {
            this.owner.forEach((key2, value) -> predicate.apply(key2));
            return predicate;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<ObjectCursor<KType>> iterator() {
            return new KeysIterator();
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public void clear() {
            throw SortedIterationObjectObjectHashMap.readOnlyException();
        }

        @Override
        public void release() {
            throw SortedIterationObjectObjectHashMap.readOnlyException();
        }

        @Override
        public int removeAll(ObjectPredicate<? super KType> predicate) {
            throw SortedIterationObjectObjectHashMap.readOnlyException();
        }

        @Override
        public int removeAll(KType e) {
            throw SortedIterationObjectObjectHashMap.readOnlyException();
        }
    }

    private final class ValuesContainer
    extends AbstractObjectCollection<VType> {
        private final SortedIterationObjectObjectHashMap<KType, VType> owner;

        private ValuesContainer() {
            this.owner = SortedIterationObjectObjectHashMap.this;
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public boolean contains(VType value) {
            for (ObjectObjectCursor c : this.owner) {
                if (!Objects.equals(value, c.value)) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends ObjectProcedure<? super VType>> T forEach(T procedure) {
            this.owner.forEach((k, v) -> procedure.apply(v));
            return procedure;
        }

        @Override
        public <T extends ObjectPredicate<? super VType>> T forEach(T predicate) {
            this.owner.forEach((k, v) -> predicate.apply(v));
            return predicate;
        }

        @Override
        public Iterator<ObjectCursor<VType>> iterator() {
            return new ValuesIterator();
        }

        @Override
        public int removeAll(VType e) {
            throw SortedIterationObjectObjectHashMap.readOnlyException();
        }

        @Override
        public int removeAll(ObjectPredicate<? super VType> predicate) {
            throw SortedIterationObjectObjectHashMap.readOnlyException();
        }

        @Override
        public void clear() {
            throw SortedIterationObjectObjectHashMap.readOnlyException();
        }

        @Override
        public void release() {
            throw SortedIterationObjectObjectHashMap.readOnlyException();
        }
    }

    private final class ValuesIterator
    extends AbstractIterator<ObjectCursor<VType>> {
        private final ObjectCursor<VType> cursor = new ObjectCursor();
        private int index;

        private ValuesIterator() {
        }

        @Override
        protected ObjectCursor<VType> fetch() {
            if (this.index < SortedIterationObjectObjectHashMap.this.iterationOrder.length) {
                int slot;
                this.cursor.index = slot = SortedIterationObjectObjectHashMap.this.iterationOrder[this.index++];
                this.cursor.value = SortedIterationObjectObjectHashMap.this.delegate.values[slot];
                return this.cursor;
            }
            return (ObjectCursor)this.done();
        }
    }

    private final class KeysIterator
    extends AbstractIterator<ObjectCursor<KType>> {
        private final ObjectCursor<KType> cursor = new ObjectCursor();
        private int index;

        private KeysIterator() {
        }

        @Override
        protected ObjectCursor<KType> fetch() {
            if (this.index < SortedIterationObjectObjectHashMap.this.iterationOrder.length) {
                int slot;
                this.cursor.index = slot = SortedIterationObjectObjectHashMap.this.iterationOrder[this.index++];
                this.cursor.value = SortedIterationObjectObjectHashMap.this.delegate.keys[slot];
                return this.cursor;
            }
            return (ObjectCursor)this.done();
        }
    }
}

