/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.grazie.dictionary;

import ai.grazie.spell.lists.WordList;
import com.intellij.spellchecker.dictionary.Dictionary;
import com.intellij.spellchecker.grazie.dictionary.EditableAggregatedWordList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b \u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0007J\u0016\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u0006J\u000e\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0006J\u0006\u0010\u001c\u001a\u00020\u0013R \u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001d"}, d2={"Lcom/intellij/spellchecker/grazie/dictionary/EditableWordListAdapter;", "", "<init>", "()V", "dictionaries", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/intellij/spellchecker/dictionary/Dictionary;", "getDictionaries", "()Ljava/util/concurrent/ConcurrentHashMap;", "aggregator", "Lcom/intellij/spellchecker/grazie/dictionary/EditableAggregatedWordList;", "getAggregator", "()Lcom/intellij/spellchecker/grazie/dictionary/EditableAggregatedWordList;", "names", "", "getNames", "()Ljava/util/Set;", "addDictionary", "", "dictionary", "addList", "name", "list", "Lai/grazie/spell/lists/WordList;", "containsSource", "", "removeSource", "reset", "intellij.spellchecker"})
public abstract class EditableWordListAdapter {
    @NotNull
    private final ConcurrentHashMap<String, Dictionary> dictionaries = new ConcurrentHashMap();
    @NotNull
    private final EditableAggregatedWordList aggregator = new EditableAggregatedWordList();

    @NotNull
    protected final ConcurrentHashMap<String, Dictionary> getDictionaries() {
        return this.dictionaries;
    }

    @NotNull
    protected final EditableAggregatedWordList getAggregator() {
        return this.aggregator;
    }

    @NotNull
    public final Set<String> getNames() {
        Set<String> set = this.aggregator.getKeys();
        Set set2 = this.dictionaries.keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"<get-keys>(...)");
        return SetsKt.plus(set, (Iterable)set2);
    }

    public final void addDictionary(@NotNull Dictionary dictionary) {
        Intrinsics.checkNotNullParameter((Object)dictionary, (String)"dictionary");
        ((Map)this.dictionaries).put(dictionary.getName(), dictionary);
    }

    public final void addList(@NotNull String name, @NotNull WordList list2) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)list2, (String)"list");
        this.aggregator.addList(name, list2);
    }

    public final boolean containsSource(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.dictionaries.containsKey(name) || this.aggregator.containsList(name);
    }

    public final void removeSource(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.dictionaries.remove(name);
        this.aggregator.removeList(name);
    }

    public final void reset() {
        this.dictionaries.clear();
        this.aggregator.clear();
    }
}

