/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.qodana.sarif.baseline;

import com.jetbrains.qodana.sarif.baseline.DescriptorWithLocation;
import com.jetbrains.qodana.sarif.model.ReportingDescriptor;
import com.jetbrains.qodana.sarif.model.Run;
import com.jetbrains.qodana.sarif.model.Tool;
import com.jetbrains.qodana.sarif.model.ToolComponent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;

final class DescriptorLookup {
    private final Map<String, DescriptorWithLocation> lookup = new HashMap<String, DescriptorWithLocation>();
    private final Supplier<Stream<DescriptorWithLocation>> descriptors = () -> this.descriptors(run2);

    DescriptorLookup(Run run2) {
    }

    DescriptorWithLocation findById(String ruleId) {
        return this.lookup.computeIfAbsent(ruleId, id -> this.descriptors.get().filter(r -> Objects.equals(r.getDescriptor().getId(), id)).findFirst().orElse(null));
    }

    private Stream<DescriptorWithLocation> descriptors(Run run2) {
        Stream driverRules = Optional.ofNullable(run2.getTool()).map(Tool::getDriver).map(driver -> {
            Stream<ReportingDescriptor> s = driver.getRules() == null ? Stream.empty() : driver.getRules().stream();
            return s.map(r -> new DescriptorWithLocation((ReportingDescriptor)r, (ToolComponent)driver));
        }).orElseGet(Stream::empty);
        Stream extRules = Optional.ofNullable(run2.getTool()).map(Tool::getExtensions).orElseGet(HashSet::new).stream().flatMap(extension -> {
            Stream<ReportingDescriptor> s = extension.getRules() == null ? Stream.empty() : extension.getRules().stream();
            return s.map(r -> new DescriptorWithLocation((ReportingDescriptor)r, (ToolComponent)extension));
        });
        return Stream.concat(driverRules, extRules);
    }
}

