/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.settings.local;

import com.fasterxml.aalto.UncheckedStreamException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SafeStAXStreamBuilderKt;
import com.intellij.platform.settings.local.Chunk;
import com.intellij.platform.settings.local.XmlFileStorageKt;
import com.intellij.util.concurrency.SynchronizedClearableLazy;
import com.intellij.util.xml.dom.XmlDomReader;
import com.intellij.util.xml.dom.XmlElement;
import java.io.Reader;
import java.io.StringReader;
import java.nio.file.Path;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\tJ\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\r\u001a\u00020\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0006\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/platform/settings/local/XmlFileStorage;", "", "file", "Ljava/nio/file/Path;", "<init>", "(Ljava/nio/file/Path;)V", "map", "Lcom/intellij/util/concurrency/SynchronizedClearableLazy;", "", "", "Lcom/intellij/platform/settings/local/Chunk;", "getJdom", "Lorg/jdom/Element;", "key", "get", "Lcom/intellij/util/xml/dom/XmlElement;", "intellij.platform.settings.local"})
@SourceDebugExtension(value={"SMAP\nXmlFileStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XmlFileStorage.kt\ncom/intellij/platform/settings/local/XmlFileStorage\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,135:1\n24#2:136\n24#2:137\n24#2:138\n24#2:139\n*S KotlinDebug\n*F\n+ 1 XmlFileStorage.kt\ncom/intellij/platform/settings/local/XmlFileStorage\n*L\n36#1:136\n39#1:137\n50#1:138\n53#1:139\n*E\n"})
public final class XmlFileStorage {
    @NotNull
    private final Path file;
    @NotNull
    private final SynchronizedClearableLazy<Map<String, Chunk>> map;

    public XmlFileStorage(@NotNull Path file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.file = file;
        this.map = new SynchronizedClearableLazy(() -> XmlFileStorage.map$lambda$0(this));
    }

    @Nullable
    public final Element getJdom(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Chunk chunk = (Chunk)((Map)this.map.getValue()).get(key);
        if (chunk == null) {
            return null;
        }
        Chunk data = chunk;
        try {
            SafeStAXStreamBuilderKt.buildNsUnawareJdom((Reader)new StringReader(data.data));
        }
        catch (XMLStreamException e) {
            XmlFileStorage $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(XmlFileStorage.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn((Throwable)e);
        }
        catch (UncheckedStreamException e) {
            XmlFileStorage $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(XmlFileStorage.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn((Throwable)e);
        }
        return null;
    }

    @Nullable
    public final XmlElement get(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Chunk chunk = (Chunk)((Map)this.map.getValue()).get(key);
        if (chunk == null) {
            return null;
        }
        Chunk data = chunk;
        try {
            return XmlDomReader.readXmlAsModel((Reader)new StringReader(data.data));
        }
        catch (XMLStreamException e) {
            XmlFileStorage $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(XmlFileStorage.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn((Throwable)e);
        }
        catch (UncheckedStreamException e) {
            XmlFileStorage $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(XmlFileStorage.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn((Throwable)e);
        }
        return null;
    }

    private static final Map map$lambda$0(XmlFileStorage this$0) {
        return XmlFileStorageKt.access$readChunks(this$0.file, false);
    }
}

