/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.collection;

import org.eclipse.aether.RepositoryException;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.CollectResult;

public class DependencyCollectionException
extends RepositoryException {
    private final transient CollectResult result;

    public DependencyCollectionException(CollectResult result2) {
        super("Failed to collect dependencies for " + DependencyCollectionException.getSource(result2), DependencyCollectionException.getCause(result2));
        this.result = result2;
    }

    public DependencyCollectionException(CollectResult result2, String message) {
        super(message, DependencyCollectionException.getCause(result2));
        this.result = result2;
    }

    public DependencyCollectionException(CollectResult result2, String message, Throwable cause) {
        super(message, cause);
        this.result = result2;
    }

    public CollectResult getResult() {
        return this.result;
    }

    private static String getSource(CollectResult result2) {
        if (result2 == null) {
            return "";
        }
        CollectRequest request = result2.getRequest();
        if (request.getRoot() != null) {
            return request.getRoot().toString();
        }
        if (request.getRootArtifact() != null) {
            return request.getRootArtifact().toString();
        }
        return request.getDependencies().toString();
    }

    private static Throwable getCause(CollectResult result2) {
        Throwable cause = null;
        if (result2 != null && !result2.getExceptions().isEmpty()) {
            cause = result2.getExceptions().get(0);
        }
        return cause;
    }
}

