/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.css3;

import java.util.ArrayList;
import org.w3c.css.properties.css.CssProperty;
import org.w3c.css.properties.css3.CssBorderBottomWidth;
import org.w3c.css.properties.css3.CssBorderLeftWidth;
import org.w3c.css.properties.css3.CssBorderRightWidth;
import org.w3c.css.properties.css3.CssBorderTopWidth;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssCheckableValue;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssValue;
import org.w3c.css.values.CssValueList;

public class CssBorderWidth
extends org.w3c.css.properties.css.CssBorderWidth {
    public static final CssIdent[] allowed_values;

    public static final CssIdent getAllowedIdent(CssIdent ident) {
        for (CssIdent id : allowed_values) {
            if (!id.equals(ident)) continue;
            return id;
        }
        return null;
    }

    public CssBorderWidth() {
        this.value = initial;
        this.top = new CssBorderTopWidth();
        this.right = new CssBorderRightWidth();
        this.bottom = new CssBorderBottomWidth();
        this.left = new CssBorderLeftWidth();
    }

    public CssBorderWidth(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }

    public CssBorderWidth(ApplContext ac, CssExpression expression, boolean check) throws InvalidParamException {
        if (check && expression.getCount() > 4) {
            throw new InvalidParamException("unrecognize", ac);
        }
        this.setByUser();
        boolean gotCssWide = false;
        ArrayList<CssValue> res = new ArrayList<CssValue>();
        while (res.size() < 4 && !expression.end()) {
            CssValue val = expression.getValue();
            char op = expression.getOperator();
            switch (val.getType()) {
                case 5: {
                    val.getCheckableValue().checkEqualsZero(ac, this);
                    res.add(val);
                    break;
                }
                case 6: {
                    CssCheckableValue length = val.getCheckableValue();
                    length.checkPositiveness(ac, this);
                    res.add(val);
                    break;
                }
                case 0: {
                    CssIdent id = val.getIdent();
                    if (CssIdent.isCssWide(id)) {
                        gotCssWide = true;
                        res.add(id);
                        this.value = val;
                        break;
                    }
                    if (CssBorderWidth.getAllowedIdent(id) == null) {
                        throw new InvalidParamException("value", val, this.getPropertyName(), ac);
                    }
                    res.add(val);
                    break;
                }
                default: {
                    throw new InvalidParamException("value", val, this.getPropertyName(), ac);
                }
            }
            expression.next();
            if (op == ' ') continue;
            throw new InvalidParamException("operator", Character.toString(op), ac);
        }
        if (res.size() > 1 && gotCssWide) {
            throw new InvalidParamException("value", this.value, this.getPropertyName(), ac);
        }
        this.value = res.size() == 1 ? (CssValue)res.get(0) : new CssValueList(res);
        this.top = new CssBorderTopWidth();
        this.right = new CssBorderRightWidth();
        this.bottom = new CssBorderBottomWidth();
        this.left = new CssBorderLeftWidth();
        switch (res.size()) {
            case 1: {
                this.right.value = this.bottom.value = res.get(0);
                this.left.value = this.bottom.value;
                this.top.value = this.bottom.value;
                break;
            }
            case 2: {
                this.top.value = this.bottom.value = res.get(0);
                this.right.value = this.left.value = res.get(1);
                break;
            }
            case 3: {
                this.top.value = res.get(0);
                this.right.value = this.left.value = res.get(1);
                this.bottom.value = res.get(2);
                break;
            }
            case 4: {
                this.top.value = res.get(0);
                this.right.value = res.get(1);
                this.bottom.value = res.get(2);
                this.left.value = res.get(3);
                break;
            }
            default: {
                throw new InvalidParamException("unrecognize", ac);
            }
        }
        this.shorthand = true;
    }

    protected static CssValue parseBorderSideWidth(ApplContext ac, CssExpression expression, boolean check, CssProperty caller) throws InvalidParamException {
        if (check && expression.getCount() > 1) {
            throw new InvalidParamException("unrecognize", ac);
        }
        CssValue retval = null;
        CssValue val = expression.getValue();
        switch (val.getType()) {
            case 5: {
                val.getCheckableValue().checkEqualsZero(ac, caller);
                retval = val;
                break;
            }
            case 6: {
                CssCheckableValue length = val.getCheckableValue();
                length.checkPositiveness(ac, caller);
                retval = val;
                break;
            }
            case 0: {
                CssIdent id = val.getIdent();
                if (CssIdent.isCssWide(id) || CssBorderWidth.getAllowedIdent(id) != null) {
                    retval = val;
                    break;
                }
            }
            default: {
                throw new InvalidParamException("value", expression.getValue(), caller.getPropertyName(), ac);
            }
        }
        expression.next();
        return retval;
    }

    static {
        String[] _allowed_values = new String[]{"thin", "medium", "thick"};
        int i = 0;
        allowed_values = new CssIdent[_allowed_values.length];
        for (String s : _allowed_values) {
            CssBorderWidth.allowed_values[i++] = CssIdent.getIdent(s);
        }
    }
}

