/* riemann/query.h -- Riemann C client library
 * SPDX-FileCopyrightText: 2013-2024 Gergely Nagy
 * SPDX-FileContributor: Gergely Nagy
 *
 * SPDX-License-Identifier: EUPL-1.2
 */

#pragma once

#include <riemann/proto/riemann.pb-c.h>

typedef Query riemann_query_t;

#ifdef __cplusplus
extern "C" {
#endif

riemann_query_t *riemann_query_new (const char *string);
riemann_query_t *riemann_query_clone (const riemann_query_t *query);
void riemann_query_free (riemann_query_t *query);

int riemann_query_set_string (riemann_query_t *query, const char *string);

#ifdef __cplusplus
}
#endif
