/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.duo.api;

import com.google.inject.Inject;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.auth.duo.api.DuoCookie;
import org.apache.guacamole.auth.duo.api.SignedDuoCookie;
import org.apache.guacamole.auth.duo.conf.ConfigurationService;
import org.apache.guacamole.net.auth.AuthenticatedUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DuoService {
    private static final Logger logger = LoggerFactory.getLogger(DuoService.class);
    private static final Pattern RESPONSE_FORMAT = Pattern.compile("([^:]+):([^:]+)");
    private static final int DUO_COOKIE_GROUP = 1;
    private static final int APP_COOKIE_GROUP = 2;
    private static final int COOKIE_EXPIRATION_TIME = 300;
    @Inject
    private ConfigurationService confService;

    public String createSignedRequest(AuthenticatedUser authenticatedUser) throws GuacamoleException {
        DuoCookie cookie = new DuoCookie(authenticatedUser.getIdentifier(), this.confService.getIntegrationKey(), DuoCookie.currentTimestamp() + 300L);
        SignedDuoCookie duoCookie = new SignedDuoCookie(cookie, SignedDuoCookie.Type.DUO_REQUEST, this.confService.getSecretKey());
        SignedDuoCookie appCookie = new SignedDuoCookie(cookie, SignedDuoCookie.Type.APPLICATION, this.confService.getApplicationKey());
        return duoCookie + ":" + appCookie;
    }

    public boolean isValidSignedResponse(AuthenticatedUser authenticatedUser, String signedResponse) throws GuacamoleException {
        SignedDuoCookie appCookie;
        SignedDuoCookie duoCookie;
        String username = authenticatedUser.getIdentifier();
        String applicationKey = this.confService.getApplicationKey();
        String integrationKey = this.confService.getIntegrationKey();
        String secretKey = this.confService.getSecretKey();
        try {
            Matcher matcher = RESPONSE_FORMAT.matcher(signedResponse);
            if (!matcher.matches()) {
                logger.debug("Duo response is not in correct format.");
                return false;
            }
            duoCookie = SignedDuoCookie.parseSignedDuoCookie(secretKey, matcher.group(1));
            appCookie = SignedDuoCookie.parseSignedDuoCookie(applicationKey, matcher.group(2));
        }
        catch (GuacamoleException e) {
            logger.debug("Duo signature verification failed.", (Throwable)e);
            return false;
        }
        if (duoCookie.isExpired() || appCookie.isExpired()) {
            logger.debug("Duo response contained expired cookie(s).");
            return false;
        }
        if (duoCookie.getType() != SignedDuoCookie.Type.DUO_RESPONSE || appCookie.getType() != SignedDuoCookie.Type.APPLICATION) {
            logger.debug("Duo response did not contain correct cookie type(s).");
            return false;
        }
        if (!duoCookie.getIntegrationKey().equals(integrationKey) || !appCookie.getIntegrationKey().equals(integrationKey)) {
            logger.debug("Integration key of Duo response is incorrect.");
            return false;
        }
        if (!duoCookie.getUsername().equals(username) || !appCookie.getUsername().equals(username)) {
            logger.debug("Username of Duo response is incorrect.");
            return false;
        }
        return true;
    }
}

