/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.building;

import java.io.File;
import org.apache.maven.model.Model;
import org.apache.maven.model.building.ModelProblem;

public class ModelProblemUtils {
    static String toSourceHint(Model model) {
        if (model == null) {
            return "";
        }
        StringBuilder buffer2 = new StringBuilder(128);
        buffer2.append(ModelProblemUtils.toId(model));
        File pomFile = model.getPomFile();
        if (pomFile != null) {
            buffer2.append(" (").append(pomFile).append(')');
        }
        return buffer2.toString();
    }

    static String toPath(Model model) {
        File pomFile;
        String path2 = "";
        if (model != null && (pomFile = model.getPomFile()) != null) {
            path2 = pomFile.getAbsolutePath();
        }
        return path2;
    }

    static String toId(Model model) {
        if (model == null) {
            return "";
        }
        String groupId = model.getGroupId();
        if (groupId == null && model.getParent() != null) {
            groupId = model.getParent().getGroupId();
        }
        String artifactId = model.getArtifactId();
        String version = model.getVersion();
        if (version == null && model.getParent() != null) {
            version = model.getParent().getVersion();
        }
        if (version == null) {
            version = "[unknown-version]";
        }
        return ModelProblemUtils.toId(groupId, artifactId, version);
    }

    static String toId(String groupId, String artifactId, String version) {
        StringBuilder buffer2 = new StringBuilder(128);
        buffer2.append(groupId != null && groupId.length() > 0 ? groupId : "[unknown-group-id]");
        buffer2.append(':');
        buffer2.append(artifactId != null && artifactId.length() > 0 ? artifactId : "[unknown-artifact-id]");
        buffer2.append(':');
        buffer2.append(version != null && version.length() > 0 ? version : "[unknown-version]");
        return buffer2.toString();
    }

    public static String formatLocation(ModelProblem problem, String projectId) {
        StringBuilder buffer2 = new StringBuilder(256);
        if (!problem.getModelId().equals(projectId)) {
            buffer2.append(problem.getModelId());
            if (problem.getSource().length() > 0) {
                if (buffer2.length() > 0) {
                    buffer2.append(", ");
                }
                buffer2.append(problem.getSource());
            }
        }
        if (problem.getLineNumber() > 0) {
            if (buffer2.length() > 0) {
                buffer2.append(", ");
            }
            buffer2.append("line ").append(problem.getLineNumber());
        }
        if (problem.getColumnNumber() > 0) {
            if (buffer2.length() > 0) {
                buffer2.append(", ");
            }
            buffer2.append("column ").append(problem.getColumnNumber());
        }
        return buffer2.toString();
    }
}

