/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.Outputter;
import org.apache.commons.cli.Options;

public class DeleteNetworkInterface
extends BaseCmd {
    private String networkInterfaceId;

    public DeleteNetworkInterface(String[] args) {
        super("ec2delnic", "ec2-delete-network-interface");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    @Override
    protected String getOptionString() {
        return "NETWORKINTERFACE";
    }

    private Options getOptions() {
        return new Options();
    }

    @Override
    public void printDescription() {
        super.printDescription();
        System.out.println("     Deletes a network interface.");
    }

    @Override
    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        this.validateParameters();
        this.networkInterfaceId = this.getNonOptions()[0];
        RequestResultPair rsp = jec2.deleteNetworkInterface(this.networkInterfaceId);
        if (((Boolean)rsp.getResponse()).booleanValue()) {
            out.outputObjectId(System.out, "NETWORKINTERFACE", this.networkInterfaceId);
        }
        out.printRequestId(System.out, (RequestResult)rsp);
        return (Boolean)rsp.getResponse();
    }

    @Override
    protected void parseOpts(String[] args) {
        super.parseOpts(args);
    }

    protected void validateParameters() {
        this.assertNonOptionSet("NETWORKINTERFACE");
        this.warnIfTooManyNonOptions();
    }

    public static void main(String[] args) {
        new DeleteNetworkInterface(args).invoke();
    }
}

