/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.readline.action;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.Queue;
import org.aesh.readline.action.KeyAction;
import org.aesh.readline.editing.EditMode;
import org.aesh.readline.terminal.Key;

public class ActionDecoder {
    private KeyAction[] mappings;
    private final Queue<KeyAction> actions = new LinkedList<KeyAction>();
    private int[] buffer = new int[0];

    public ActionDecoder(EditMode editMode) {
        this.mappings = editMode.keys();
    }

    public ActionDecoder() {
        this.mappings = Key.values();
    }

    public void add(int[] input) {
        this.buffer = Arrays.copyOf(this.buffer, this.buffer.length + input.length);
        System.arraycopy(input, 0, this.buffer, this.buffer.length - input.length, input.length);
    }

    public void add(int input) {
        this.buffer = Arrays.copyOf(this.buffer, this.buffer.length + 1);
        System.arraycopy(new int[]{input}, 0, this.buffer, this.buffer.length - 1, 1);
    }

    public KeyAction peek() {
        if (this.actions.isEmpty()) {
            return this.parse(this.buffer);
        }
        return this.actions.peek();
    }

    public boolean hasNext() {
        return this.peek() != null;
    }

    public KeyAction next() {
        KeyAction next;
        if (this.actions.isEmpty() && (next = this.parse(this.buffer)) != null) {
            this.actions.add(next);
            this.buffer = Arrays.copyOfRange(this.buffer, next.length(), this.buffer.length);
        }
        return this.actions.remove();
    }

    public void setMappings(EditMode editMode) {
        this.mappings = editMode.keys();
    }

    private KeyAction parse(int[] buffer) {
        if (buffer.length > 0) {
            KeyAction candidate = null;
            int prefixes = 0;
            block0: for (KeyAction action : this.mappings) {
                int i;
                if (action.length() <= 0) continue;
                if (action.length() <= buffer.length) {
                    for (i = 0; i < action.length(); ++i) {
                        if (action.getCodePointAt(i) != buffer[i]) continue block0;
                    }
                    if (candidate != null && candidate.length() > action.length()) continue;
                    candidate = action;
                    continue;
                }
                for (i = 0; i < buffer.length; ++i) {
                    if (action.getCodePointAt(i) != buffer[i]) continue block0;
                }
                ++prefixes;
            }
            if (candidate == null) {
                if (prefixes == 0) {
                    return new DefaultKeyAction(buffer[0]);
                }
            } else {
                return candidate;
            }
        }
        return null;
    }

    private class DefaultKeyAction
    implements KeyAction {
        private final int code;

        DefaultKeyAction(int i) {
            this.code = i;
        }

        @Override
        public int getCodePointAt(int index) throws IndexOutOfBoundsException {
            if (index != 0) {
                throw new IndexOutOfBoundsException("Index greater than 0");
            }
            return this.code;
        }

        @Override
        public int length() {
            return 1;
        }

        @Override
        public String name() {
            return "key: " + this.code;
        }
    }
}

