/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.rtp.rtcp.rtcpfb.transport_layer_fb;

import java.util.List;
import java.util.SortedSet;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jitsi.rtp.extensions.bytearray.ByteArrayExtensionsKt;
import org.jitsi.rtp.extensions.unsigned.UnsignedKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0017\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0004R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000f"}, d2={"Lorg/jitsi/rtp/rtcp/rtcpfb/transport_layer_fb/NackBlock;", "", "missingSeqNums", "Ljava/util/SortedSet;", "", "<init>", "(Ljava/util/SortedSet;)V", "getMissingSeqNums", "()Ljava/util/SortedSet;", "writeTo", "", "buf", "", "offset", "Companion", "rtp"})
final class NackBlock {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SortedSet<Integer> missingSeqNums;
    public static final int SIZE_BYTES = 4;

    public NackBlock(@NotNull SortedSet<Integer> missingSeqNums) {
        Intrinsics.checkNotNullParameter(missingSeqNums, "missingSeqNums");
        this.missingSeqNums = missingSeqNums;
    }

    public /* synthetic */ NackBlock(SortedSet sortedSet, int n, DefaultConstructorMarker defaultConstructorMarker2) {
        if ((n & 1) != 0) {
            sortedSet = SetsKt.sortedSetOf(new Integer[0]);
        }
        this(sortedSet);
    }

    @NotNull
    public final SortedSet<Integer> getMissingSeqNums() {
        return this.missingSeqNums;
    }

    public final void writeTo(@NotNull byte[] buf, int offset) {
        Intrinsics.checkNotNullParameter(buf, "buf");
        Companion.putMissingSeqNums(buf, offset, this.missingSeqNums);
    }

    public NackBlock() {
        this(null, 1, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005J$\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jitsi/rtp/rtcp/rtcpfb/transport_layer_fb/NackBlock$Companion;", "", "<init>", "()V", "SIZE_BYTES", "", "getMissingSeqNums", "", "buf", "", "offset", "putMissingSeqNums", "", "missingSeqNums", "Ljava/util/SortedSet;", "rtp"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<Integer> getMissingSeqNums(@NotNull byte[] buf, int offset) {
            Intrinsics.checkNotNullParameter(buf, "buf");
            int packetId = UnsignedKt.toPositiveInt(ByteArrayExtensionsKt.getShort(buf, offset + 0));
            int blp = UnsignedKt.toPositiveInt(ByteArrayExtensionsKt.getShort(buf, offset + 2));
            Integer[] integerArray = new Integer[]{packetId};
            List<Integer> missingSeqNums = CollectionsKt.mutableListOf(integerArray);
            for (int shiftAmount = 0; shiftAmount < 16; ++shiftAmount) {
                if ((blp >>> shiftAmount & 1) != 1) continue;
                missingSeqNums.add(packetId + shiftAmount + 1 & 0xFFFF);
            }
            return missingSeqNums;
        }

        public final void putMissingSeqNums(@NotNull byte[] buf, int offset, @NotNull SortedSet<Integer> missingSeqNums) {
            Intrinsics.checkNotNullParameter(buf, "buf");
            Intrinsics.checkNotNullParameter(missingSeqNums, "missingSeqNums");
            Integer packetId = missingSeqNums.first();
            ByteArrayExtensionsKt.putShort(buf, offset, (short)packetId.intValue());
            int blpField = 0;
            for (int bitPos = 16; 0 < bitPos; --bitPos) {
                Intrinsics.checkNotNull(packetId);
                if (missingSeqNums.contains(bitPos + packetId)) {
                    blpField |= 1;
                }
                if (bitPos == 1) continue;
                blpField <<= 1;
            }
            ByteArrayExtensionsKt.putShort(buf, offset + 2, (short)blpField);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

