/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.swingui.ArchitectSwingSessionContext;
import ca.sqlpower.architect.swingui.Messages;
import ca.sqlpower.sqlobject.SQLColumn;
import ca.sqlpower.sqlobject.SQLType;
import ca.sqlpower.swingui.DataEntryPanel;
import ca.sqlpower.swingui.SPSUtils;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import org.apache.log4j.Logger;

public class DefaultColumnPanel
extends JPanel
implements ActionListener,
DataEntryPanel {
    private static final Logger logger = Logger.getLogger(DefaultColumnPanel.class);
    private static final Font TITLE_FONT = UIManager.getFont("Label.font").deriveFont(1, 15.0f);
    private JTextField colName;
    private JComboBox colType;
    private JSpinner colPrec;
    private JSpinner colScale;
    private JCheckBox colInPK;
    private JCheckBox colNullable;
    private JCheckBox colAutoInc;
    private JTextArea colRemarks;
    private JTextArea colDefault;

    public DefaultColumnPanel(ArchitectSwingSessionContext context) {
        this.setUp();
        this.revertToUserSettings();
    }

    public void setUp() {
        FormLayout layout = new FormLayout("30dlu, pref:grow, 20dlu, pref:grow, 30dlu", "");
        layout.setColumnGroups((int[][])new int[][]{{2, 4}});
        CellConstraints cc = new CellConstraints();
        this.setLayout((LayoutManager)layout);
        int row = 1;
        layout.appendRow(RowSpec.decode((String)"10dlu"));
        layout.appendRow(RowSpec.decode((String)"p"));
        int n = ++row;
        ++row;
        this.add(this.makeTitle(Messages.getString("DefaultColumnPanel.explaination")), cc.xyw(2, n, 3));
        layout.appendRow(RowSpec.decode((String)"15dlu"));
        layout.appendRow(RowSpec.decode((String)"p"));
        this.add((Component)new JLabel(Messages.getString("DefaultColumnPanel.name")), cc.xy(2, ++row));
        this.add((Component)new JLabel(Messages.getString("DefaultColumnPanel.type")), cc.xy(4, row++));
        layout.appendRow(RowSpec.decode((String)"5dlu"));
        layout.appendRow(RowSpec.decode((String)"p"));
        this.colName = new JTextField();
        this.add((Component)this.colName, cc.xy(2, ++row));
        this.colName.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                DefaultColumnPanel.this.colName.requestFocusInWindow();
            }
        });
        this.colName.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("focus Gained : " + e));
                }
                DefaultColumnPanel.this.colName.selectAll();
            }
        });
        this.colType = new JComboBox<SQLType>(SQLType.getTypes());
        this.add(this.colType, cc.xy(4, row++));
        this.colType.setSelectedItem(null);
        layout.appendRow(RowSpec.decode((String)"15dlu"));
        layout.appendRow(RowSpec.decode((String)"p"));
        this.add((Component)new JLabel(Messages.getString("DefaultColumnPanel.precision")), cc.xy(2, ++row));
        this.add((Component)new JLabel(Messages.getString("DefaultColumnPanel.scale")), cc.xy(4, row++));
        layout.appendRow(RowSpec.decode((String)"5dlu"));
        layout.appendRow(RowSpec.decode((String)"p"));
        this.colPrec = new JSpinner(new SpinnerNumberModel(0, 0, Integer.MAX_VALUE, 1));
        this.add((Component)this.colPrec, cc.xy(2, ++row));
        SPSUtils.makeJSpinnerSelectAllTextOnFocus((JSpinner)this.colPrec);
        this.colScale = new JSpinner(new SpinnerNumberModel(0, 0, Integer.MAX_VALUE, 1));
        this.add((Component)this.colScale, cc.xy(4, row++));
        SPSUtils.makeJSpinnerSelectAllTextOnFocus((JSpinner)this.colScale);
        layout.appendRow(RowSpec.decode((String)"15dlu"));
        layout.appendRow(RowSpec.decode((String)"p"));
        this.colInPK = new JCheckBox(Messages.getString("DefaultColumnPanel.inPrimaryKey"));
        int n2 = ++row;
        ++row;
        this.add((Component)this.colInPK, cc.xyw(2, n2, 3));
        this.colInPK.addActionListener(this);
        layout.appendRow(RowSpec.decode((String)"15dlu"));
        layout.appendRow(RowSpec.decode((String)"p"));
        this.colNullable = new JCheckBox(Messages.getString("DefaultColumnPanel.allowsNulls"));
        int n3 = ++row;
        ++row;
        this.add((Component)this.colNullable, cc.xyw(2, n3, 3));
        this.colNullable.addActionListener(this);
        layout.appendRow(RowSpec.decode((String)"15dlu"));
        layout.appendRow(RowSpec.decode((String)"p"));
        this.colAutoInc = new JCheckBox(Messages.getString("DefaultColumnPanel.autoIncrement"));
        int n4 = ++row;
        ++row;
        this.add((Component)this.colAutoInc, cc.xyw(2, n4, 3));
        this.colAutoInc.addActionListener(this);
        layout.appendRow(RowSpec.decode((String)"15dlu"));
        layout.appendRow(RowSpec.decode((String)"p"));
        int n5 = ++row;
        ++row;
        this.add((Component)new JLabel(Messages.getString("DefaultColumnPanel.remarks")), cc.xyw(2, n5, 4));
        layout.appendRow(RowSpec.decode((String)"5dlu"));
        layout.appendRow(RowSpec.decode((String)"p"));
        this.colRemarks = new JTextArea();
        int n6 = ++row;
        ++row;
        this.add((Component)new JScrollPane(this.colRemarks), cc.xyw(2, n6, 3, "fill, fill"));
        this.colRemarks.setRows(8);
        this.colRemarks.setLineWrap(true);
        this.colRemarks.setWrapStyleWord(true);
        layout.appendRow(RowSpec.decode((String)"15dlu"));
        layout.appendRow(RowSpec.decode((String)"p"));
        int n7 = ++row;
        ++row;
        this.add((Component)new JLabel(Messages.getString("DefaultColumnPanel.default")), cc.xyw(2, n7, 4));
        layout.appendRow(RowSpec.decode((String)"5dlu"));
        layout.appendRow(RowSpec.decode((String)"p"));
        this.colDefault = new JTextArea();
        int n8 = ++row;
        ++row;
        this.add((Component)new JScrollPane(this.colDefault), cc.xyw(2, n8, 3));
        this.colDefault.setLineWrap(false);
        layout.appendRow(RowSpec.decode((String)"15dlu"));
        ++row;
        this.colName.requestFocus();
        this.colName.selectAll();
    }

    protected void revertToUserSettings() {
        logger.debug((Object)"Reverting to default settings");
        this.colName.setText(SQLColumn.getDefaultName());
        this.colPrec.setValue(SQLColumn.getDefaultPrec());
        this.colType.setSelectedItem(SQLType.getType((int)SQLColumn.getDefaultType()));
        this.colScale.setValue(SQLColumn.getDefaultScale());
        this.colInPK.setSelected(SQLColumn.isDefaultInPK());
        this.colNullable.setSelected(SQLColumn.isDefaultNullable());
        this.colAutoInc.setSelected(SQLColumn.isDefaultAutoInc());
        this.colRemarks.setText(SQLColumn.getDefaultRemarks());
        this.colDefault.setText(SQLColumn.getDefaultForDefaultValue());
        this.updateComponents();
    }

    public boolean applyChanges() {
        logger.debug((Object)"DefaultColumnPanel applyChanges");
        logger.debug((Object)this.colName.getText().trim().equals(""));
        SQLColumn.setDefaultName((String)this.colName.getText());
        if (this.colType.getSelectedItem() != null) {
            SQLColumn.setDefaultType((int)((SQLType)this.colType.getSelectedItem()).getType());
        } else {
            SQLColumn.setDefaultType((int)12);
        }
        SQLColumn.setDefaultPrec((int)((Integer)this.colPrec.getValue()));
        SQLColumn.setDefaultScale((int)((Integer)this.colScale.getValue()));
        SQLColumn.setDefaultInPK((boolean)this.colInPK.isSelected());
        SQLColumn.setDefaultNullable((boolean)this.colNullable.isSelected());
        SQLColumn.setDefaultAutoInc((boolean)this.colAutoInc.isSelected());
        SQLColumn.setDefaultRemarks((String)this.colRemarks.getText());
        SQLColumn.setDefaultForDefaultValue((String)this.colDefault.getText());
        return true;
    }

    public void discardChanges() {
        this.revertToUserSettings();
    }

    public JComponent getPanel() {
        return this;
    }

    public boolean hasUnsavedChanges() {
        return true;
    }

    private Component makeTitle(String string) {
        JLabel label = new JLabel(string);
        label.setFont(TITLE_FONT);
        return label;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        logger.debug((Object)("action event " + e));
        this.updateComponents();
    }

    private void updateComponents() {
        if (this.colInPK.isSelected()) {
            this.colNullable.setEnabled(false);
        } else {
            this.colNullable.setEnabled(true);
        }
        if (this.colNullable.isSelected()) {
            this.colInPK.setEnabled(false);
        } else {
            this.colInPK.setEnabled(true);
        }
        if (this.colInPK.isSelected() && this.colNullable.isSelected()) {
            this.colNullable.setSelected(false);
            this.colNullable.setEnabled(false);
        }
        if (this.colAutoInc.isSelected()) {
            this.colDefault.setText("");
            this.colDefault.setEnabled(false);
        } else {
            this.colDefault.setEnabled(true);
        }
    }
}

