/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.mergejoin;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Counter;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.mergejoin.MergeJoin;
import org.pentaho.di.trans.steps.mergejoin.MergeJoinData;
import org.pentaho.di.trans.steps.mergejoin.Messages;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergeJoinMeta
extends BaseStepMeta
implements StepMetaInterface {
    public static final String[] join_types = new String[]{"INNER", "LEFT OUTER", "RIGHT OUTER", "FULL OUTER"};
    public static final boolean[] one_optionals = new boolean[]{false, false, true, true};
    public static final boolean[] two_optionals = new boolean[]{false, true, false, true};
    private String joinType;
    private String stepName1;
    private StepMeta stepMeta1;
    private String stepName2;
    private StepMeta stepMeta2;
    private String[] keyFields1;
    private String[] keyFields2;

    public String getJoinType() {
        return this.joinType;
    }

    public void setJoinType(String joinType) {
        this.joinType = joinType;
    }

    public String[] getKeyFields1() {
        return this.keyFields1;
    }

    public void setKeyFields1(String[] keyFields1) {
        this.keyFields1 = keyFields1;
    }

    public String[] getKeyFields2() {
        return this.keyFields2;
    }

    public void setKeyFields2(String[] keyFields2) {
        this.keyFields2 = keyFields2;
    }

    @Override
    public boolean excludeFromRowLayoutVerification() {
        return true;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleXMLException {
        this.readData(stepnode);
    }

    public String getStepName1() {
        if (this.stepMeta1 != null && this.stepMeta1.getName() != null && this.stepMeta1.getName().length() > 0) {
            return this.stepMeta1.getName();
        }
        return null;
    }

    public String getStepName2() {
        if (this.stepMeta2 != null && this.stepMeta2.getName() != null && this.stepMeta2.getName().length() > 0) {
            return this.stepMeta2.getName();
        }
        return null;
    }

    public void setStepName1(String stepName1) {
        this.stepName1 = stepName1;
    }

    public void setStepName2(String stepName2) {
        this.stepName2 = stepName2;
    }

    public StepMeta getStepMeta1() {
        return this.stepMeta1;
    }

    public StepMeta getStepMeta2() {
        return this.stepMeta2;
    }

    public void setStepMeta1(StepMeta stepMeta1) {
        this.stepMeta1 = stepMeta1;
    }

    public void setStepMeta2(StepMeta stepMeta2) {
        this.stepMeta2 = stepMeta2;
    }

    public void allocate(int nrKeys1, int nrKeys2) {
        this.keyFields1 = new String[nrKeys1];
        this.keyFields2 = new String[nrKeys2];
    }

    @Override
    public Object clone() {
        MergeJoinMeta retval = (MergeJoinMeta)super.clone();
        return retval;
    }

    @Override
    public String getXML() {
        int i;
        StringBuffer retval = new StringBuffer();
        retval.append(XMLHandler.addTagValue((String)"join_type", (String)this.getJoinType()));
        retval.append(XMLHandler.addTagValue((String)"step1", (String)this.getStepName1()));
        retval.append(XMLHandler.addTagValue((String)"step2", (String)this.getStepName2()));
        retval.append("    <keys_1>" + Const.CR);
        for (i = 0; i < this.keyFields1.length; ++i) {
            retval.append("      " + XMLHandler.addTagValue((String)"key", (String)this.keyFields1[i]));
        }
        retval.append("    </keys_1>" + Const.CR);
        retval.append("    <keys_2>" + Const.CR);
        for (i = 0; i < this.keyFields2.length; ++i) {
            retval.append("      " + XMLHandler.addTagValue((String)"key", (String)this.keyFields2[i]));
        }
        retval.append("    </keys_2>" + Const.CR);
        return retval.toString();
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            Node keynode;
            int i;
            Node keysNode1 = XMLHandler.getSubNode((Node)stepnode, (String)"keys_1");
            Node keysNode2 = XMLHandler.getSubNode((Node)stepnode, (String)"keys_2");
            int nrKeys1 = XMLHandler.countNodes((Node)keysNode1, (String)"key");
            int nrKeys2 = XMLHandler.countNodes((Node)keysNode2, (String)"key");
            this.allocate(nrKeys1, nrKeys2);
            for (i = 0; i < nrKeys1; ++i) {
                keynode = XMLHandler.getSubNodeByNr((Node)keysNode1, (String)"key", (int)i);
                this.keyFields1[i] = XMLHandler.getNodeValue((Node)keynode);
            }
            for (i = 0; i < nrKeys2; ++i) {
                keynode = XMLHandler.getSubNodeByNr((Node)keysNode2, (String)"key", (int)i);
                this.keyFields2[i] = XMLHandler.getNodeValue((Node)keynode);
            }
            this.stepName1 = XMLHandler.getTagValue((Node)stepnode, (String)"step1");
            this.stepName2 = XMLHandler.getTagValue((Node)stepnode, (String)"step2");
            this.joinType = XMLHandler.getTagValue((Node)stepnode, (String)"join_type");
        }
        catch (Exception e) {
            throw new KettleXMLException(Messages.getString("MergeJoinMeta.Exception.UnableToLoadStepInfo"), (Throwable)e);
        }
    }

    @Override
    public void setDefault() {
        this.joinType = join_types[0];
        this.allocate(0, 0);
    }

    @Override
    public void readRep(Repository rep, long id_step, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleException {
        try {
            int i;
            int nrKeys1 = rep.countNrStepAttributes(id_step, "keys_1");
            int nrKeys2 = rep.countNrStepAttributes(id_step, "keys_2");
            this.allocate(nrKeys1, nrKeys2);
            for (i = 0; i < nrKeys1; ++i) {
                this.keyFields1[i] = rep.getStepAttributeString(id_step, i, "keys_1");
            }
            for (i = 0; i < nrKeys2; ++i) {
                this.keyFields2[i] = rep.getStepAttributeString(id_step, i, "keys_2");
            }
            this.stepName1 = rep.getStepAttributeString(id_step, "step1");
            this.stepName2 = rep.getStepAttributeString(id_step, "step2");
            this.joinType = rep.getStepAttributeString(id_step, "join_type");
        }
        catch (Exception e) {
            throw new KettleException(Messages.getString("MergeJoinMeta.Exception.UnexpectedErrorReadingStepInfo"), (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_transformation, long id_step) throws KettleException {
        try {
            int i;
            for (i = 0; i < this.keyFields1.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "keys_1", this.keyFields1[i]);
            }
            for (i = 0; i < this.keyFields2.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "keys_2", this.keyFields2[i]);
            }
            rep.saveStepAttribute(id_transformation, id_step, "step1", this.getStepName1());
            rep.saveStepAttribute(id_transformation, id_step, "step2", this.getStepName2());
            rep.saveStepAttribute(id_transformation, id_step, "join_type", this.getJoinType());
        }
        catch (Exception e) {
            throw new KettleException(Messages.getString("MergeJoinMeta.Exception.UnableToSaveStepInfo") + id_step, (Throwable)e);
        }
    }

    @Override
    public void searchInfoAndTargetSteps(List<StepMeta> steps) {
        this.stepMeta1 = StepMeta.findStep(steps, this.stepName1);
        this.stepMeta2 = StepMeta.findStep(steps, this.stepName2);
    }

    @Override
    public String[] getInfoSteps() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.stepMeta1 != null) {
            list.add(this.stepMeta1.getName());
        }
        if (this.stepMeta2 != null) {
            list.add(this.stepMeta2.getName());
        }
        if (list.isEmpty()) {
            return null;
        }
        return list.toArray(new String[list.size()]);
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepinfo, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info) {
        CheckResult cr = new CheckResult(3, Messages.getString("MergeJoinMeta.CheckResult.StepNotVerified"), (CheckResultSourceInterface)stepinfo);
        remarks.add((CheckResultInterface)cr);
    }

    @Override
    public void getFields(RowMetaInterface r, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space) throws KettleStepException {
        int i;
        if (info != null) {
            for (i = 0; i < info.length; ++i) {
                if (info[i] == null) continue;
                r.mergeRowMeta(info[i]);
            }
        }
        for (i = 0; i < r.size(); ++i) {
            r.getValueMeta(i).setOrigin(name);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta tr, Trans trans) {
        return new MergeJoin(stepMeta, stepDataInterface, cnr, tr, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new MergeJoinData();
    }
}

